/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class LookupTranslator
extends CharSequenceTranslator {
    private final Map<String, String> lookupMap;
    private final BitSet prefixSet;
    private final int shortest;
    private final int longest;

    public LookupTranslator(Map<CharSequence, CharSequence> lookupMap) {
        if (lookupMap == null) {
            throw new InvalidParameterException("lookupMap cannot be null");
        }
        this.lookupMap = new HashMap<String, String>();
        this.prefixSet = new BitSet();
        int currentShortest = Integer.MAX_VALUE;
        int currentLongest = 0;
        for (Map.Entry<CharSequence, CharSequence> pair : lookupMap.entrySet()) {
            this.lookupMap.put(pair.getKey().toString(), pair.getValue().toString());
            this.prefixSet.set(pair.getKey().charAt(0));
            int sz = pair.getKey().length();
            if (sz < currentShortest) {
                currentShortest = sz;
            }
            if (sz <= currentLongest) continue;
            currentLongest = sz;
        }
        this.shortest = currentShortest;
        this.longest = currentLongest;
    }

    @Override
    public int translate(CharSequence input2, int index, Writer out) throws IOException {
        if (this.prefixSet.get(input2.charAt(index))) {
            int max = this.longest;
            if (index + this.longest > input2.length()) {
                max = input2.length() - index;
            }
            for (int i2 = max; i2 >= this.shortest; --i2) {
                CharSequence subSeq = input2.subSequence(index, index + i2);
                String result2 = this.lookupMap.get(subSeq.toString());
                if (result2 == null) continue;
                out.write(result2);
                return i2;
            }
        }
        return 0;
    }
}

