/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.util.TipDialog;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.exceptons.NoSdkException;
import training.project.ProjectUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00070\u000fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltraining/learn/NewLearnProjectUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createLearnProject", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "langSupport", "Ltraining/lang/LangSupport;", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "showDialogOpenLearnProject", "", "project", "intellij.featuresTrainer"})
public final class NewLearnProjectUtil {
    private static final Logger LOG;
    @NotNull
    public static final NewLearnProjectUtil INSTANCE;

    public final void createLearnProject(@Nullable Project projectToClose, @NotNull LangSupport langSupport2, @Nullable Sdk selectedSdk, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean unitTestMode = application.isUnitTestMode();
        ProjectUtils.INSTANCE.importOrOpenProject(langSupport2, projectToClose, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(langSupport2, selectedSdk, unitTestMode, postInitCallback){
            final /* synthetic */ LangSupport $langSupport;
            final /* synthetic */ Sdk $selectedSdk;
            final /* synthetic */ boolean $unitTestMode;
            final /* synthetic */ Function1 $postInitCallback;

            public final void invoke(@NotNull Project newProject) {
                Intrinsics.checkNotNullParameter((Object)newProject, (String)"newProject");
                TipDialog.DISABLE_TIPS_FOR_PROJECT.set((UserDataHolder)newProject, (Object)true);
                CodeStyle.setMainProjectSettings((Project)newProject, (CodeStyleSettings)CodeStyleSettings.getDefaults());
                try {
                    Sdk sdkForProject = this.$langSupport.getSdkForProject(newProject, this.$selectedSdk);
                    if (sdkForProject != null) {
                        this.$langSupport.applyProjectSdk(sdkForProject, newProject);
                    }
                }
                catch (NoSdkException e) {
                    NewLearnProjectUtil.access$getLOG$p(NewLearnProjectUtil.INSTANCE).error((Throwable)e);
                }
                if (!this.$unitTestMode) {
                    newProject.save();
                }
                newProject.save();
                this.$postInitCallback.invoke((Object)newProject);
            }
            {
                this.$langSupport = langSupport2;
                this.$selectedSdk = sdk;
                this.$unitTestMode = bl;
                this.$postInitCallback = function1;
                super(1);
            }
        }));
    }

    public final boolean showDialogOpenLearnProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[1];
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String string = applicationNamesInfo.getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationNamesInfo.getInstance().fullProductName");
        objectArray[0] = string;
        return Messages.showOkCancelDialog((Project)project, (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.message", objectArray), (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.title", new Object[0]), (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.ok", new Object[0]), (String)Messages.getCancelButton(), null) == 0;
    }

    private NewLearnProjectUtil() {
    }

    static {
        NewLearnProjectUtil newLearnProjectUtil;
        INSTANCE = newLearnProjectUtil = new NewLearnProjectUtil();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NewLearnProjectUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p(NewLearnProjectUtil $this) {
        NewLearnProjectUtil newLearnProjectUtil = $this;
        return LOG;
    }
}

