/*
 * Decompiled with CFR 0.152.
 */
package circlet.calendar;

import circlet.calendar.DateCalendarItem;
import circlet.calendar.DateCalendarPage;
import circlet.calendar.DateCalendarStyle;
import circlet.calendar.DateCalendarVmInputs;
import circlet.calendar.DateCalendarVmOutputs;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.Weekday;
import circlet.platform.api.WorkingDaysKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.utils.InfiniteRange;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0016\u0018\u0000 L*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002LMBK\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\u0012\b\u0002\u0010\t\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J$\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J^\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0010\u00101\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b022\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00028\u00000\u00122\n\u00103\u001a\u00060\u0007j\u0002`\b2\u0006\u00104\u001a\u0002052\u0010\u00106\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\nH\u0002J \u00107\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b022\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002J\u001e\u00109\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a2\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u001e\u0010:\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a2\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J(\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0010\u0010<\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b022\u0006\u0010=\u001a\u00020>H\u0002J\u001e\u0010?\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b022\n\u0010@\u001a\u00060\u0007j\u0002`\bH\u0002J \u0010A\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b022\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002J\b\u0010B\u001a\u00020,H\u0002J,\u0010B\u001a\u00020,2\u0012\b\u0002\u0010C\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\n2\u0010\b\u0002\u0010D\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bJ\u0012\u0010E\u001a\u00020,2\n\u0010@\u001a\u00060\u0007j\u0002`\bJ \u0010F\u001a\u00020,2\u000e\u0010D\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\b\b\u0002\u0010G\u001a\u00020>J\b\u0010H\u001a\u00020,H\u0016J\u0016\u0010I\u001a\u00020,2\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\b\u0010J\u001a\u00020,H\u0016J\b\u0010K\u001a\u00020,H\u0002RD\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00028\u00000\u00122\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00028\u00000\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00060\u0007j\u0002`\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010#\u001a\u0018\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R \u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001c\u00a8\u0006N"}, d2={"Lcirclet/calendar/DateCalendarVM;", "ItemContent", "Lcirclet/calendar/DateCalendarVmInputs;", "Lcirclet/calendar/DateCalendarVmOutputs;", "delegate", "Lcirclet/calendar/DateCalendarVM$Delegate;", "selectedDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "datesDisplayRange", "Lruntime/utils/InfiniteRange;", "firstDayOfWeek", "Lkotlin/Function0;", "Lcirclet/platform/api/Weekday;", "style", "Lcirclet/calendar/DateCalendarStyle;", "(Lcirclet/calendar/DateCalendarVM$Delegate;Lcirclet/platform/api/KotlinXDate;Lruntime/utils/InfiniteRange;Lkotlin/jvm/functions/Function0;Lcirclet/calendar/DateCalendarStyle;)V", "value", "", "contentItems", "getContentItems", "()Ljava/util/Map;", "setContentItems", "(Ljava/util/Map;)V", "currentPage", "Lruntime/reactive/MutableProperty;", "Lcirclet/calendar/DateCalendarPage;", "getCurrentPage", "()Lruntime/reactive/MutableProperty;", "fullRange", "getFullRange", "()Lruntime/utils/InfiniteRange;", "initialDate", "getInitialDate", "()Lcirclet/platform/api/KotlinXDate;", "pagesCache", "", "getStyle", "()Lcirclet/calendar/DateCalendarStyle;", "weekdayLabels", "", "", "getWeekdayLabels", "didTapItem", "", "item", "Lcirclet/calendar/DateCalendarItem;", "onPage", "makePageForRange", "pageRange", "Lkotlin/ranges/ClosedRange;", "today", "itemsCount", "", "calendarRange", "nextPageRange", "page", "pageAfter", "pageBefore", "pageForRange", "range", "useCache", "", "pageRangeWithBaseDate", "date", "previousPageRange", "reloadData", "newDisplayRange", "newSelectedDate", "scrollToDate", "setSelectedDate", "focusSelectedRange", "showNextPage", "showPage", "showPreviousPage", "updateWeekdaysIfNeeded", "Companion", "Delegate", "app-state"})
public class DateCalendarVM<ItemContent>
implements DateCalendarVmInputs<ItemContent>,
DateCalendarVmOutputs<ItemContent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Delegate delegate;
    @Nullable
    private KotlinXDate selectedDate;
    @NotNull
    private InfiniteRange<KotlinXDate> datesDisplayRange;
    @NotNull
    private final Function0<Weekday> firstDayOfWeek;
    @NotNull
    private final DateCalendarStyle style;
    @NotNull
    private final Map<KotlinXDate, DateCalendarPage<ItemContent>> pagesCache;
    @NotNull
    private Map<KotlinXDate, ? extends ItemContent> contentItems;
    @NotNull
    private final MutableProperty<DateCalendarPage<ItemContent>> currentPage;
    @NotNull
    private final MutableProperty<List<String>> weekdayLabels;
    public static final int numberOfLinesForMonth = 6;

    public DateCalendarVM(@Nullable Delegate delegate, @Nullable KotlinXDate selectedDate, @NotNull InfiniteRange<KotlinXDate> datesDisplayRange, @NotNull Function0<? extends Weekday> firstDayOfWeek, @NotNull DateCalendarStyle style) {
        Intrinsics.checkNotNullParameter(datesDisplayRange, (String)"datesDisplayRange");
        Intrinsics.checkNotNullParameter(firstDayOfWeek, (String)"firstDayOfWeek");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        this.delegate = delegate;
        this.selectedDate = selectedDate;
        this.datesDisplayRange = datesDisplayRange;
        this.firstDayOfWeek = firstDayOfWeek;
        this.style = style;
        boolean bl = false;
        this.pagesCache = new LinkedHashMap();
        this.contentItems = MapsKt.emptyMap();
        this.weekdayLabels = CellableKt.mutableProperty(CollectionsKt.emptyList());
        this.updateWeekdaysIfNeeded();
        ClosedRange<KotlinXDate> initialRange = this.pageRangeWithBaseDate(this.getInitialDate());
        this.currentPage = CellableKt.mutableProperty(this.pageForRange(initialRange, true));
    }

    public /* synthetic */ DateCalendarVM(Delegate delegate, KotlinXDate kotlinXDate, InfiniteRange infiniteRange, Function0 function0, DateCalendarStyle dateCalendarStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kotlinXDate = null;
        }
        if ((n & 4) != 0) {
            infiniteRange = new InfiniteRange(null, null, 3, null);
        }
        this(delegate, kotlinXDate, infiniteRange, (Function0<? extends Weekday>)function0, dateCalendarStyle);
    }

    @Override
    @NotNull
    public DateCalendarStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final InfiniteRange<KotlinXDate> getFullRange() {
        return this.datesDisplayRange;
    }

    @NotNull
    public final Map<KotlinXDate, ItemContent> getContentItems() {
        return this.contentItems;
    }

    public final void setContentItems(@NotNull Map<KotlinXDate, ? extends ItemContent> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.contentItems = value2;
        this.reloadData();
    }

    @Override
    @NotNull
    public MutableProperty<DateCalendarPage<ItemContent>> getCurrentPage() {
        return this.currentPage;
    }

    @NotNull
    public MutableProperty<List<String>> getWeekdayLabels() {
        return this.weekdayLabels;
    }

    public final void setSelectedDate(@Nullable KotlinXDate newSelectedDate, boolean focusSelectedRange) {
        ClosedRange<KotlinXDate> range3 = ((DateCalendarPage)this.getCurrentPage().getValue()).getRange();
        if (!Intrinsics.areEqual((Object)this.selectedDate, (Object)newSelectedDate)) {
            this.pagesCache.clear();
            this.selectedDate = newSelectedDate;
        }
        if (focusSelectedRange && newSelectedDate != null) {
            range3 = this.pageRangeWithBaseDate(newSelectedDate);
        }
        this.getCurrentPage().setValue(this.pageForRange(range3, true));
    }

    public static /* synthetic */ void setSelectedDate$default(DateCalendarVM dateCalendarVM, KotlinXDate kotlinXDate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setSelectedDate");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        dateCalendarVM.setSelectedDate(kotlinXDate, bl);
    }

    public final void scrollToDate(@NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        if (!this.datesDisplayRange.contains((KotlinXDate)((Comparable)date2))) {
            return;
        }
        ClosedRange<KotlinXDate> range3 = this.pageRangeWithBaseDate(date2);
        if (!Intrinsics.areEqual(range3, ((DateCalendarPage)this.getCurrentPage().getValue()).getRange())) {
            this.getCurrentPage().setValue(this.pageForRange(range3, true));
        }
    }

    public final void reloadData(@NotNull InfiniteRange<KotlinXDate> newDisplayRange, @Nullable KotlinXDate newSelectedDate) {
        KotlinXDate kotlinXDate;
        Intrinsics.checkNotNullParameter(newDisplayRange, (String)"newDisplayRange");
        this.pagesCache.clear();
        ClosedRange<KotlinXDate> range3 = !Intrinsics.areEqual((Object)newSelectedDate, (Object)this.selectedDate) ? this.pageRangeWithBaseDate((kotlinXDate = newSelectedDate) == null ? ADateJvmKt.getToday() : kotlinXDate) : (newDisplayRange.intersects(((DateCalendarPage)this.getCurrentPage().getValue()).getRange()) ? ((DateCalendarPage)this.getCurrentPage().getValue()).getRange() : this.pageRangeWithBaseDate((kotlinXDate = newSelectedDate) == null ? ADateJvmKt.getToday() : kotlinXDate));
        this.selectedDate = newSelectedDate;
        this.datesDisplayRange = newDisplayRange;
        this.getCurrentPage().setValue(this.pageForRange(range3, true));
    }

    public static /* synthetic */ void reloadData$default(DateCalendarVM dateCalendarVM, InfiniteRange infiniteRange, KotlinXDate kotlinXDate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadData");
        }
        if ((n & 1) != 0) {
            infiniteRange = dateCalendarVM.datesDisplayRange;
        }
        if ((n & 2) != 0) {
            kotlinXDate = dateCalendarVM.selectedDate;
        }
        dateCalendarVM.reloadData(infiniteRange, kotlinXDate);
    }

    @Override
    public void showNextPage() {
        DateCalendarPage<ItemContent> dateCalendarPage = this.pageAfter((DateCalendarPage)this.getCurrentPage().getValue());
        if (dateCalendarPage != null) {
            DateCalendarPage<ItemContent> dateCalendarPage2 = dateCalendarPage;
            boolean bl = false;
            boolean bl2 = false;
            DateCalendarPage<ItemContent> it = dateCalendarPage2;
            boolean bl3 = false;
            this.getCurrentPage().setValue(it);
        }
    }

    @Override
    public void showPreviousPage() {
        DateCalendarPage<ItemContent> dateCalendarPage = this.pageBefore((DateCalendarPage)this.getCurrentPage().getValue());
        if (dateCalendarPage != null) {
            DateCalendarPage<ItemContent> dateCalendarPage2 = dateCalendarPage;
            boolean bl = false;
            boolean bl2 = false;
            DateCalendarPage<ItemContent> it = dateCalendarPage2;
            boolean bl3 = false;
            this.getCurrentPage().setValue(it);
        }
    }

    @Override
    public void didTapItem(@NotNull DateCalendarItem<ItemContent> item2, @NotNull DateCalendarPage<ItemContent> onPage) {
        Intrinsics.checkNotNullParameter(item2, (String)"item");
        Intrinsics.checkNotNullParameter(onPage, (String)"onPage");
        Delegate delegate = this.delegate;
        if (delegate != null) {
            delegate.calendarVMDidSelectDate(item2.getDate());
        }
    }

    @Override
    public void showPage(@NotNull DateCalendarPage<ItemContent> page) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        this.getCurrentPage().setValue(page);
    }

    @Override
    @Nullable
    public DateCalendarPage<ItemContent> pageAfter(@NotNull DateCalendarPage<ItemContent> page) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        ClosedRange<KotlinXDate> nextPage = this.nextPageRange(page);
        return this.datesDisplayRange.intersects(nextPage) ? this.pageForRange(nextPage, true) : (DateCalendarPage<ItemContent>)null;
    }

    @Override
    @Nullable
    public DateCalendarPage<ItemContent> pageBefore(@NotNull DateCalendarPage<ItemContent> page) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        ClosedRange<KotlinXDate> previousPage = this.previousPageRange(page);
        return this.datesDisplayRange.intersects(previousPage) ? this.pageForRange(previousPage, true) : (DateCalendarPage<ItemContent>)null;
    }

    private final KotlinXDate getInitialDate() {
        KotlinXDate kotlinXDate;
        if (this.selectedDate != null) {
            KotlinXDate kotlinXDate2 = this.selectedDate;
            kotlinXDate = kotlinXDate2;
            Intrinsics.checkNotNull((Object)kotlinXDate2);
        } else if (this.datesDisplayRange.contains((KotlinXDate)((Comparable)ADateJvmKt.getToday()))) {
            kotlinXDate = ADateJvmKt.getToday();
        } else if (this.datesDisplayRange.getStart() != null) {
            KotlinXDate kotlinXDate3 = this.datesDisplayRange.getStart();
            Intrinsics.checkNotNull((Object)kotlinXDate3);
            kotlinXDate = kotlinXDate3;
        } else {
            kotlinXDate = ADateJvmKt.getToday();
        }
        return kotlinXDate;
    }

    private final void reloadData() {
        this.pagesCache.clear();
        this.getCurrentPage().setValue(this.pageForRange(((DateCalendarPage)this.getCurrentPage().getValue()).getRange(), false));
    }

    private final ClosedRange<KotlinXDate> pageRangeWithBaseDate(KotlinXDate date2) {
        ClosedRange closedRange;
        DateCalendarStyle dateCalendarStyle = this.getStyle();
        int n = WhenMappings.$EnumSwitchMapping$0[dateCalendarStyle.ordinal()];
        switch (n) {
            case 1: {
                closedRange = RangesKt.rangeTo((Comparable)ADateKt.startOfWeek(date2, (Weekday)this.firstDayOfWeek.invoke()), (Comparable)ADateKt.endOfWeek(date2, (Weekday)this.firstDayOfWeek.invoke()));
                break;
            }
            case 2: {
                closedRange = RangesKt.rangeTo((Comparable)ADateKt.getStartOfMonth(date2), (Comparable)ADateKt.getEndOfMonth(date2));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return closedRange;
    }

    private final ClosedRange<KotlinXDate> nextPageRange(DateCalendarPage<ItemContent> page) {
        ClosedRange<KotlinXDate> closedRange;
        DateCalendarStyle dateCalendarStyle = this.getStyle();
        int n = WhenMappings.$EnumSwitchMapping$0[dateCalendarStyle.ordinal()];
        switch (n) {
            case 1: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.plusDays((KotlinXDate)page.getRange().getStart(), Weekday.values().length));
                break;
            }
            case 2: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.plusMonths((KotlinXDate)page.getRange().getStart(), 1));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return closedRange;
    }

    private final ClosedRange<KotlinXDate> previousPageRange(DateCalendarPage<ItemContent> page) {
        ClosedRange<KotlinXDate> closedRange;
        DateCalendarStyle dateCalendarStyle = this.getStyle();
        int n = WhenMappings.$EnumSwitchMapping$0[dateCalendarStyle.ordinal()];
        switch (n) {
            case 1: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.minusDays((KotlinXDate)page.getRange().getStart(), Weekday.values().length));
                break;
            }
            case 2: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.minusMonths((KotlinXDate)page.getRange().getStart(), 1));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return closedRange;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateWeekdaysIfNeeded() {
        Collection<String> collection;
        void $this$mapTo$iv$iv$iv;
        void $this$map$iv;
        ClosedRange closedRange = (ClosedRange)ArraysKt.getIndices((Object[])Weekday.values());
        Property property2 = this.getWeekdayLabels();
        boolean $i$f$map = false;
        Iterable $this$map$iv$iv = (Iterable)new IntRange(((Number)((Object)$this$map$iv.getStart())).intValue(), ((Number)((Object)$this$map$iv.getEndInclusive())).intValue());
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv$iv;
            int n = item$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv$iv;
            boolean bl = false;
            String string2 = WorkingDaysKt.weekdayToICal(WorkingDaysKt.weekday((int)((it + ((Weekday)this.firstDayOfWeek.invoke()).getOrderNumber()) % Weekday.values().length)));
            collection.add(string2);
        }
        collection = (List)destination$iv$iv$iv;
        property2.setValue(collection);
    }

    private final DateCalendarPage<ItemContent> pageForRange(ClosedRange<KotlinXDate> range3, boolean useCache) {
        int n;
        DateCalendarPage<ItemContent> cachedPage;
        if (useCache && (cachedPage = this.pagesCache.get(range3.getStart())) != null) {
            return cachedPage;
        }
        DateCalendarStyle dateCalendarStyle = this.getStyle();
        int n2 = WhenMappings.$EnumSwitchMapping$0[dateCalendarStyle.ordinal()];
        switch (n2) {
            case 1: {
                n = Weekday.values().length;
                break;
            }
            case 2: {
                n = Weekday.values().length * 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int size2 = n;
        DateCalendarPage<? extends ItemContent> page = this.makePageForRange(range3, this.contentItems, ADateJvmKt.getToday(), size2, this.datesDisplayRange);
        Map<KotlinXDate, DateCalendarPage<ItemContent>> map2 = this.pagesCache;
        Comparable comparable = range3.getStart();
        boolean bl = false;
        map2.put((KotlinXDate)comparable, page);
        return page;
    }

    private final DateCalendarPage<ItemContent> makePageForRange(ClosedRange<KotlinXDate> pageRange, Map<KotlinXDate, ? extends ItemContent> contentItems, KotlinXDate today, int itemsCount, InfiniteRange<KotlinXDate> calendarRange) {
        KotlinXDate currentDate = null;
        currentDate = ADateKt.startOfWeek((KotlinXDate)pageRange.getStart(), (Weekday)this.firstDayOfWeek.invoke());
        ArrayList<DateCalendarItem<ItemContent>> items2 = new ArrayList<DateCalendarItem<ItemContent>>(Weekday.values().length);
        int dayNumber = 0;
        dayNumber = ADateJvmKt.getDayOfMonth(currentDate);
        int totalDaysCount = 0;
        totalDaysCount = ADateKt.getNumberOfDaysInMonth(currentDate);
        boolean bl = false;
        int n = 0;
        int n2 = itemsCount;
        for (n = 0; n < n2; ++n) {
            int it = n;
            boolean bl2 = false;
            items2.add(new DateCalendarItem<ItemContent>(currentDate, String.valueOf(dayNumber), Intrinsics.areEqual((Object)currentDate, (Object)today), Intrinsics.areEqual((Object)currentDate, (Object)this.selectedDate), !calendarRange.contains((KotlinXDate)((Comparable)currentDate)) || !pageRange.contains((Comparable)currentDate), contentItems.get(currentDate)));
            currentDate = ADateJvmKt.plusDays(currentDate, 1);
            if (dayNumber < totalDaysCount) {
                int n3 = dayNumber;
                dayNumber = n3 + 1;
                continue;
            }
            dayNumber = 1;
            totalDaysCount = ADateKt.getNumberOfDaysInMonth(currentDate);
        }
        return new DateCalendarPage(pageRange, (List)items2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcirclet/calendar/DateCalendarVM$Companion;", "", "()V", "numberOfLinesForMonth", "", "app-state"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&\u00a8\u0006\u0007"}, d2={"Lcirclet/calendar/DateCalendarVM$Delegate;", "", "calendarVMDidSelectDate", "", "date", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "app-state"})
    public static interface Delegate {
        public void calendarVMDidSelectDate(@NotNull KotlinXDate var1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateCalendarStyle.values().length];
            nArray[DateCalendarStyle.WeekHorizontal.ordinal()] = 1;
            nArray[DateCalendarStyle.MonthHorizontal.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

