/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.BillingAdminKt;
import circlet.client.api.CustomFieldAmount;
import circlet.client.api.Money;
import circlet.client.api.Tier;
import circlet.client.api.TierEntityUsage;
import circlet.client.api.TierFeature;
import circlet.client.api.TierPrices;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\u0015\u0010\u0011\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000eH\u0086\u0002\u001a\u0015\u0010\u0012\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0086\u0002\u001a\u0015\u0010\u0012\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0016*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0016*\u00020\u001b\u001a\u0015\u0010\u001c\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086\u0002\u001a\u0015\u0010\u001d\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086\u0002\u001a\"\u0010\u001e\u001a\u00020\u000f*\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e\u001a\u0012\u0010#\u001a\u00020$*\u00020%2\u0006\u0010&\u001a\u00020$\u001a\u0015\u0010'\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0086\u0002\u001a\u0015\u0010'\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\"!\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f*\"\u0010(\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006)"}, d2={"DEFAULT_CUSTOM_FIELD_TIER_QUOTA", "Lkotlin/Function1;", "Lcirclet/client/api/Tier;", "Lcirclet/client/api/CustomFieldAmount;", "Lcirclet/client/api/CustomFieldTierQuota;", "getDEFAULT_CUSTOM_FIELD_TIER_QUOTA", "()Lkotlin/jvm/functions/Function1;", "ISSUE_CUSTOM_FIELD_TIER_QUOTA", "getISSUE_CUSTOM_FIELD_TIER_QUOTA", "readableName", "", "getReadableName", "(Lcirclet/client/api/Tier;)Ljava/lang/String;", "compare", "", "Lcirclet/client/api/Money;", "that", "compareTo", "div", "number", "", "hasFeature", "", "feature", "Lcirclet/client/api/TierFeature;", "isFree", "isUnlimited", "Lcirclet/client/api/TierEntityUsage;", "minus", "plus", "priceOfOverdrafts", "Lcirclet/client/api/TierPrices;", "storage", "bandwidth", "ciCredits", "round4", "", "Lcirclet/client/api/Money$Companion;", "value", "times", "CustomFieldTierQuota", "client-api"})
public final class BillingAdminKt {
    @NotNull
    private static final Function1<Tier, CustomFieldAmount> ISSUE_CUSTOM_FIELD_TIER_QUOTA = ISSUE_CUSTOM_FIELD_TIER_QUOTA.1.INSTANCE;
    @NotNull
    private static final Function1<Tier, CustomFieldAmount> DEFAULT_CUSTOM_FIELD_TIER_QUOTA = DEFAULT_CUSTOM_FIELD_TIER_QUOTA.1.INSTANCE;

    public static final boolean isUnlimited(@NotNull TierEntityUsage $this$isUnlimited) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnlimited, (String)"<this>");
        return $this$isUnlimited.getLimit() < 0;
    }

    @NotNull
    public static final Money priceOfOverdrafts(@NotNull TierPrices $this$priceOfOverdrafts, int storage, int bandwidth, int ciCredits) {
        Intrinsics.checkNotNullParameter((Object)$this$priceOfOverdrafts, (String)"<this>");
        Money storagePrice = BillingAdminKt.times($this$priceOfOverdrafts.getStoragePricePerGB(), storage);
        Money trafficPrice = BillingAdminKt.times($this$priceOfOverdrafts.getBandwidthPricePerGB(), bandwidth);
        Money ciCreditsPrice = BillingAdminKt.times(BillingAdminKt.div($this$priceOfOverdrafts.getCiCreditPricePer1000(), 1000), ciCredits);
        return BillingAdminKt.plus(BillingAdminKt.plus(storagePrice, trafficPrice), ciCreditsPrice);
    }

    @NotNull
    public static final Money times(@NotNull Money $this$times, int number2) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$times.getAmount() * (double)number2), $this$times.getCurrency());
    }

    @NotNull
    public static final Money times(@NotNull Money $this$times, long number2) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$times.getAmount() * (double)number2), $this$times.getCurrency());
    }

    @NotNull
    public static final Money div(@NotNull Money $this$div, int number2) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$div.getAmount() / (double)number2), $this$div.getCurrency());
    }

    @NotNull
    public static final Money div(@NotNull Money $this$div, long number2) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$div.getAmount() / (double)number2), $this$div.getCurrency());
    }

    @NotNull
    public static final Money plus(@NotNull Money $this$plus, @NotNull Money that) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        boolean bl = Intrinsics.areEqual((Object)$this$plus.getCurrency(), (Object)that.getCurrency());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return new Money(BillingAdminKt.round4(Money.Companion, $this$plus.getAmount() + that.getAmount()), $this$plus.getCurrency());
    }

    @NotNull
    public static final Money minus(@NotNull Money $this$minus, @NotNull Money that) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        boolean bl = Intrinsics.areEqual((Object)$this$minus.getCurrency(), (Object)that.getCurrency());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return new Money(BillingAdminKt.round4(Money.Companion, $this$minus.getAmount() - that.getAmount()), $this$minus.getCurrency());
    }

    public static final int compare(@NotNull Money $this$compare, @NotNull Money that) {
        Intrinsics.checkNotNullParameter((Object)$this$compare, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        boolean bl = Intrinsics.areEqual((Object)$this$compare.getCurrency(), (Object)that.getCurrency());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return $this$compare.getAmount() < that.getAmount() ? -1 : ($this$compare.getAmount() > that.getAmount() ? 1 : 0);
    }

    public static final double round4(@NotNull Money.Companion $this$round4, double value2) {
        Intrinsics.checkNotNullParameter((Object)$this$round4, (String)"<this>");
        double d = value2 * (double)10000;
        boolean bl = false;
        return Math.rint(d) / (double)10000;
    }

    public static final boolean isFree(@NotNull Tier $this$isFree) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isFree), (String)"<this>");
        Tier tier2 = $this$isFree;
        int n = WhenMappings.$EnumSwitchMapping$0[tier2.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final String getReadableName(@NotNull Tier $this$readableName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$readableName), (String)"<this>");
        Tier tier2 = $this$readableName;
        int n = WhenMappings.$EnumSwitchMapping$0[tier2.ordinal()];
        switch (n) {
            case 1: {
                string2 = "Free";
                break;
            }
            case 3: {
                string2 = "Team";
                break;
            }
            case 4: {
                string2 = "Organization";
                break;
            }
            case 5: {
                string2 = "Classroom";
                break;
            }
            case 2: {
                string2 = "Beta";
                break;
            }
            case 6: {
                string2 = "Enterprise";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    public static final boolean hasFeature(@NotNull Tier $this$hasFeature, @NotNull TierFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$hasFeature), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return $this$hasFeature.compareTo((Enum)feature.getTier()) >= 0;
    }

    public static final int compareTo(@NotNull CustomFieldAmount $this$compareTo, int that) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        CustomFieldAmount customFieldAmount = $this$compareTo;
        if (customFieldAmount instanceof CustomFieldAmount.None) {
            n = 0;
        } else if (customFieldAmount instanceof CustomFieldAmount.Limited) {
            n = ((CustomFieldAmount.Limited)$this$compareTo).getAmount();
        } else if (customFieldAmount instanceof CustomFieldAmount.Unlimited) {
            n = Integer.MAX_VALUE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n - that;
    }

    @NotNull
    public static final Function1<Tier, CustomFieldAmount> getISSUE_CUSTOM_FIELD_TIER_QUOTA() {
        return ISSUE_CUSTOM_FIELD_TIER_QUOTA;
    }

    @NotNull
    public static final Function1<Tier, CustomFieldAmount> getDEFAULT_CUSTOM_FIELD_TIER_QUOTA() {
        return DEFAULT_CUSTOM_FIELD_TIER_QUOTA;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tier.values().length];
            nArray[Tier.Free.ordinal()] = 1;
            nArray[Tier.Beta.ordinal()] = 2;
            nArray[Tier.Team.ordinal()] = 3;
            nArray[Tier.Organization.ordinal()] = 4;
            nArray[Tier.Classroom.ordinal()] = 5;
            nArray[Tier.Enterprise.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

