/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.auth.twoFA;

import circlet.client.api.ProfileIdentifier;
import circlet.client.api.auth.twoFA.TwoFactorAuthenticationSecret;
import circlet.client.api.auth.twoFA.TwoFactorAuthenticationStatus;
import circlet.platform.api.annotations.DefaultParameterValues;
import circlet.platform.api.annotations.Http;
import circlet.platform.api.annotations.HttpApi;
import circlet.platform.api.annotations.HttpApiDoc;
import circlet.platform.api.annotations.Rest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@HttpApi(resource="team-directory/profiles")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J!\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ!\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcirclet/client/api/auth/twoFA/TwoFactorAuthentications;", "", "confirmTotp", "", "profile", "Lcirclet/client/api/ProfileIdentifier;", "code", "", "(Lcirclet/client/api/ProfileIdentifier;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTwoFactorAuthenticationStatus", "Lcirclet/client/api/auth/twoFA/TwoFactorAuthenticationStatus;", "(Lcirclet/client/api/ProfileIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeTotp", "setUpTotp", "Lcirclet/client/api/auth/twoFA/TwoFactorAuthenticationSecret;", "updateTotp", "enabled", "", "(Lcirclet/client/api/ProfileIdentifier;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "client-api"})
public interface TwoFactorAuthentications {
    @Rest.Get(path="{profile}/2-fa/status", displayName="Two-factor authentication status")
    @HttpApiDoc(doc="Get two-factor authentication status for a given profile ID. The response indicates whether two-factor authentication is active, not active, or not set up yet.")
    @DefaultParameterValues(params={})
    @Nullable
    public Object getTwoFactorAuthenticationStatus(@NotNull ProfileIdentifier var1, @NotNull Continuation<? super TwoFactorAuthenticationStatus> var2);

    @Rest.Create(path="{profile}/2-fa/totp", displayName="Set up TOTP two-factor authentication")
    @HttpApiDoc(doc="Set up two-factor authentication using TOTP (Time-based One-time Password) for a given profile ID. The response will return a QR code (base64 encoded) that can be scanned with an app to setup two-factor authentication. The code that the app generates has to be confirmed in Space to enable TOTP.")
    @DefaultParameterValues(params={})
    @Nullable
    public Object setUpTotp(@NotNull ProfileIdentifier var1, @NotNull Continuation<? super TwoFactorAuthenticationSecret> var2);

    @Http.Post(path="{profile}/2-fa/totp/confirm", displayName="Confirm TOTP two-factor authentication settings")
    @HttpApiDoc(doc="Confirm two-factor authentication for a given profile ID using a TOTP (Time-based One-time Password) code from an app.")
    @DefaultParameterValues(params={})
    @Nullable
    public Object confirmTotp(@NotNull ProfileIdentifier var1, int var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Update(path="{profile}/2-fa/totp", displayName="Update TOTP two-factor authentication settings")
    @HttpApiDoc(doc="Enable/disable two-factor authentication settings for a given profile ID")
    @DefaultParameterValues(params={})
    @Nullable
    public Object updateTotp(@NotNull ProfileIdentifier var1, boolean var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Delete(path="{profile}/2-fa/totp", displayName="Delete current TOTP two-factor authentication settings")
    @HttpApiDoc(doc="Remove two-factor authentication settings for a given profile ID. Previously generated TOTP (Time-based One-time Password) are rendered invalid.")
    @DefaultParameterValues(params={})
    @Nullable
    public Object removeTotp(@NotNull ProfileIdentifier var1, @NotNull Continuation<? super Unit> var2);
}

