/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.CalendarEventSpec;
import circlet.common.calendar.ClosedTimeInterval;
import circlet.common.calendar.DatesInterval;
import circlet.common.calendar.EventCalculationsKt;
import circlet.common.calendar.EventCounter;
import circlet.common.calendar.MeetingStart;
import circlet.common.calendar.RecurrenceRule;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.RegularEventCounter;
import circlet.common.calendar.RelativeDate;
import circlet.common.calendar.RelativeEventCounter;
import circlet.common.calendar.SpecInstancesKt;
import circlet.common.calendar.SpecIntersectsKt;
import circlet.common.calendar.TimeInterval;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.Weekday;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.Math;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b\u001a \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a \u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\u001a-\u0010&\u001a\u00060\u0002j\u0002`\u00032\u001a\u0010'\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0002j\u0002`\u00030(\"\u00060\u0002j\u0002`\u0003H\u0002\u00a2\u0006\u0002\u0010)\u001a-\u0010*\u001a\u00060\u0002j\u0002`\u00032\u001a\u0010'\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0002j\u0002`\u00030(\"\u00060\u0002j\u0002`\u0003H\u0002\u00a2\u0006\u0002\u0010)\u001a,\u0010+\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\u0006\u0010 \u001a\u00020!2\n\u0010,\u001a\u00060\u0002j\u0002`\u00032\b\b\u0002\u0010-\u001a\u00020\u0011\u001a,\u0010.\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00032\u0006\u0010 \u001a\u00020!2\n\u0010,\u001a\u00060\u0002j\u0002`\u00032\b\b\u0002\u0010-\u001a\u00020\u0011\u001a\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u0016H\u0002\u001a\u0018\u00103\u001a\u0004\u0018\u00010\r*\u00020!2\n\u00104\u001a\u00060\u0002j\u0002`\u0003\u001a\n\u00105\u001a\u00020\u0016*\u00020!\u001a\u001e\u00106\u001a\u000207*\u0002072\n\u00108\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\"\u001a\u00020#\u001a\n\u00109\u001a\u00020\u0011*\u00020!\u001a.\u0010:\u001a\u00020\u0011\"\u000e\b\u0000\u0010;*\b\u0012\u0004\u0012\u0002H;0<*\b\u0012\u0004\u0012\u0002H;0=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H;0=\u001a\u0012\u0010?\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u0003*\u00020!\u001a\u0012\u0010@\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t*\u00020!\u001a.\u0010A\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t*\u00020!2\u0010\b\u0002\u0010,\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00032\b\b\u0002\u0010-\u001a\u00020\u0011\u001a.\u0010B\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u0003*\u00020!2\u0010\b\u0002\u0010,\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00032\b\b\u0002\u0010-\u001a\u00020\u0011\u001a\u001c\u0010C\u001a\u00020D*\u00020!2\u0010\b\u0002\u0010E\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u001a\u0014\u0010F\u001a\u00060\bj\u0002`\t*\u00060\bj\u0002`\tH\u0002\")\u0010\u0000\u001a\u001a\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001j\f\u0012\b\u0012\u00060\u0002j\u0002`\u0003`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006G"}, d2={"timeComparator", "Ljava/util/Comparator;", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "Lkotlin/Comparator;", "getTimeComparator", "()Ljava/util/Comparator;", "calcIntersectionDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "first", "Lcirclet/common/calendar/EventCounter;", "second", "Lcirclet/common/calendar/RegularEventCounter;", "datesInterval", "Lcirclet/common/calendar/DatesInterval;", "canDailyIntersect", "", "event1", "event2", "canIntersect", "diff", "", "interval1", "interval2", "canMonthlyOnDateIntersect", "canMonthlyOnLastWeekdayIntersect", "canMonthlyOnStartDateIntersect", "canMonthlyOnWeekdayIntersect", "canWeeklyIntersect", "canYearlyIntersect", "createEventCounterRelativeToTimezone", "event", "Lcirclet/common/calendar/CalendarEventSpec;", "timezone", "Lcirclet/platform/api/ATimeZone;", "intervalToIntersect", "Lcirclet/common/calendar/ClosedTimeInterval;", "maxTime", "time", "", "([Lcirclet/platform/api/KotlinXDateTime;)Lcirclet/platform/api/KotlinXDateTime;", "minTime", "nextOccurrence", "fromDateTime", "countAlreadyStarted", "nextOccurrenceTime", "shiftWeekday", "Lcirclet/platform/api/Weekday;", "weekday", "daysDiff", "createCounter", "since", "durationInMinutes", "fix", "Lcirclet/common/calendar/RecurrenceRuleFreq;", "eventStart", "hasEnded", "intersects", "T", "", "Lkotlin/ranges/ClosedRange;", "range", "lastOccurrenceEnd", "lastStartDate", "nextStartDate", "nextStartTime", "regularMeetingStart", "Lcirclet/common/calendar/MeetingStart;", "startDate", "weekStart", "common"})
public final class EventCountersKt {
    @NotNull
    private static final Comparator<KotlinXDateTime> timeComparator;

    @NotNull
    public static final Comparator<KotlinXDateTime> getTimeComparator() {
        return timeComparator;
    }

    @Nullable
    public static final KotlinXDate nextStartDate(@NotNull CalendarEventSpec $this$nextStartDate, @Nullable KotlinXDateTime fromDateTime, boolean countAlreadyStarted) {
        KotlinXDateTime kotlinXDateTime;
        Intrinsics.checkNotNullParameter((Object)$this$nextStartDate, (String)"<this>");
        KotlinXDateTime kotlinXDateTime2 = fromDateTime;
        KotlinXDateTime time = kotlinXDateTime2 == null ? ADateJvmKt.getANow() : kotlinXDateTime2;
        kotlinXDateTime2 = EventCountersKt.nextStartTime($this$nextStartDate, time, countAlreadyStarted);
        return kotlinXDateTime2 == null ? null : ((kotlinXDateTime = ADateJvmKt.withZone(kotlinXDateTime2, $this$nextStartDate.getTimezone())) == null ? null : ADateJvmKt.toDate(kotlinXDateTime));
    }

    public static /* synthetic */ KotlinXDate nextStartDate$default(CalendarEventSpec calendarEventSpec, KotlinXDateTime kotlinXDateTime, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDateTime = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return EventCountersKt.nextStartDate(calendarEventSpec, kotlinXDateTime, bl);
    }

    @Nullable
    public static final KotlinXDateTime nextStartTime(@NotNull CalendarEventSpec $this$nextStartTime, @Nullable KotlinXDateTime fromDateTime, boolean countAlreadyStarted) {
        KotlinXDateTime time;
        Intrinsics.checkNotNullParameter((Object)$this$nextStartTime, (String)"<this>");
        KotlinXDateTime kotlinXDateTime = fromDateTime;
        KotlinXDateTime kotlinXDateTime2 = time = kotlinXDateTime == null ? ADateJvmKt.getANow() : kotlinXDateTime;
        if ($this$nextStartTime.getRecurrenceRule() == null) {
            KotlinXDateTime kotlinXDateTime3;
            KotlinXDateTime checkedTimePoint = countAlreadyStarted ? $this$nextStartTime.getEnd() : $this$nextStartTime.getStart();
            boolean condition$iv = checkedTimePoint.compareTo(time) > 0;
            boolean $i$f$ifTrue = false;
            if (condition$iv) {
                boolean bl = false;
                kotlinXDateTime3 = $this$nextStartTime.getStart();
            } else {
                kotlinXDateTime3 = null;
            }
            return kotlinXDateTime3;
        }
        return EventCountersKt.nextOccurrenceTime($this$nextStartTime, time, countAlreadyStarted);
    }

    public static /* synthetic */ KotlinXDateTime nextStartTime$default(CalendarEventSpec calendarEventSpec, KotlinXDateTime kotlinXDateTime, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDateTime = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return EventCountersKt.nextStartTime(calendarEventSpec, kotlinXDateTime, bl);
    }

    @Nullable
    public static final KotlinXDate nextOccurrence(@NotNull CalendarEventSpec event2, @NotNull KotlinXDateTime fromDateTime, boolean countAlreadyStarted) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)fromDateTime, (String)"fromDateTime");
        KotlinXDateTime countStart = countAlreadyStarted ? ADateJvmKt.plusMinutes(fromDateTime, -EventCountersKt.durationInMinutes(event2)) : fromDateTime;
        RegularEventCounter regularEventCounter = EventCountersKt.createCounter(event2, countStart);
        if (regularEventCounter == null) {
            return null;
        }
        RegularEventCounter eventCounter = regularEventCounter;
        KotlinXDate nextDate = eventCounter.getCurrentDate();
        KotlinXDate lastDate = EventCountersKt.lastStartDate(event2);
        boolean eventIsOver = lastDate != null && PrimitivesExKt.isAfter(nextDate, lastDate);
        KotlinXDate kotlinXDate = nextDate;
        boolean bl = false;
        boolean bl2 = false;
        KotlinXDate it = kotlinXDate;
        boolean bl3 = false;
        return !eventIsOver ? kotlinXDate : null;
    }

    public static /* synthetic */ KotlinXDate nextOccurrence$default(CalendarEventSpec calendarEventSpec, KotlinXDateTime kotlinXDateTime, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return EventCountersKt.nextOccurrence(calendarEventSpec, kotlinXDateTime, bl);
    }

    @Nullable
    public static final KotlinXDateTime nextOccurrenceTime(@NotNull CalendarEventSpec event2, @NotNull KotlinXDateTime fromDateTime, boolean countAlreadyStarted) {
        KotlinXDateTime kotlinXDateTime;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)fromDateTime, (String)"fromDateTime");
        KotlinXDate kotlinXDate = EventCountersKt.nextOccurrence(event2, fromDateTime, countAlreadyStarted);
        if (kotlinXDate == null) {
            kotlinXDateTime = null;
        } else {
            KotlinXDate kotlinXDate2 = kotlinXDate;
            boolean bl = false;
            boolean bl2 = false;
            KotlinXDate it = kotlinXDate2;
            boolean bl3 = false;
            kotlinXDateTime = SpecIntersectsKt.startTimeAtDay(event2, it);
        }
        return kotlinXDateTime;
    }

    public static /* synthetic */ KotlinXDateTime nextOccurrenceTime$default(CalendarEventSpec calendarEventSpec, KotlinXDateTime kotlinXDateTime, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return EventCountersKt.nextOccurrenceTime(calendarEventSpec, kotlinXDateTime, bl);
    }

    @Nullable
    public static final KotlinXDate lastStartDate(@NotNull CalendarEventSpec $this$lastStartDate) {
        Intrinsics.checkNotNullParameter((Object)$this$lastStartDate, (String)"<this>");
        return $this$lastStartDate.getRecurrenceRule() == null ? ADateJvmKt.toDate(ADateJvmKt.withZone($this$lastStartDate.getStart(), $this$lastStartDate.getTimezone())) : SpecIntersectsKt.lastOccurrenceStartLocalDate($this$lastStartDate.getRecurrenceRule().getEnds(), $this$lastStartDate.getRecurrenceRule().getFreq(), ADateJvmKt.withZone($this$lastStartDate.getStart(), $this$lastStartDate.getTimezone()));
    }

    @Nullable
    public static final RegularEventCounter createCounter(@NotNull CalendarEventSpec $this$createCounter, @NotNull KotlinXDateTime since) {
        Intrinsics.checkNotNullParameter((Object)$this$createCounter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        if ($this$createCounter.getRecurrenceRule() == null || !EventCalculationsKt.canHappen($this$createCounter)) {
            return null;
        }
        KotlinXDate sinceDate = ADateJvmKt.toDate(ADateJvmKt.withZone(since, $this$createCounter.getTimezone()));
        KotlinXDateTime startTime = SpecInstancesKt.shiftedSpec($this$createCounter, sinceDate, $this$createCounter.getTimezone()).getStart();
        KotlinXDate fromDate = startTime.compareTo(since) >= 0 || $this$createCounter.getAllDay() ? sinceDate : ADateJvmKt.plusDays(sinceDate, 1);
        RecurrenceRuleFreq freq = $this$createCounter.getRecurrenceRule().getFreq();
        RegularEventCounter eventCounter = new RegularEventCounter($this$createCounter.getAllDay() ? freq : EventCountersKt.fix(freq, $this$createCounter.getStart(), $this$createCounter.getTimezone()), ADateJvmKt.toDate(ADateJvmKt.withZone($this$createCounter.getStart(), $this$createCounter.getTimezone())));
        eventCounter.toNextEventAfterDate(fromDate);
        return eventCounter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RecurrenceRuleFreq fix(@NotNull RecurrenceRuleFreq $this$fix, @NotNull KotlinXDateTime eventStart, @NotNull ATimeZone timezone) {
        RecurrenceRuleFreq recurrenceRuleFreq;
        Intrinsics.checkNotNullParameter((Object)$this$fix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)eventStart, (String)"eventStart");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDate startInOwnTz = ADateJvmKt.toDate(eventStart);
        KotlinXDate startInEventTz = ADateJvmKt.toDate(ADateJvmKt.withZone(eventStart, timezone));
        int daysDiff = ADateJvmKt.getWeekday(startInEventTz).getOrderNumber() - ADateJvmKt.getWeekday(startInOwnTz).getOrderNumber();
        if (daysDiff == 0) {
            return $this$fix;
        }
        RecurrenceRuleFreq recurrenceRuleFreq2 = $this$fix;
        if (recurrenceRuleFreq2 instanceof RecurrenceRuleFreq.Weekly) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((RecurrenceRuleFreq.Weekly)$this$fix).getWeekdays();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Weekday weekday = (Weekday)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Weekday weekday2 = EventCountersKt.shiftWeekday((Weekday)it, daysDiff);
                collection.add(weekday2);
            }
            List weekdays = (List)destination$iv$iv;
            if (!weekdays.contains(ADateJvmKt.getWeekday(startInEventTz))) {
                return $this$fix;
            }
            recurrenceRuleFreq = new RecurrenceRuleFreq.Weekly(weekdays, ((RecurrenceRuleFreq.Weekly)$this$fix).getInterval());
        } else {
            recurrenceRuleFreq = recurrenceRuleFreq2 instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday ? (RecurrenceRuleFreq)new RecurrenceRuleFreq.MonthlyOnFirstWeekday(EventCountersKt.shiftWeekday(((RecurrenceRuleFreq.MonthlyOnFirstWeekday)$this$fix).getWeekday(), daysDiff), ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)$this$fix).getShift(), ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)$this$fix).getInterval()) : (recurrenceRuleFreq2 instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday ? (RecurrenceRuleFreq)new RecurrenceRuleFreq.MonthlyOnLastWeekday(EventCountersKt.shiftWeekday(((RecurrenceRuleFreq.MonthlyOnLastWeekday)$this$fix).getWeekday(), daysDiff), ((RecurrenceRuleFreq.MonthlyOnLastWeekday)$this$fix).getInterval()) : $this$fix);
        }
        return recurrenceRuleFreq;
    }

    private static final Weekday shiftWeekday(Weekday weekday, int daysDiff) {
        Weekday element$iv;
        block3: {
            int day = 0;
            day = weekday.getOrderNumber() + daysDiff;
            if (day < 0) {
                day += 7;
            }
            Weekday[] $this$first$iv = Weekday.values();
            boolean $i$f$first = false;
            Weekday[] weekdayArray = $this$first$iv;
            int n = weekdayArray.length;
            for (int i = 0; i < n; ++i) {
                Weekday it = element$iv = weekdayArray[i];
                boolean bl = false;
                if (!(it.getOrderNumber() == day % 7)) {
                    continue;
                }
                break block3;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        return element$iv;
    }

    @Nullable
    public static final EventCounter createEventCounterRelativeToTimezone(@NotNull CalendarEventSpec event2, @NotNull ATimeZone timezone, @NotNull ClosedTimeInterval intervalToIntersect) {
        EventCounter eventCounter;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Intrinsics.checkNotNullParameter((Object)intervalToIntersect, (String)"intervalToIntersect");
        if (!EventCalculationsKt.canHappen(event2)) {
            return null;
        }
        RecurrenceRule recurrenceRule = event2.getRecurrenceRule();
        Intrinsics.checkNotNull((Object)recurrenceRule);
        RecurrenceRuleFreq freq = recurrenceRule.getFreq();
        ClosedTimeInterval mainDateInterval = null;
        ClosedTimeInterval additionalDateInterval = null;
        RelativeDate additionalDateRelation = null;
        KotlinXDateTime startTime = ADateJvmKt.withZone(event2.getStart(), timezone);
        KotlinXDateTime endTime = ADateJvmKt.withZone(ADateJvmKt.plusMinutes(startTime, EventCountersKt.durationInMinutes(event2)), timezone);
        KotlinXDate startDate = ADateJvmKt.toDate(startTime);
        KotlinXDate endDate = ADateJvmKt.toDate(endTime);
        KotlinXDateTime splitTime = ADateJvmKt.withZone(ADateJvmKt.toDateTimeAtStartOfDay(endDate, timezone), timezone);
        KotlinXDate originStartDate = ADateJvmKt.toDate(ADateJvmKt.withZone(startTime, event2.getTimezone()));
        if (Intrinsics.areEqual((Object)startDate, (Object)endDate) || Intrinsics.areEqual((Object)startTime, (Object)splitTime) || Intrinsics.areEqual((Object)splitTime, (Object)endTime)) {
            mainDateInterval = new ClosedTimeInterval(startTime, endTime);
            additionalDateInterval = null;
            additionalDateRelation = null;
        } else {
            boolean nextDayAdded = Intrinsics.areEqual((Object)startDate, (Object)originStartDate);
            additionalDateRelation = nextDayAdded ? RelativeDate.Next : RelativeDate.Prev;
            ClosedTimeInterval firstPart = new ClosedTimeInterval(startTime, splitTime);
            ClosedTimeInterval secondPart = new ClosedTimeInterval(splitTime, endTime);
            mainDateInterval = nextDayAdded ? firstPart : secondPart;
            additionalDateInterval = nextDayAdded ? secondPart : firstPart;
        }
        KotlinXDate mainDate = ADateJvmKt.toDate(ADateJvmKt.withZone(mainDateInterval.getStart(), timezone));
        ClosedRange<Integer> eventMinutes = intervalToIntersect.toMinutesRangeInZone(timezone);
        ClosedRange<Integer> mainIntervalMinutes = mainDateInterval.toMinutesRangeInZone(timezone);
        if (EventCountersKt.intersects(mainIntervalMinutes, eventMinutes) || additionalDateInterval == null) {
            return new RegularEventCounter(freq, mainDate);
        }
        ClosedRange<Integer> additionalIntervalMinutes = additionalDateInterval.toMinutesRangeInZone(timezone);
        boolean canIntersectOnAdditionalDate = EventCountersKt.intersects(additionalIntervalMinutes, eventMinutes);
        if (canIntersectOnAdditionalDate) {
            RegularEventCounter regularEventCounter = new RegularEventCounter(freq, mainDate);
            RelativeDate relativeDate = additionalDateRelation;
            Intrinsics.checkNotNull((Object)((Object)relativeDate));
            eventCounter = new RelativeEventCounter(regularEventCounter, relativeDate);
        } else {
            eventCounter = null;
        }
        return eventCounter;
    }

    public static final boolean canIntersect(@NotNull EventCounter event1, @NotNull EventCounter event2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event1, (String)"event1");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event2");
        RecurrenceRuleFreq recurrenceRuleFreq = event1.getFrequency();
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
            bl = EventCountersKt.canDailyIntersect(event1, event2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
            bl = EventCountersKt.canWeeklyIntersect(event1, event2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            bl = EventCountersKt.canMonthlyOnWeekdayIntersect(event1, event2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            bl = EventCountersKt.canMonthlyOnLastWeekdayIntersect(event1, event2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            bl = EventCountersKt.canMonthlyOnDateIntersect(event1, event2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            bl = EventCountersKt.canMonthlyOnStartDateIntersect(event1, event2);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
            bl = EventCountersKt.canYearlyIntersect(event1, event2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canDailyIntersect(EventCounter event1, EventCounter event2) {
        RecurrenceRuleFreq freq1 = event1.getFrequency();
        RecurrenceRuleFreq freq2 = event2.getFrequency();
        KotlinXDate date1 = event1.getCurrentDate();
        KotlinXDate date2 = event2.getCurrentDate();
        boolean bl = freq1 instanceof RecurrenceRuleFreq.Daily;
        int n = 0;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        RecurrenceRuleFreq recurrenceRuleFreq = freq2;
        if (!(recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily)) {
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                if (((RecurrenceRuleFreq.Daily)freq1).getInterval() % 7 != 0) return true;
                if (!event2.getWeekdays().contains(ADateJvmKt.getWeekday(date1))) return false;
                n = ADateJvmKt.daysBetween(EventCountersKt.weekStart(date1), EventCountersKt.weekStart(date2));
                bl2 = false;
                if (!EventCountersKt.canIntersect(java.lang.Math.abs(n) / 7, ((RecurrenceRuleFreq.Daily)freq1).getInterval() / 7, ((RecurrenceRuleFreq.Weekly)freq2).getInterval())) return false;
                return true;
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                return true;
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                return true;
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                return true;
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                return true;
            }
            if (!(recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly)) throw new NoWhenBranchMatchedException();
            return true;
        }
        n = ADateJvmKt.daysBetween(date1, date2);
        bl2 = false;
        boolean bl5 = EventCountersKt.canIntersect(java.lang.Math.abs(n), ((RecurrenceRuleFreq.Daily)freq1).getInterval(), ((RecurrenceRuleFreq.Daily)freq2).getInterval());
        return bl5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canWeeklyIntersect(EventCounter event1, EventCounter event2) {
        boolean bl;
        RecurrenceRuleFreq freq1 = event1.getFrequency();
        RecurrenceRuleFreq freq2 = event2.getFrequency();
        KotlinXDate date1 = event1.getCurrentDate();
        KotlinXDate date2 = event2.getCurrentDate();
        boolean bl2 = freq1 instanceof RecurrenceRuleFreq.Weekly;
        int n = 0;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        RecurrenceRuleFreq recurrenceRuleFreq = freq2;
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
            bl = EventCountersKt.canDailyIntersect(event2, event1);
            return bl;
        } else {
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                if (!event1.haveCommonWeekdays(event2)) return false;
                n = ADateJvmKt.daysBetween(EventCountersKt.weekStart(date1), EventCountersKt.weekStart(date2));
                bl3 = false;
                if (!EventCountersKt.canIntersect(java.lang.Math.abs(n) / 7, ((RecurrenceRuleFreq.Weekly)freq1).getInterval(), ((RecurrenceRuleFreq.Weekly)freq2).getInterval())) return false;
                return true;
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                bl = event1.haveCommonWeekdays(event2);
                return bl;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                bl = event1.haveCommonWeekdays(event2);
                return bl;
            } else {
                if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                    return true;
                }
                if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                    return true;
                }
                if (!(recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly)) throw new NoWhenBranchMatchedException();
                return true;
            }
        }
    }

    private static final boolean canMonthlyOnWeekdayIntersect(EventCounter event1, EventCounter event2) {
        boolean bl;
        RecurrenceRuleFreq freq1 = event1.getFrequency();
        RecurrenceRuleFreq freq2 = event2.getFrequency();
        KotlinXDate date1 = event1.getCurrentDate();
        KotlinXDate date2 = event2.getCurrentDate();
        boolean bl2 = freq1 instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        boolean relativeEvent = event1.getRelativity() != RelativeDate.Same;
        boolean haveCommonWeekdays = event1.haveCommonWeekdays(event2);
        if (relativeEvent) {
            bl = haveCommonWeekdays || event2.getWeekdays().isEmpty();
        } else {
            int monthsBetween;
            RecurrenceRuleFreq recurrenceRuleFreq = freq2;
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                bl = EventCountersKt.canDailyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                bl = EventCountersKt.canWeeklyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl7 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getShift() == ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq2).getShift() && haveCommonWeekdays && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl8 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getShift() > 2 && haveCommonWeekdays && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl9 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getShift() == (((RecurrenceRuleFreq.MonthlyOnDate)freq2).getDay() - 1) / 7 && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnDate)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl10 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getShift() == (ADateJvmKt.getDayOfMonth(date2) - 1) / 7 && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnStartDate)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                monthsBetween = Math.INSTANCE.abs(ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2)));
                bl = ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getShift() == (ADateJvmKt.getDayOfMonth(date2) - 1) / 7 && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.Yearly)freq2).getInterval());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean canMonthlyOnLastWeekdayIntersect(EventCounter event1, EventCounter event2) {
        boolean bl;
        RecurrenceRuleFreq freq1 = event1.getFrequency();
        RecurrenceRuleFreq freq2 = event2.getFrequency();
        KotlinXDate date1 = event1.getCurrentDate();
        KotlinXDate date2 = event2.getCurrentDate();
        boolean bl2 = freq1 instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        boolean relativeEvent = event1.getRelativity() != RelativeDate.Same;
        boolean haveCommonWeekdays = event1.haveCommonWeekdays(event2);
        if (relativeEvent) {
            bl = haveCommonWeekdays || event2.getWeekdays().isEmpty();
        } else {
            int monthsBetween;
            RecurrenceRuleFreq recurrenceRuleFreq = freq2;
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                bl = EventCountersKt.canDailyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                bl = EventCountersKt.canWeeklyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                bl = EventCountersKt.canMonthlyOnWeekdayIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl7 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq1).getWeekday() == ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq2).getWeekday() && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl8 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ((RecurrenceRuleFreq.MonthlyOnDate)freq2).getDay() >= 22 && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnDate)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl9 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ADateJvmKt.getDayOfMonth(date2) >= 22 && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnStartDate)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                int n = ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2));
                boolean bl10 = false;
                monthsBetween = java.lang.Math.abs(n);
                bl = ADateJvmKt.getDayOfMonth(date2) >= 22 && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq1).getInterval(), ((RecurrenceRuleFreq.Yearly)freq2).getInterval());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean canMonthlyOnDateIntersect(EventCounter event1, EventCounter event2) {
        boolean bl;
        boolean canNotShiftFrequency;
        RecurrenceRuleFreq freq1 = event1.getFrequency();
        RecurrenceRuleFreq freq2 = event2.getFrequency();
        KotlinXDate date1 = event1.getCurrentDate();
        KotlinXDate date2 = event2.getCurrentDate();
        boolean bl2 = freq1 instanceof RecurrenceRuleFreq.MonthlyOnDate;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        boolean bl7 = canNotShiftFrequency = event1.getRelativity() == RelativeDate.Next && ((RecurrenceRuleFreq.MonthlyOnDate)freq1).getDay() >= 28 || event1.getRelativity() == RelativeDate.Prev && ((RecurrenceRuleFreq.MonthlyOnDate)freq1).getDay() == 1;
        if (canNotShiftFrequency) {
            return true;
        }
        RecurrenceRuleFreq.MonthlyOnDate shiftedFreq1 = new RecurrenceRuleFreq.MonthlyOnDate(((RecurrenceRuleFreq.MonthlyOnDate)freq1).getDay() + event1.getRelativity().getDateShift(), ((RecurrenceRuleFreq.MonthlyOnDate)freq1).getInterval());
        RegularEventCounter shiftedEvent1 = new RegularEventCounter(shiftedFreq1, date1);
        RecurrenceRuleFreq recurrenceRuleFreq = freq2;
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
            bl = EventCountersKt.canDailyIntersect(event2, shiftedEvent1);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
            bl = EventCountersKt.canWeeklyIntersect(event2, shiftedEvent1);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            bl = EventCountersKt.canMonthlyOnWeekdayIntersect(event2, shiftedEvent1);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            bl = EventCountersKt.canMonthlyOnLastWeekdayIntersect(event2, shiftedEvent1);
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            int monthsBetween = Math.INSTANCE.abs(ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2)));
            bl = shiftedFreq1.getDay() == ((RecurrenceRuleFreq.MonthlyOnDate)freq2).getDay() && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnDate)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnDate)freq2).getInterval());
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            int monthsBetween = Math.INSTANCE.abs(ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2)));
            bl = shiftedFreq1.getDay() == ADateJvmKt.getDayOfMonth(date2) && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnDate)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnStartDate)freq2).getInterval());
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
            bl = shiftedFreq1.getDay() == ADateJvmKt.getDayOfMonth(date2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final boolean canMonthlyOnStartDateIntersect(EventCounter event1, EventCounter event2) {
        boolean bl;
        boolean canHappenOnDifferentDate;
        RecurrenceRuleFreq freq1 = event1.getFrequency();
        RecurrenceRuleFreq freq2 = event2.getFrequency();
        KotlinXDate date1 = event1.getCurrentDate();
        KotlinXDate date2 = event2.getCurrentDate();
        boolean bl2 = freq1 instanceof RecurrenceRuleFreq.MonthlyOnStartDate;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        int originalDayOfMonth = ADateJvmKt.getDayOfMonth(ADateJvmKt.plusDays(date1, event1.getRelativity().getDateShift()));
        boolean bl7 = canHappenOnDifferentDate = event1.getRelativity() == RelativeDate.Next && originalDayOfMonth >= 28 || event1.getRelativity() == RelativeDate.Prev && originalDayOfMonth == 1;
        if (canHappenOnDifferentDate) {
            bl = true;
        } else {
            RecurrenceRuleFreq recurrenceRuleFreq = freq2;
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                bl = EventCountersKt.canDailyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                bl = EventCountersKt.canWeeklyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                bl = EventCountersKt.canMonthlyOnWeekdayIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                bl = EventCountersKt.canMonthlyOnLastWeekdayIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                bl = EventCountersKt.canMonthlyOnDateIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                int monthsBetween = Math.INSTANCE.abs(ADateJvmKt.monthsBetween(SpecIntersectsKt.monthStart(date1), SpecIntersectsKt.monthStart(date2)));
                bl = ADateJvmKt.getDayOfMonth(date1) == ADateJvmKt.getDayOfMonth(date2) && EventCountersKt.canIntersect(monthsBetween, ((RecurrenceRuleFreq.MonthlyOnStartDate)freq1).getInterval(), ((RecurrenceRuleFreq.MonthlyOnStartDate)freq2).getInterval());
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                bl = ADateJvmKt.getDayOfMonth(date1) == ADateJvmKt.getDayOfMonth(date2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean canYearlyIntersect(EventCounter event1, EventCounter event2) {
        boolean bl;
        boolean canHappenOnDifferentDate;
        RecurrenceRuleFreq freq1 = event1.getFrequency();
        RecurrenceRuleFreq freq2 = event2.getFrequency();
        KotlinXDate date1 = event1.getCurrentDate();
        KotlinXDate date2 = event2.getCurrentDate();
        boolean bl2 = freq1 instanceof RecurrenceRuleFreq.Yearly;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        KotlinXDate originalDate = ADateJvmKt.plusDays(date1, event1.getRelativity().getDateShift());
        boolean bl7 = canHappenOnDifferentDate = event1.getRelativity() == RelativeDate.Next && ADateJvmKt.getDayOfMonth(originalDate) == 28 && ADateJvmKt.getMonth(originalDate) == 2 || event1.getRelativity() == RelativeDate.Prev && (ADateJvmKt.getDayOfMonth(originalDate) == 1 && ADateJvmKt.getMonth(originalDate) == 3 || ADateJvmKt.getDayOfMonth(originalDate) == 29 && ADateJvmKt.getMonth(originalDate) == 2);
        if (canHappenOnDifferentDate) {
            bl = true;
        } else {
            RecurrenceRuleFreq recurrenceRuleFreq = freq2;
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                bl = EventCountersKt.canDailyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                bl = EventCountersKt.canWeeklyIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                bl = EventCountersKt.canMonthlyOnWeekdayIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                bl = EventCountersKt.canMonthlyOnLastWeekdayIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                bl = EventCountersKt.canMonthlyOnDateIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                bl = EventCountersKt.canMonthlyOnStartDateIntersect(event2, event1);
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                bl = ADateJvmKt.getDayOfMonth(date1) == ADateJvmKt.getDayOfMonth(date2) && ADateJvmKt.getMonth(date1) == ADateJvmKt.getMonth(date2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Nullable
    public static final KotlinXDate calcIntersectionDate(@NotNull EventCounter first, @NotNull RegularEventCounter second, @NotNull DatesInterval datesInterval) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Intrinsics.checkNotNullParameter((Object)datesInterval, (String)"datesInterval");
        if (!EventCountersKt.canIntersect(first, second)) {
            return null;
        }
        EventCounter masterEvent = null;
        EventCounter slaveEvent = null;
        if (first.getFrequencyOrder() > second.getFrequencyOrder()) {
            masterEvent = first;
            slaveEvent = second;
        } else {
            masterEvent = second;
            slaveEvent = first;
        }
        masterEvent.toNextEventAfterDate(datesInterval.getStart());
        slaveEvent.toNextEventAfterDate(datesInterval.getStart());
        int n = 1;
        do {
            int i = n++;
            slaveEvent.toNextEventAfterDate(masterEvent.getCurrentDate());
            KotlinXDate newSlaveDate = slaveEvent.getCurrentDate();
            if (Intrinsics.areEqual((Object)masterEvent.getCurrentDate(), (Object)newSlaveDate)) {
                return datesInterval.contains(newSlaveDate) ? newSlaveDate : null;
            }
            masterEvent.toNextEvent();
        } while (n <= 100);
        return null;
    }

    public static final int durationInMinutes(@NotNull CalendarEventSpec $this$durationInMinutes) {
        Intrinsics.checkNotNullParameter((Object)$this$durationInMinutes, (String)"<this>");
        return ADateKt.minutesDifferenceAbs($this$durationInMinutes.getEnd(), $this$durationInMinutes.getStart());
    }

    @Nullable
    public static final KotlinXDateTime lastOccurrenceEnd(@NotNull CalendarEventSpec $this$lastOccurrenceEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$lastOccurrenceEnd, (String)"<this>");
        KotlinXDateTime kotlinXDateTime = SpecIntersectsKt.lastOccurrenceStart($this$lastOccurrenceEnd);
        return kotlinXDateTime == null ? null : ADateJvmKt.plusMinutes(kotlinXDateTime, EventCountersKt.durationInMinutes($this$lastOccurrenceEnd));
    }

    public static final boolean hasEnded(@NotNull CalendarEventSpec $this$hasEnded) {
        Intrinsics.checkNotNullParameter((Object)$this$hasEnded, (String)"<this>");
        KotlinXDateTime end = EventCountersKt.lastOccurrenceEnd($this$hasEnded);
        return end != null && end.compareTo(ADateJvmKt.getANow()) < 0;
    }

    @NotNull
    public static final MeetingStart regularMeetingStart(@NotNull CalendarEventSpec $this$regularMeetingStart, @Nullable KotlinXDate startDate) {
        KotlinXDateTime kotlinXDateTime;
        Intrinsics.checkNotNullParameter((Object)$this$regularMeetingStart, (String)"<this>");
        KotlinXDate kotlinXDate = startDate;
        if (kotlinXDate == null) {
            kotlinXDateTime = null;
        } else {
            KotlinXDate kotlinXDate2 = kotlinXDate;
            boolean bl = false;
            boolean bl2 = false;
            KotlinXDate it = kotlinXDate2;
            boolean bl3 = false;
            kotlinXDateTime = SpecIntersectsKt.startTimeAtDay($this$regularMeetingStart, it);
        }
        KotlinXDateTime kotlinXDateTime2 = kotlinXDateTime;
        KotlinXDateTime startTime = kotlinXDateTime2 == null ? $this$regularMeetingStart.getStart() : kotlinXDateTime2;
        return new MeetingStart(startTime, new TimeInterval($this$regularMeetingStart.getStart(), EventCountersKt.lastOccurrenceEnd($this$regularMeetingStart)));
    }

    public static /* synthetic */ MeetingStart regularMeetingStart$default(CalendarEventSpec calendarEventSpec, KotlinXDate kotlinXDate, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDate = null;
        }
        return EventCountersKt.regularMeetingStart(calendarEventSpec, kotlinXDate);
    }

    public static final <T extends Comparable<? super T>> boolean intersects(@NotNull ClosedRange<T> $this$intersects, @NotNull ClosedRange<T> range3) {
        Intrinsics.checkNotNullParameter($this$intersects, (String)"<this>");
        Intrinsics.checkNotNullParameter(range3, (String)"range");
        Comparable intersectionStart = ComparisonsKt.maxOf((Comparable)$this$intersects.getStart(), (Comparable)range3.getStart());
        Comparable intersectionEnd = ComparisonsKt.minOf((Comparable)$this$intersects.getEndInclusive(), (Comparable)range3.getEndInclusive());
        return intersectionStart.compareTo(intersectionEnd) < 0;
    }

    private static final KotlinXDateTime maxTime(KotlinXDateTime ... time) {
        Object object = ArraysKt.maxWithOrNull((Object[])time, timeComparator);
        Intrinsics.checkNotNull((Object)object);
        return (KotlinXDateTime)object;
    }

    private static final KotlinXDateTime minTime(KotlinXDateTime ... time) {
        Object object = ArraysKt.minWithOrNull((Object[])time, timeComparator);
        Intrinsics.checkNotNull((Object)object);
        return (KotlinXDateTime)object;
    }

    private static final KotlinXDate weekStart(KotlinXDate $this$weekStart) {
        KotlinXDate weekStart = $this$weekStart;
        while (ADateJvmKt.getWeekday(weekStart).getOrderNumber() != 0) {
            weekStart = ADateJvmKt.plusDays(weekStart, -1);
        }
        return weekStart;
    }

    private static final boolean canIntersect(int diff, int interval1, int interval2) {
        return diff % Math.INSTANCE.gcd(interval1, interval2) == 0;
    }

    public static final /* synthetic */ KotlinXDate access$weekStart(KotlinXDate $receiver) {
        return EventCountersKt.weekStart($receiver);
    }

    public static final /* synthetic */ KotlinXDateTime access$maxTime(KotlinXDateTime ... time) {
        return EventCountersKt.maxTime(time);
    }

    public static final /* synthetic */ KotlinXDateTime access$minTime(KotlinXDateTime ... time) {
        return EventCountersKt.minTime(time);
    }

    static {
        boolean bl = false;
        timeComparator = new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                KotlinXDateTime it = (KotlinXDateTime)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(ADateJvmKt.getMillis(it));
                it = (KotlinXDateTime)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Long.valueOf(ADateJvmKt.getMillis(it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
    }
}

