/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.RecurrenceRule;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.Weekday;
import circlet.platform.api.WeekdayFormat;
import circlet.platform.api.WorkingDaysKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000b\u001a\u00020\u0001*\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0012\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"formatMinutesAsDuration", "", "minutes", "", "precise", "", "formatMinutesAsTime", "minutesOfDay", "order", "freq", "Lcirclet/common/calendar/RecurrenceRuleFreq$MonthlyOnFirstWeekday;", "format", "Lcirclet/common/calendar/RecurrenceRule;", "start", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "weekdayFormat", "Lcirclet/platform/api/WeekdayFormat;", "weekdaysText", "", "Lcirclet/platform/api/Weekday;", "common"})
public final class FormatKt {
    @NotNull
    public static final String formatMinutesAsTime(int minutesOfDay) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$formatMinutesAsTime_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        $this$formatMinutesAsTime_u24lambda_u2d0.append(StringsKt.padStart((String)String.valueOf(minutesOfDay / 60), (int)2, (char)'0'));
        $this$formatMinutesAsTime_u24lambda_u2d0.append(':');
        $this$formatMinutesAsTime_u24lambda_u2d0.append(StringsKt.padStart((String)String.valueOf(minutesOfDay % 60), (int)2, (char)'0'));
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public static final String formatMinutesAsDuration(int minutes, boolean precise) {
        if (precise) {
            return minutes < 60 ? minutes + " min" : (minutes % 60 == 0 ? minutes / 60 + " h" : minutes / 60 + " h " + minutes % 60 + " min");
        }
        return minutes < 60 ? minutes + " min" : (minutes < 1440 && minutes % 60 == 0 ? minutes / 60 + " h" : (minutes < 1440 ? minutes / 60 + " h " + minutes % 60 + " min" : (minutes < 10080 ? minutes / 1440 + " d" : minutes / 10080 + " w")));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String format(@NotNull RecurrenceRule $this$format, @NotNull KotlinXDateTime start2, @NotNull WeekdayFormat weekdayFormat) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)((Object)weekdayFormat), (String)"weekdayFormat");
        boolean bl = false;
        List res = new ArrayList();
        RecurrenceRuleFreq freq = $this$format.getFreq();
        if (freq instanceof RecurrenceRuleFreq.Daily) {
            res.add(((RecurrenceRuleFreq.Daily)freq).getInterval() == 1 ? "daily" : "every " + ((RecurrenceRuleFreq.Daily)freq).getInterval() + " days");
        } else if (freq instanceof RecurrenceRuleFreq.Weekly) {
            String string2;
            res.add(((RecurrenceRuleFreq.Weekly)freq).getInterval() == 1 ? "weekly" : "every " + ((RecurrenceRuleFreq.Weekly)freq).getInterval() + " weeks");
            List list = res;
            int n = ((RecurrenceRuleFreq.Weekly)freq).getWeekdays().size();
            if (n == 0) {
                string2 = "";
            } else if (n == 1) {
                string2 = Intrinsics.stringPlus((String)"on ", (Object)WorkingDaysKt.title((Weekday)CollectionsKt.single(((RecurrenceRuleFreq.Weekly)freq).getWeekdays()), weekdayFormat));
            } else if (n == WorkingDaysKt.getDefaultWorkingDays().size()) {
                Collection<Integer> collection;
                void $this$mapTo$iv$iv;
                Iterable iterable = ((RecurrenceRuleFreq.Weekly)freq).getWeekdays();
                Set<Integer> set = WorkingDaysKt.getDefaultWorkingDays();
                List list2 = list;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Weekday weekday = (Weekday)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Integer n2 = it.getOrderNumber();
                    collection.add(n2);
                }
                collection = (List)destination$iv$iv;
                list = list2;
                string2 = set.containsAll(collection) ? "on weekdays" : FormatKt.weekdaysText(((RecurrenceRuleFreq.Weekly)freq).getWeekdays(), weekdayFormat);
            } else {
                string2 = n == 7 ? "on all days" : FormatKt.weekdaysText(((RecurrenceRuleFreq.Weekly)freq).getWeekdays(), weekdayFormat);
            }
            list.add(string2);
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            res.add(((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval() + " months");
            res.add(Intrinsics.stringPlus((String)"on day ", (Object)ADateJvmKt.getDayOfMonth(start2)));
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            res.add(((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval() + " months");
            res.add(Intrinsics.stringPlus((String)"on day ", (Object)((RecurrenceRuleFreq.MonthlyOnDate)freq).getDay()));
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            res.add(((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval() + " months");
            res.add("on " + FormatKt.order((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq) + ' ' + WorkingDaysKt.title(((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getWeekday(), weekdayFormat));
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            res.add(((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval() + " months");
            res.add(Intrinsics.stringPlus((String)"on last ", (Object)WorkingDaysKt.title(((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getWeekday(), weekdayFormat)));
        } else if (freq instanceof RecurrenceRuleFreq.Yearly) {
            res.add(((RecurrenceRuleFreq.Yearly)freq).getInterval() == 1 ? "yearly" : "every " + ((RecurrenceRuleFreq.Yearly)freq).getInterval() + " years");
        }
        Iterable $this$filterNot$iv = res;
        boolean $i$f$filterNot = false;
        $this$map$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
    }

    public static /* synthetic */ String format$default(RecurrenceRule recurrenceRule, KotlinXDateTime kotlinXDateTime, WeekdayFormat weekdayFormat, int n, Object object) {
        if ((n & 2) != 0) {
            weekdayFormat = WeekdayFormat.LONG;
        }
        return FormatKt.format(recurrenceRule, kotlinXDateTime, weekdayFormat);
    }

    private static final String order(RecurrenceRuleFreq.MonthlyOnFirstWeekday freq) {
        String string2;
        int shift = freq.getShift() + 1;
        switch (shift) {
            case 1: {
                string2 = "the first";
                break;
            }
            case 2: {
                string2 = "the second";
                break;
            }
            case 3: {
                string2 = "the third";
                break;
            }
            case 4: {
                string2 = "the fourth";
                break;
            }
            case 5: {
                string2 = "the fifth";
                break;
            }
            default: {
                string2 = "the " + shift + "th";
            }
        }
        return string2;
    }

    private static final String weekdaysText(List<? extends Weekday> $this$weekdaysText, WeekdayFormat format) {
        return "on " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast($this$weekdaysText, (int)1), null, null, null, (int)0, null, (Function1)((Function1)new Function1<Weekday, CharSequence>(format){
            final /* synthetic */ WeekdayFormat $format;
            {
                this.$format = $format;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Weekday it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return WorkingDaysKt.title(it, this.$format);
            }
        }), (int)31, null) + " and " + WorkingDaysKt.title((Weekday)CollectionsKt.last($this$weekdaysText), format);
    }
}

