/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client;

import circlet.platform.api.CallContextImpl;
import circlet.platform.api.Packet;
import circlet.platform.api.serialization.ExtendableSerializationRegistry;
import circlet.platform.api.services.impl.ParserFunctionsKt;
import circlet.platform.client.ConnectionHolderKt;
import circlet.platform.client.ConnectionHolderState;
import circlet.platform.client.circlet.platform.client.EpochTracker;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.channels.Channel;
import libraries.coroutines.extra.Lifetime;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.FailureInfo;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.net.WebSocket;
import runtime.net.WebSocketFactory;
import runtime.net.WebSocketJsonMessage;
import runtime.net.WebSocketListener;
import runtime.net.WebSocketMessage;
import runtime.net.WebSocketState;
import runtime.net.WebSocketTextMessage;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000f0\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020!H\u0002J\u001f\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!0'H\u0082\bJ\u0010\u0010(\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0014H\u0016J\u0010\u0010)\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0014H\u0016J\u0018\u0010*\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020!2\u0006\u00101\u001a\u000202H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcirclet/platform/client/ConnectionHolder;", "Lruntime/net/WebSocketListener;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "registry", "Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "received", "Lkotlinx/coroutines/channels/Channel;", "Lcirclet/platform/api/Packet;", "socketsFactory", "Lruntime/net/WebSocketFactory;", "url", "", "headers", "", "Lkotlin/Pair;", "epochTracker", "Lcirclet/platform/client/circlet/platform/client/EpochTracker;", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;Lkotlinx/coroutines/channels/Channel;Lruntime/net/WebSocketFactory;Ljava/lang/String;Ljava/util/List;Lcirclet/platform/client/circlet/platform/client/EpochTracker;)V", "connection", "Lruntime/net/WebSocket;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "getReceived", "()Lkotlinx/coroutines/channels/Channel;", "getRegistry", "()Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "state", "Lruntime/reactive/MutableProperty;", "Lcirclet/platform/client/ConnectionHolderState;", "getState", "()Lruntime/reactive/MutableProperty;", "close", "", "_state", "closeConnection", "closeIfTerminated", "ws", "action", "Lkotlin/Function0;", "onConnectionClosed", "onConnectionOpen", "onFailure", "reason", "", "onMessage", "message", "Lruntime/net/WebSocketMessage;", "onMessageReceived", "packetJson", "Lruntime/json/JsonElement;", "platform-client"})
public final class ConnectionHolder
implements WebSocketListener {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ExtendableSerializationRegistry registry;
    @NotNull
    private final Channel<Packet> received;
    @NotNull
    private final String url;
    @Nullable
    private final EpochTracker epochTracker;
    @NotNull
    private final MutableProperty<ConnectionHolderState> state;
    @NotNull
    private final WebSocket connection;

    /*
     * WARNING - void declaration
     */
    public ConnectionHolder(@NotNull Lifetime lifetime, @NotNull ExtendableSerializationRegistry registry, @NotNull Channel<Packet> received, @NotNull WebSocketFactory socketsFactory, @NotNull String url2, @NotNull List<Pair<String, String>> headers, @Nullable EpochTracker epochTracker) {
        List list;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(received, (String)"received");
        Intrinsics.checkNotNullParameter((Object)socketsFactory, (String)"socketsFactory");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.lifetime = lifetime;
        this.registry = registry;
        this.received = received;
        this.url = url2;
        this.epochTracker = epochTracker;
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            object2 = this_$iv;
            boolean bl = false;
            object = "new ConnectionHolder";
            ((KLogger)object2).debug(object);
        }
        this.state = CellableKt.mutableProperty(ConnectionHolderState.Initial.INSTANCE);
        Object object3 = this;
        Object object4 = socketsFactory;
        String string2 = this.url;
        WebSocketListener webSocketListener = this;
        EpochTracker epochTracker2 = this.epochTracker;
        if (epochTracker2 == null) {
            list = headers;
        } else {
            void it;
            EpochTracker epochTracker3 = epochTracker2;
            boolean bl = false;
            boolean bl2 = false;
            EpochTracker epochTracker4 = epochTracker3;
            WebSocketListener webSocketListener2 = webSocketListener;
            String string3 = string2;
            object = object4;
            object2 = object3;
            boolean bl3 = false;
            List list2 = CollectionsKt.plus((Collection)headers, (Object)new Pair((Object)"epoch", (Object)String.valueOf(it.maxEpoch())));
            object3 = object2;
            object4 = object;
            string2 = string3;
            webSocketListener = webSocketListener2;
            List list3 = list2;
            list = list3 == null ? headers : list3;
        }
        ((ConnectionHolder)object3).connection = object4.createWebSocket(string2, webSocketListener, list);
        this.lifetime.addOrCallImmediately((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.closeConnection();
            }
        }));
    }

    public /* synthetic */ ConnectionHolder(Lifetime lifetime, ExtendableSerializationRegistry extendableSerializationRegistry, Channel channel2, WebSocketFactory webSocketFactory, String string2, List list, EpochTracker epochTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(lifetime, extendableSerializationRegistry, (Channel<Packet>)channel2, webSocketFactory, string2, list, epochTracker);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ExtendableSerializationRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final Channel<Packet> getReceived() {
        return this.received;
    }

    @NotNull
    public final MutableProperty<ConnectionHolderState> getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onMessage(@NotNull WebSocket ws, @NotNull WebSocketMessage message2) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ConnectionHolder this_$iv = this;
        boolean $i$f$closeIfTerminated = false;
        if (this_$iv.getLifetime().isTerminated()) {
            ws.close();
            return;
        }
        boolean bl = false;
        WebSocketMessage webSocketMessage = message2;
        if (webSocketMessage instanceof WebSocketTextMessage) {
            this.onMessageReceived(JsonDslKt.jsonElement(((WebSocketTextMessage)message2).getMessage()));
            return;
        }
        if (webSocketMessage instanceof WebSocketJsonMessage) {
            this.onMessageReceived(((WebSocketJsonMessage)message2).getJson());
            return;
        }
        String string2 = "Message of type \"" + Reflection.getOrCreateKotlinClass(message2.getClass()) + "\" is not expected";
        boolean bl2 = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onMessageReceived(JsonElement packetJson2) {
        Packet packet = ParserFunctionsKt.parse_Packet(packetJson2, new CallContextImpl(this.registry, null, null, null, 12, null));
        Long l = packet.getEpoch();
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            EpochTracker epochTracker = this.epochTracker;
            if (epochTracker != null) {
                epochTracker.updateEpoch(it);
            }
        }
        if (packet.getFailure() != null && packet.getId() == 0) {
            FailureInfo failureInfo = packet.getFailure();
            Intrinsics.checkNotNull((Object)failureInfo);
            if (failureInfo.getAuthenticationError() != null) {
                KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
                boolean $i$f$debug = false;
                if (this_$iv.isDebugEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    FailureInfo failureInfo2 = packet.getFailure();
                    String string2 = Intrinsics.stringPlus((String)"onMessageReceived that contains auth failed ", (Object)(failureInfo2 == null ? null : failureInfo2.getAuthenticationError()));
                    kLogger.debug(string2);
                }
                FailureInfo failureInfo3 = packet.getFailure();
                Intrinsics.checkNotNull((Object)failureInfo3);
                String string3 = failureInfo3.getAuthenticationError();
                Intrinsics.checkNotNull((Object)string3);
                this.close(new ConnectionHolderState.AuthFailed("", string3));
                return;
            }
        }
        this.received.offer((Object)packet);
    }

    @Override
    public void onFailure(@NotNull WebSocket ws, int reason) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        ConnectionHolder this_$iv = this;
        boolean $i$f$closeIfTerminated = false;
        if (!this_$iv.getLifetime().isTerminated()) {
            boolean bl = false;
            KLogger this_$iv2 = ConnectionHolderKt.access$getLog$p();
            boolean $i$f$debug = false;
            if (this_$iv2.isDebugEnabled()) {
                KLogger kLogger = this_$iv2;
                boolean bl2 = false;
                String string2 = Intrinsics.stringPlus((String)"onFailure ", (Object)reason);
                kLogger.debug(string2);
            }
            int n = reason;
            switch (n) {
                case 401: {
                    this.close(new ConnectionHolderState.AuthFailed("401", "Web socket is closed due to authentication failure."));
                    break;
                }
                case 404: {
                    this.close(new ConnectionHolderState.AuthFailed("404", Intrinsics.stringPlus((String)this.url, (Object)" is not found")));
                    break;
                }
                case 408: {
                    this.close(new ConnectionHolderState.AuthFailed("408", "Connection to " + this.url + " timed out"));
                    break;
                }
                default: {
                    this.close(ConnectionHolderState.Closed.INSTANCE);
                }
            }
        } else {
            ws.close();
        }
    }

    @Override
    public void onConnectionOpen(@NotNull WebSocket ws) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        Object this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (((KLogger)this_$iv).isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string2 = "on open";
            kLogger.debug(string2);
        }
        this_$iv = this;
        boolean $i$f$closeIfTerminated = false;
        if (!((ConnectionHolder)this_$iv).getLifetime().isTerminated()) {
            boolean bl = false;
            this.getState().setValue(new ConnectionHolderState.Open(ws));
        } else {
            ws.close();
        }
    }

    @Override
    public void onConnectionClosed(@NotNull WebSocket ws) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string2 = "on closed";
            kLogger.debug(string2);
        }
        this.state.setValue(ConnectionHolderState.Closed.INSTANCE);
    }

    private final void closeIfTerminated(WebSocket ws, Function0<Unit> action2) {
        boolean $i$f$closeIfTerminated = false;
        if (!this.getLifetime().isTerminated()) {
            action2.invoke();
        } else {
            ws.close();
        }
    }

    private final void close(ConnectionHolderState _state) {
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"close reason ", (Object)Reflection.getOrCreateKotlinClass(_state.getClass()).getSimpleName());
            kLogger.debug(string2);
        }
        this.state.setValue(_state);
        this.closeConnection();
    }

    private final void closeConnection() {
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string2 = "do close";
            kLogger.trace(string2);
        }
        if (!Intrinsics.areEqual((Object)this.connection.getConnectState().name(), (Object)WebSocketState.CLOSED.name())) {
            this.connection.close();
        }
    }
}

