/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client;

import circlet.platform.api.ClientSupportFlag;
import circlet.platform.api.ClientType;
import circlet.platform.api.oauth.OpenSet;
import circlet.platform.api.oauth.TokenInfo;
import circlet.platform.api.oauth.TokenSource;
import circlet.platform.api.serialization.ExtendableSerializationRegistry;
import circlet.platform.client.ApiService;
import circlet.platform.client.ArenaManager;
import circlet.platform.client.ConnectionStatus;
import circlet.platform.client.ConnectionStatusSource;
import circlet.platform.client.KCircletClientKt;
import circlet.platform.client.WebSocketStableConnection;
import circlet.platform.client.WebSocketTransport;
import circlet.platform.client.arenas.ArenaRestore;
import circlet.platform.client.arenas.DefaultArenaRestore;
import circlet.platform.client.circlet.platform.client.EpochTracker;
import circlet.platform.metrics.Telemetry;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import libraries.io.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.JVMDateTimeServiceKt;
import runtime.net.WebSocketFactory;
import runtime.net.WebSocketTextMessage;
import runtime.persistence.Persistence;
import runtime.persistence.PersistenceConfiguration;
import runtime.reactive.MutableProperty;
import runtime.routing.ActionCookies;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 f2\u00020\u0001:\u0001fB\u00ad\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u001a\b\u0002\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010!J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0003J%\u0010Z\u001a\u0002H[\"\u0004\b\u0000\u0010[2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H[0]\u00a2\u0006\u0002\u0010^J;\u0010_\u001a\u0002H[\"\u0004\b\u0000\u0010[2\"\u0010\\\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H[0a\u0012\u0006\u0012\u0004\u0018\u00010b0`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010cJ\u000e\u0010d\u001a\u00020X2\u0006\u0010e\u001a\u00020\u0007R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\b\u0012\u0004\u0012\u000202018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R#\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R*\u0010=\u001a\u00020<2\u0006\u0010;\u001a\u00020<@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u0011\u0010O\u001a\u00020P8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006g"}, d2={"Lcirclet/platform/client/KCircletClient;", "Lcirclet/platform/client/ConnectionStatusSource;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "tokenSource", "Lcirclet/platform/api/oauth/TokenSource;", "server", "", "persistence", "Lruntime/persistence/Persistence;", "persistenceConfiguration", "Lruntime/persistence/PersistenceConfiguration;", "registry", "Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "headers", "", "Lkotlin/Pair;", "features", "Lcirclet/platform/api/oauth/OpenSet;", "Lcirclet/platform/api/ClientSupportFlag;", "clientType", "Lcirclet/platform/api/ClientType;", "clientTimezone", "socketsFactory", "Lruntime/net/WebSocketFactory;", "wsReconnectDelay", "", "telemetry", "Lcirclet/platform/metrics/Telemetry;", "arenaRestore", "Lcirclet/platform/client/arenas/ArenaRestore;", "epochTracker", "Lcirclet/platform/client/circlet/platform/client/EpochTracker;", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/platform/api/oauth/TokenSource;Ljava/lang/String;Lruntime/persistence/Persistence;Lruntime/persistence/PersistenceConfiguration;Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;Ljava/util/List;Lcirclet/platform/api/oauth/OpenSet;Lcirclet/platform/api/ClientType;Ljava/lang/String;Lruntime/net/WebSocketFactory;ILcirclet/platform/metrics/Telemetry;Lcirclet/platform/client/arenas/ArenaRestore;Lcirclet/platform/client/circlet/platform/client/EpochTracker;)V", "api", "Lcirclet/platform/client/ApiService;", "getApi", "()Lcirclet/platform/client/ApiService;", "arena", "Lcirclet/platform/client/ArenaManager;", "getArena", "()Lcirclet/platform/client/ArenaManager;", "getClientTimezone", "()Ljava/lang/String;", "getClientType", "()Lcirclet/platform/api/ClientType;", "connection", "Lcirclet/platform/client/WebSocketStableConnection;", "connectionStatus", "Lruntime/reactive/MutableProperty;", "Lcirclet/platform/client/ConnectionStatus;", "getConnectionStatus", "()Lruntime/reactive/MutableProperty;", "getFeatures", "()Lcirclet/platform/api/oauth/OpenSet;", "getHeaders", "()Ljava/util/List;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "value", "", "logReceivedPackets", "getLogReceivedPackets$annotations", "()V", "getLogReceivedPackets", "()Z", "setLogReceivedPackets", "(Z)V", "getPersistence", "()Lruntime/persistence/Persistence;", "getPersistenceConfiguration", "()Lruntime/persistence/PersistenceConfiguration;", "getRegistry", "()Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "sessionId", "getSocketsFactory", "()Lruntime/net/WebSocketFactory;", "getTelemetry", "()Lcirclet/platform/metrics/Telemetry;", "token", "Lcirclet/platform/api/oauth/TokenInfo;", "getToken", "()Lcirclet/platform/api/oauth/TokenInfo;", "getTokenSource", "()Lcirclet/platform/api/oauth/TokenSource;", "transport", "Lcirclet/platform/client/WebSocketTransport;", "interruptConnection", "", "interruptLifetime", "newClient", "T", "clientFactory", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "newClientAsync", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendPacketInternal", "payload", "Companion", "platform-client"})
public final class KCircletClient
implements ConnectionStatusSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final TokenSource tokenSource;
    @NotNull
    private final String server;
    @NotNull
    private final Persistence persistence;
    @NotNull
    private final PersistenceConfiguration persistenceConfiguration;
    @NotNull
    private final ExtendableSerializationRegistry registry;
    @NotNull
    private final List<Pair<String, String>> headers;
    @NotNull
    private final OpenSet<ClientSupportFlag> features;
    @NotNull
    private final ClientType clientType;
    @Nullable
    private final String clientTimezone;
    @NotNull
    private final WebSocketFactory socketsFactory;
    @Nullable
    private final Telemetry telemetry;
    @NotNull
    private final String sessionId;
    @NotNull
    private final WebSocketStableConnection connection;
    @NotNull
    private final WebSocketTransport transport;
    @NotNull
    private final ApiService api;
    @NotNull
    private final ArenaManager arena;
    private boolean logReceivedPackets;

    public KCircletClient(@NotNull Lifetime lifetime, @NotNull TokenSource tokenSource, @NotNull String server2, @NotNull Persistence persistence2, @NotNull PersistenceConfiguration persistenceConfiguration, @NotNull ExtendableSerializationRegistry registry, @NotNull List<Pair<String, String>> headers, @NotNull OpenSet<ClientSupportFlag> features2, @NotNull ClientType clientType, @Nullable String clientTimezone, @NotNull WebSocketFactory socketsFactory, int wsReconnectDelay, @Nullable Telemetry telemetry, @NotNull ArenaRestore arenaRestore, @Nullable EpochTracker epochTracker) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)tokenSource, (String)"tokenSource");
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server");
        Intrinsics.checkNotNullParameter((Object)persistence2, (String)"persistence");
        Intrinsics.checkNotNullParameter((Object)persistenceConfiguration, (String)"persistenceConfiguration");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(features2, (String)"features");
        Intrinsics.checkNotNullParameter((Object)((Object)clientType), (String)"clientType");
        Intrinsics.checkNotNullParameter((Object)socketsFactory, (String)"socketsFactory");
        Intrinsics.checkNotNullParameter((Object)arenaRestore, (String)"arenaRestore");
        this.lifetime = lifetime;
        this.tokenSource = tokenSource;
        this.server = server2;
        this.persistence = persistence2;
        this.persistenceConfiguration = persistenceConfiguration;
        this.registry = registry;
        this.headers = headers;
        this.features = features2;
        this.clientType = clientType;
        this.clientTimezone = clientTimezone;
        this.socketsFactory = socketsFactory;
        this.telemetry = telemetry;
        this.sessionId = KCircletClient.Companion.nextSessionId();
        Lifetime lifetime2 = this.lifetime;
        String string2 = KCircletClientKt.webSocketUrl(this.server);
        TokenSource tokenSource2 = this.tokenSource;
        String string3 = this.sessionId;
        WebSocketFactory webSocketFactory = this.socketsFactory;
        ExtendableSerializationRegistry extendableSerializationRegistry = this.registry;
        List<Pair<String, String>> list = this.headers;
        OpenSet<ClientSupportFlag> openSet = this.features;
        ClientType clientType2 = this.clientType;
        String string4 = this.clientTimezone;
        this.connection = new WebSocketStableConnection(lifetime2, string2, tokenSource2, string3, webSocketFactory, extendableSerializationRegistry, list, openSet, clientType2, string4, wsReconnectDelay, epochTracker);
        this.transport = new WebSocketTransport(this.lifetime, this.connection, JVMDateTimeServiceKt.getDefaultTimeService(), this.registry, ActionCookies.INSTANCE);
        this.api = new ApiService(this.lifetime, this.transport, this.registry, (Function0<ArenaManager>)((Function0)new Function0<ArenaManager>(this){
            final /* synthetic */ KCircletClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ArenaManager invoke() {
                return this.this$0.getArena();
            }
        }));
        this.arena = new ArenaManager(this.lifetime, this, this.registry, arenaRestore, this.telemetry);
    }

    public /* synthetic */ KCircletClient(Lifetime lifetime, TokenSource tokenSource, String string2, Persistence persistence2, PersistenceConfiguration persistenceConfiguration, ExtendableSerializationRegistry extendableSerializationRegistry, List list, OpenSet openSet, ClientType clientType, String string3, WebSocketFactory webSocketFactory, int n, Telemetry telemetry, ArenaRestore arenaRestore, EpochTracker epochTracker, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            extendableSerializationRegistry = ExtendableSerializationRegistry.Companion.getGlobal();
        }
        if ((n2 & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x80) != 0) {
            openSet = OpenSet.None.INSTANCE;
        }
        if ((n2 & 0x100) != 0) {
            clientType = ClientType.Other;
        }
        if ((n2 & 0x200) != 0) {
            string3 = null;
        }
        if ((n2 & 0x800) != 0) {
            n = 2000;
        }
        if ((n2 & 0x1000) != 0) {
            telemetry = null;
        }
        if ((n2 & 0x2000) != 0) {
            arenaRestore = DefaultArenaRestore.INSTANCE;
        }
        if ((n2 & 0x4000) != 0) {
            epochTracker = null;
        }
        this(lifetime, tokenSource, string2, persistence2, persistenceConfiguration, extendableSerializationRegistry, list, openSet, clientType, string3, webSocketFactory, n, telemetry, arenaRestore, epochTracker);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final TokenSource getTokenSource() {
        return this.tokenSource;
    }

    @NotNull
    public final Persistence getPersistence() {
        return this.persistence;
    }

    @NotNull
    public final PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    @NotNull
    public final ExtendableSerializationRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final List<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final OpenSet<ClientSupportFlag> getFeatures() {
        return this.features;
    }

    @NotNull
    public final ClientType getClientType() {
        return this.clientType;
    }

    @Nullable
    public final String getClientTimezone() {
        return this.clientTimezone;
    }

    @NotNull
    public final WebSocketFactory getSocketsFactory() {
        return this.socketsFactory;
    }

    @Nullable
    public final Telemetry getTelemetry() {
        return this.telemetry;
    }

    @NotNull
    public final ApiService getApi() {
        return this.api;
    }

    @NotNull
    public final ArenaManager getArena() {
        return this.arena;
    }

    @NotNull
    public final TokenInfo getToken() {
        return this.tokenSource.lastToken();
    }

    public final boolean getLogReceivedPackets() {
        return this.logReceivedPackets;
    }

    public final void setLogReceivedPackets(boolean value2) {
        this.logReceivedPackets = value2;
        this.transport.setLogReceivedMessagesAs(this.logReceivedPackets ? this.sessionId : null);
    }

    public static /* synthetic */ void getLogReceivedPackets$annotations() {
    }

    public final void interruptConnection(@NotNull Lifetime interruptLifetime) {
        Intrinsics.checkNotNullParameter((Object)interruptLifetime, (String)"interruptLifetime");
        this.connection.interrupt(interruptLifetime);
    }

    public final void sendPacketInternal(@NotNull String payload2) {
        Intrinsics.checkNotNullParameter((Object)payload2, (String)"payload");
        ConnectionStatus.Connected status2 = (ConnectionStatus.Connected)this.getConnectionStatus().getValue();
        status2.getConnection$platform_client().send(new WebSocketTextMessage(payload2));
    }

    @NotNull
    public MutableProperty<ConnectionStatus> getConnectionStatus() {
        return this.connection.getStatus();
    }

    public final <T> T newClient(@NotNull Function1<? super String, ? extends T> clientFactory) {
        Intrinsics.checkNotNullParameter(clientFactory, (String)"clientFactory");
        return (T)clientFactory.invoke((Object)this.server);
    }

    @Nullable
    public final <T> Object newClientAsync(@NotNull Function2<? super String, ? super Continuation<? super T>, ? extends Object> clientFactory, @NotNull Continuation<? super T> $completion) {
        return clientFactory.invoke((Object)this.server, $completion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcirclet/platform/client/KCircletClient$Companion;", "", "()V", "nextSessionId", "", "platform-client"})
    public static final class Companion {
        private Companion() {
        }

        private final String nextSessionId() {
            return Random.INSTANCE.nextString(64);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

