/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import libraries.collections.AbstractHashMap;
import libraries.collections.HashUtil;
import libraries.collections.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\"#$B\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0003H\u0014J\u0018\u0010\u001a\u001a\u00120\u001bR\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u001f\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0017\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f0\u000bX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u000f\u0012\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Llibraries/collections/LongHashMap;", "V", "Llibraries/collections/AbstractHashMap;", "", "capacity", "", "loadFactor", "", "(IF)V", "mask", "table", "", "Llibraries/collections/LongHashMap$Entry;", "getTable$annotations", "()V", "[Llibraries/collections/LongHashMap$Entry;", "allocateTable", "", "length", "containsKey", "", "key", "get", "(J)Ljava/lang/Object;", "getEntry", "", "hashIterator", "Llibraries/collections/AbstractHashMap$HashMapIterator;", "init", "put", "value", "(JLjava/lang/Object;)Ljava/lang/Object;", "rehash", "remove", "Companion", "Entry", "HashIterator", "libraries-collections"})
public final class LongHashMap<V>
extends AbstractHashMap<Long, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float loadFactor;
    @NotNull
    private Entry<V>[] table;
    private int capacity;
    private int mask;
    @NotNull
    private static final Entry<?>[] hack = new Entry[0];

    public LongHashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = hack;
        this.init(capacity);
    }

    public /* synthetic */ LongHashMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        this(n, f);
    }

    private static /* synthetic */ void getTable$annotations() {
    }

    @Nullable
    public V get(long key2) {
        Map.Entry<Long, V> e = this.getEntry(key2);
        Map.Entry<Long, V> entry = e;
        return entry == null ? null : (V)entry.getValue();
    }

    @Nullable
    public V put(long key2, V value2) {
        Entry<V>[] table = this.table;
        int index = HashUtil.INSTANCE.indexFor(key2, table.length, this.mask);
        LongHashMap longHashMap = this;
        boolean bl = false;
        boolean bl2 = false;
        LongHashMap $this$put_u24lambda_u2d0 = longHashMap;
        boolean bl3 = false;
        for (Entry<V> e = table[index]; e != null; e = e.getHashNext()) {
            if (e.getKey() != key2) continue;
            return e.setValue(value2);
        }
        Entry<V> e = new Entry<V>(key2, value2);
        e.setHashNext(table[index]);
        table[index] = e;
        LongHashMap longHashMap2 = this;
        longHashMap2.setSize(longHashMap2.size() + 1);
        if (this.size() > this.capacity) {
            this.rehash(HashUtil.INSTANCE.nextCapacity(this.capacity));
        }
        return null;
    }

    public boolean containsKey(long key2) {
        return this.get((Object)key2) != null;
    }

    @Nullable
    public V remove(long key2) {
        Entry<V>[] table = this.table;
        int index = HashUtil.INSTANCE.indexFor(key2, table.length, this.mask);
        Object object = table[index];
        if (object == null) {
            return null;
        }
        Object e = object;
        if (e.getKey() == key2) {
            table[index] = e.getHashNext();
        } else {
            Entry<V> last;
            Entry<V> entry;
            do {
                last = e;
                entry = e.getHashNext();
                if (entry != null) continue;
                return null;
            } while ((e = entry).getKey() != key2);
            last.setHashNext(e.getHashNext());
        }
        object = this;
        ((AbstractHashMap)((Object)object)).setSize(object.size() - 1);
        return e.getValue();
    }

    @Override
    @Nullable
    protected Map.Entry<Long, V> getEntry(long key2) {
        Entry<V>[] table = this.table;
        int index = HashUtil.INSTANCE.indexFor(key2, table.length, this.mask);
        for (Entry<V> e = table[index]; e != null; e = e.getHashNext()) {
            if (e.getKey() != key2) continue;
            return e;
        }
        return null;
    }

    @Override
    protected void init(int capacity) {
        int proposedCapacity = capacity;
        if (proposedCapacity < 4) {
            proposedCapacity = 4;
        }
        this.allocateTable(HashUtil.INSTANCE.getCeilingPrime((int)((float)proposedCapacity / this.loadFactor)));
        this.capacity = proposedCapacity;
        this.setSize(0);
    }

    @Override
    @NotNull
    protected AbstractHashMap.HashMapIterator hashIterator() {
        return new HashIterator();
    }

    private final void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.INSTANCE.integerLogarithm(this.table.length)) - 1;
    }

    private final void rehash(int capacity) {
        int length = HashUtil.INSTANCE.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            Iterator entries = this.entrySet().iterator();
            this.allocateTable(length);
            Entry<V>[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index = HashUtil.INSTANCE.indexFor(e.getKey(), length, mask);
                e.setHashNext(table[index]);
                table[index] = e;
            }
        }
    }

    public LongHashMap() {
        this(0, 0.0f, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\t\n\u0002\b\u0012\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0014R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0005\u001a\u00028\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Llibraries/collections/LongHashMap$Entry;", "V", "", "", "key", "value", "(JLjava/lang/Object;)V", "hashNext", "getHashNext", "()Llibraries/collections/LongHashMap$Entry;", "setHashNext", "(Llibraries/collections/LongHashMap$Entry;)V", "getKey", "()Ljava/lang/Long;", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "libraries-collections"})
    private static final class Entry<V>
    implements Map.Entry<Long, V>,
    KMutableMap.Entry {
        private final long key;
        private V value;
        @Nullable
        private Entry<V> hashNext;

        public Entry(long key2, V value2) {
            this.key = key2;
            this.value = value2;
        }

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(V v) {
            this.value = v;
        }

        @Nullable
        public final Entry<V> getHashNext() {
            return this.hashNext;
        }

        public final void setHashNext(@Nullable Entry<V> entry) {
            this.hashNext = entry;
        }

        @Override
        public V setValue(V newValue) {
            V result2 = this.getValue();
            this.setValue(newValue);
            return result2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010'\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\nH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0014"}, d2={"Llibraries/collections/LongHashMap$HashIterator;", "Llibraries/collections/AbstractHashMap$HashMapIterator;", "Llibraries/collections/AbstractHashMap;", "", "(Llibraries/collections/LongHashMap;)V", "e", "Llibraries/collections/LongHashMap$Entry;", "index", "", "last", "", "table", "", "[Llibraries/collections/LongHashMap$Entry;", "hasNext", "", "initNextEntry", "", "nextEntry", "remove", "libraries-collections"})
    private final class HashIterator
    extends AbstractHashMap.HashMapIterator {
        @NotNull
        private final Entry<V>[] table;
        private int index;
        @Nullable
        private Entry<V> e;
        @Nullable
        private Map.Entry<Long, V> last;

        public HashIterator() {
            Intrinsics.checkNotNullParameter((Object)((Object)LongHashMap.this), (String)"this$0");
            this.table = LongHashMap.this.table;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            Map.Entry entry = this.last;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (entry == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            LongHashMap.this.remove(entry.getKey());
            this.last = null;
        }

        @NotNull
        public Map.Entry<Long, V> nextEntry() {
            this.last = this.e;
            Map.Entry entry = this.last;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (entry == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            Map.Entry result2 = entry;
            this.initNextEntry();
            return result2;
        }

        private final void initNextEntry() {
            Entry result2 = this.e;
            if (result2 != null) {
                result2 = result2.getHashNext();
            }
            Entry<V>[] table = this.table;
            while (result2 == null && this.index < table.length) {
                HashIterator hashIterator = this;
                int n = hashIterator.index;
                hashIterator.index = n + 1;
                result2 = table[n];
            }
            this.e = result2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Llibraries/collections/LongHashMap$Companion;", "", "()V", "hack", "", "Llibraries/collections/LongHashMap$Entry;", "[Llibraries/collections/LongHashMap$Entry;", "libraries-collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

