/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.channels;

import io.ktor.utils.io.core.CloseableJVMKt;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.utils.io.nio.InputKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import libraries.io.channels.ByteArrayReadableChannel;
import libraries.io.channels.ByteBufferPoolKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0002*\u00020\u000e\u00a8\u0006\u0010"}, d2={"copyTo", "", "Ljava/nio/channels/ReadableByteChannel;", "channel", "Ljava/nio/channels/WritableByteChannel;", "limit", "pool", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "readToEnd", "", "readUTF8Line", "", "toByteArray", "", "toChannel", "libraries-io"})
public final class ChannelUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final long copyTo(@NotNull ReadableByteChannel $this$copyTo, @NotNull WritableByteChannel channel, long limit, @NotNull ObjectPool<ByteBuffer> pool) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        var5_4 = limit >= 0L;
        var6_6 = false;
        var7_8 = false;
        if (!var5_4) {
            $i$a$-require-ChannelUtilsKt$copyTo$1 = false;
            var7_9 = Intrinsics.stringPlus((String)"Limit shouldn't be negative: ", (Object)limit);
            throw (Throwable)new IllegalArgumentException(var7_9.toString());
        }
        if (channel instanceof FileChannel) {
            return ((FileChannel)channel).transferFrom($this$copyTo, ((FileChannel)channel).position(), limit);
        }
        buffer = (ByteBuffer)pool.borrow();
        position = 0L;
        try {
            block3: while (true) {
                buffer.clear();
                readCount = $this$copyTo.read(buffer);
                if (readCount < 0) {
                    break;
                }
                if (readCount == 0) continue;
                buffer.flip();
                while (true) {
                    if (buffer.hasRemaining()) ** break;
                    continue block3;
                    position += (long)channel.write(buffer);
                }
                break;
            }
        }
        finally {
            pool.recycle((Object)buffer);
        }
        return position;
    }

    public static /* synthetic */ long copyTo$default(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, long l, ObjectPool objectPool, int n, Object object) {
        if ((n & 2) != 0) {
            l = Long.MAX_VALUE;
        }
        if ((n & 4) != 0) {
            objectPool = ByteBufferPoolKt.getIoByteBufferPool();
        }
        return ChannelUtilsKt.copyTo(readableByteChannel, writableByteChannel, l, objectPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] toByteArray(@NotNull ReadableByteChannel $this$toByteArray) {
        byte[] byArray;
        block8: {
            byte[] byArray2;
            block7: {
                Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
                if (!($this$toByteArray instanceof ByteArrayReadableChannel)) break block7;
                byArray = ((ByteArrayReadableChannel)$this$toByteArray).getData();
                break block8;
            }
            Closeable $this$use$iv = (Closeable)InputKt.asInput$default((ReadableByteChannel)$this$toByteArray, null, (int)1, null);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                Input it = (Input)$this$use$iv;
                boolean bl = false;
                byArray2 = StringsKt.readBytes((Input)it);
            }
            catch (Throwable first$iv) {
                try {
                    try {
                        closed$iv = true;
                        $this$use$iv.close();
                    }
                    catch (Throwable second$iv) {
                        CloseableJVMKt.addSuppressedInternal((Throwable)first$iv, (Throwable)second$iv);
                    }
                    throw first$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
            byArray = byArray2;
        }
        return byArray;
    }

    @NotNull
    public static final String readUTF8Line(@NotNull ReadableByteChannel $this$readUTF8Line) {
        Intrinsics.checkNotNullParameter((Object)$this$readUTF8Line, (String)"<this>");
        byte[] bytes$iv = ChannelUtilsKt.toByteArray($this$readUTF8Line);
        int offset$iv = 0;
        int length$iv = bytes$iv.length;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$String = false;
        return new String(bytes$iv, offset$iv, length$iv, charset$iv);
    }

    @NotNull
    public static final ReadableByteChannel toChannel(@NotNull byte[] $this$toChannel) {
        Intrinsics.checkNotNullParameter((Object)$this$toChannel, (String)"<this>");
        return new ByteArrayReadableChannel($this$toChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readToEnd(@NotNull ReadableByteChannel $this$readToEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$readToEnd, (String)"<this>");
        ByteBuffer byteBuffer = (ByteBuffer)ByteBufferPoolKt.getIoByteBufferPool().borrow();
        try {
            int read2;
            do {
                if ((read2 = $this$readToEnd.read(byteBuffer)) <= 0) continue;
                byteBuffer.clear();
            } while (read2 > 0);
        }
        finally {
            ByteBufferPoolKt.getIoByteBufferPool().recycle((Object)byteBuffer);
        }
    }
}

