/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.container.ComponentContainer;
import runtime.container.ConstructorBinding;
import runtime.container.JvmTypeBasedComponentDescriptor;
import runtime.container.ResolveKt;
import runtime.container.ValueResolveContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0012\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lruntime/container/TransientDescriptor;", "Lruntime/container/JvmTypeBasedComponentDescriptor;", "container", "Lruntime/container/ComponentContainer;", "klass", "Ljava/lang/Class;", "(Lruntime/container/ComponentContainer;Ljava/lang/Class;)V", "getContainer", "()Lruntime/container/ComponentContainer;", "getKlass", "()Ljava/lang/Class;", "createInstance", "", "context", "Lruntime/container/ValueResolveContext;", "getRegistrations", "", "getValue", "platform-runtime"})
public final class TransientDescriptor
implements JvmTypeBasedComponentDescriptor {
    @NotNull
    private final ComponentContainer container;
    @NotNull
    private final Class<?> klass;

    public TransientDescriptor(@NotNull ComponentContainer container, @NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.container = container;
        this.klass = klass;
    }

    @NotNull
    public final ComponentContainer getContainer() {
        return this.container;
    }

    @NotNull
    public final Class<?> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.createInstance(this.container.createResolveContext(this));
    }

    @NotNull
    public Iterable<Class<?>> getRegistrations() {
        Class<?>[] classArray = this.klass.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"klass.interfaces");
        return ArraysKt.toList((Object[])ArraysKt.plus((Object[])classArray, this.klass));
    }

    @NotNull
    protected final Object createInstance(@NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConstructorBinding binding = ResolveKt.bindToConstructor(this.klass, context2);
        Constructor<?> constructor = binding.getConstructor();
        List<Object> arguments = ResolveKt.bindArguments(binding.getArgumentDescriptors());
        Collection $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        Object obj = constructor.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNull(obj);
        Object instance = obj;
        return instance;
    }
}

