/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.collaboration.auth.AccountsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "Lcom/intellij/openapi/Disposable;", "()V", "informationCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "dispose", "", "getInformation", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "account", "Companion", "intellij.vcs.github"})
public final class GithubAccountInformationProvider
implements Disposable {
    private final Cache<GithubAccount, GithubAuthenticatedUser> informationCache = Caffeine.newBuilder().expireAfterAccess(Duration.of(30L, ChronoUnit.MINUTES)).build();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @RequiresBackgroundThread
    @NotNull
    public final GithubAuthenticatedUser getInformation(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull GithubAccount account) throws IOException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Object object = this.informationCache.get((Object)account, new Function(executor, indicator, account){
            final /* synthetic */ GithubApiRequestExecutor $executor;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ GithubAccount $account;

            public final GithubAuthenticatedUser apply(GithubAccount it) {
                return this.$executor.execute(this.$indicator, GithubApiRequests.CurrentUser.get(this.$account.getServer()));
            }
            {
                this.$executor = githubApiRequestExecutor;
                this.$indicator = progressIndicator;
                this.$account = githubAccount;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"informationCache.get(acc\u2026er.get(account.server)) }");
        return (GithubAuthenticatedUser)object;
    }

    public void dispose() {
        this.informationCache.invalidateAll();
    }

    public GithubAccountInformationProvider() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        ((GHAccountManager)((Object)object)).addListener(this, (AccountsListener)new AccountsListener<GithubAccount>(){

            public void onAccountListChanged(@NotNull Collection<GithubAccount> old, @NotNull Collection<GithubAccount> collection) {
                Intrinsics.checkNotNullParameter(old, (String)"old");
                Intrinsics.checkNotNullParameter(collection, (String)"new");
                Cache cache = Companion.getInstance().informationCache;
                for (GithubAccount account : CollectionsKt.minus((Iterable)old, (Iterable)collection)) {
                    cache.invalidate((Object)account);
                }
            }

            public void onAccountCredentialsChanged(@NotNull GithubAccount account) {
                Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                Companion.getInstance().informationCache.invalidate((Object)account);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final GithubAccountInformationProvider getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAccountInformationProvider getInstance() {
            boolean $i$f$service = false;
            Class<GithubAccountInformationProvider> serviceClass$iv = GithubAccountInformationProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (GithubAccountInformationProvider)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

