/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import com.intellij.UtilBundle;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.CollaborationToolsIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.ui.util.GHUIUtil$WhenMappings;
import org.jetbrains.plugins.github.util.CollectionDelta;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002;<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007J(\u0010(\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020+2\b\b\u0002\u0010-\u001a\u00020&H\u0007J\u0016\u0010.\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u0016\u00100\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002JZ\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H40302\"\u0004\b\u0000\u001042\b\b\u0001\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u00102\f\u00107\u001a\b\u0012\u0004\u0012\u0002H4082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H40*2\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H40*02R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil;", "", "()V", "AVATAR_SIZE", "", "createIssueLabelLabel", "Lcom/intellij/ui/components/JBLabel;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "createNoteWithAction", "Lcom/intellij/ui/SimpleColoredComponent;", "action", "Lkotlin/Function0;", "", "focusPanel", "panel", "Ljavax/swing/JComponent;", "formatActionDate", "", "date", "Ljava/util/Date;", "getFontEM", "", "component", "getIssueStateIcon", "Ljavax/swing/Icon;", "state", "Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "getIssueStateText", "getLabelBackground", "Lcom/intellij/ui/JBColor;", "getLabelForeground", "Ljava/awt/Color;", "bg", "getPRTimelineWidth", "getPullRequestStateIcon", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "isDraft", "", "getPullRequestStateText", "getRepositoryDisplayName", "allRepositories", "", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "repository", "alwaysShowOwner", "needToShowRepositoryOwner", "repos", "needToShowRepositoryServer", "showChooserPopup", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/util/CollectionDelta;", "T", "popupTitle", "parentComponent", "cellRenderer", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "currentList", "availableListFuture", "SelectableWrapper", "SelectionListCellRenderer", "intellij.vcs.github"})
public final class GHUIUtil {
    public static final int AVATAR_SIZE = 20;
    @NotNull
    public static final GHUIUtil INSTANCE;

    @NotNull
    public final Icon getPullRequestStateIcon(@NotNull GHPullRequestState state2, boolean isDraft) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            Icon icon2 = GithubIcons.PullRequestDraft;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GithubIcons.PullRequestDraft");
        } else {
            Icon icon3;
            switch (GHUIUtil$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1: {
                    icon3 = CollaborationToolsIcons.PullRequestClosed;
                    break;
                }
                case 2: {
                    icon3 = GithubIcons.PullRequestMerged;
                    break;
                }
                case 3: {
                    icon3 = CollaborationToolsIcons.PullRequestOpen;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"when (state) {\n      GHP\u2026ons.PullRequestOpen\n    }");
        }
        return icon;
    }

    @NlsSafe
    @NotNull
    public final String getPullRequestStateText(@NotNull GHPullRequestState state2, boolean isDraft) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            String string2 = GithubBundle.message("pull.request.state.draft", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GithubBundle.message(\"pull.request.state.draft\")");
        } else {
            String string3;
            switch (GHUIUtil$WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
                case 1: {
                    string3 = GithubBundle.message("pull.request.state.closed", new Object[0]);
                    break;
                }
                case 2: {
                    string3 = GithubBundle.message("pull.request.state.merged", new Object[0]);
                    break;
                }
                case 3: {
                    string3 = GithubBundle.message("pull.request.state.open", new Object[0]);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when (state) {\n      GHP\u2026equest.state.open\")\n    }");
        }
        return string;
    }

    @NotNull
    public final Icon getIssueStateIcon(@NotNull GithubIssueState state2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (GHUIUtil$WhenMappings.$EnumSwitchMapping$2[state2.ordinal()]) {
            case 1: {
                Icon icon2 = GithubIcons.IssueOpened;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GithubIcons.IssueOpened");
                break;
            }
            case 2: {
                Icon icon3 = GithubIcons.IssueClosed;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"GithubIcons.IssueClosed");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NlsSafe
    @NotNull
    public final String getIssueStateText(@NotNull GithubIssueState state2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (GHUIUtil$WhenMappings.$EnumSwitchMapping$3[state2.ordinal()]) {
            case 1: {
                String string2 = GithubBundle.message("issue.state.open", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GithubBundle.message(\"issue.state.open\")");
                break;
            }
            case 2: {
                String string3 = GithubBundle.message("issue.state.closed", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GithubBundle.message(\"issue.state.closed\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final void focusPanel(@NotNull JComponent panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)panel2);
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.findInstanceByComponent(panel)");
        IdeFocusManager focusManager = ideFocusManager;
        JComponent jComponent = focusManager.getFocusTargetFor(panel2);
        if (jComponent == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"focusManager.getFocusTargetFor(panel) ?: return");
        JComponent toFocus = jComponent;
        focusManager.doWhenFocusSettlesDown(new Runnable(focusManager, toFocus){
            final /* synthetic */ IdeFocusManager $focusManager;
            final /* synthetic */ JComponent $toFocus;

            public final void run() {
                this.$focusManager.requestFocus((Component)this.$toFocus, true);
            }
            {
                this.$focusManager = ideFocusManager;
                this.$toFocus = jComponent;
            }
        });
    }

    @NotNull
    public final JBLabel createIssueLabelLabel(@NotNull GHLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        JBLabel jBLabel = new JBLabel(' ' + label2.getName() + ' ', UIUtil.ComponentStyle.SMALL);
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = jBLabel;
        boolean bl3 = false;
        $this$apply.setBackground((Color)INSTANCE.getLabelBackground(label2));
        Color color = $this$apply.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
        $this$apply.setForeground(INSTANCE.getLabelForeground(color));
        JBLabel jBLabel2 = jBLabel.andOpaque();
        Intrinsics.checkNotNullExpressionValue((Object)jBLabel2, (String)"JBLabel(\" ${label.name} \u2026ckground)\n  }.andOpaque()");
        return jBLabel2;
    }

    @NotNull
    public final JBColor getLabelBackground(@NotNull GHLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Color color = ColorUtil.fromHex((String)label2.getColor());
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ColorUtil.fromHex(label.color)");
        Color apiColor = color;
        return new JBColor(apiColor, ColorUtil.darker((Color)apiColor, (int)3));
    }

    @NotNull
    public final Color getLabelForeground(@NotNull Color bg) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)bg, (String)"bg");
        if (ColorUtil.isDark((Color)bg)) {
            Color color2 = Color.white;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"Color.white");
        } else {
            Color color3 = Color.black;
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"Color.black");
        }
        return color;
    }

    public final float getFontEM(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        FontMetrics metrics = component2.getFontMetrics(component2.getFont());
        return FontLayoutService.getInstance().charWidth2D(metrics, 8212);
    }

    @NotNull
    public final String formatActionDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = DateFormatUtil.formatPrettyDate((Date)date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DateFormatUtil.formatPrettyDate(date)");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String prettyDate = string4;
        String datePrefix = StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.today", (Object[])new Object[0]), (boolean)true) || StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.yesterday", (Object[])new Object[0]), (boolean)true) ? "" : "on ";
        return datePrefix + prettyDate;
    }

    @NotNull
    public final SimpleColoredComponent createNoteWithAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
        boolean bl = false;
        boolean bl2 = false;
        SimpleColoredComponent $this$apply = simpleColoredComponent;
        boolean bl3 = false;
        $this$apply.setFocusable(true);
        $this$apply.setOpaque(false);
        LinkMouseListenerBase.installSingleTagOn((SimpleColoredComponent)$this$apply);
        $this$apply.registerKeyboardAction(new ActionListener(action2){
            final /* synthetic */ Function0 $action$inlined;
            {
                this.$action$inlined = function0;
            }

            public final void actionPerformed(ActionEvent it) {
                this.$action$inlined.invoke();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        return simpleColoredComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> CompletableFuture<CollectionDelta<T>> showChooserPopup(@NlsContexts.PopupTitle @NotNull String popupTitle, @NotNull JComponent parentComponent, @NotNull SelectionListCellRenderer<T> cellRenderer, @NotNull List<? extends T> currentList, @NotNull CompletableFuture<List<T>> availableListFuture) {
        Collection<SelectableWrapper<void>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)popupTitle, (String)"popupTitle");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter(cellRenderer, (String)"cellRenderer");
        Intrinsics.checkNotNullParameter(currentList, (String)"currentList");
        Intrinsics.checkNotNullParameter(availableListFuture, (String)"availableListFuture");
        CollectionListModel listModel = new CollectionListModel((Object[])new SelectableWrapper[0]);
        JBList jBList = new JBList((ListModel)listModel);
        boolean bl = false;
        boolean bl2 = false;
        JBList $this$apply22 = jBList;
        boolean bl3 = false;
        $this$apply22.setVisibleRowCount(7);
        $this$apply22.setFocusable(false);
        $this$apply22.setSelectionMode(0);
        JBList list2 = jBList;
        list2.setCellRenderer((ListCellRenderer)cellRenderer);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)list2), (boolean)true);
        bl2 = false;
        boolean $this$apply22 = false;
        JScrollPane $this$apply32 = jScrollPane;
        boolean bl4 = false;
        JViewport jViewport = $this$apply32.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"viewport");
        jViewport.setCursor(Cursor.getPredefinedCursor(12));
        $this$apply32.setFocusable(false);
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"ScrollPaneFactory.create\u2026isFocusable = false\n    }");
        JScrollPane scrollPane = jScrollPane2;
        SearchTextField searchTextField = new SearchTextField(false);
        $this$apply22 = false;
        boolean $this$apply32 = false;
        Object $this$apply = searchTextField;
        boolean bl5 = false;
        $this$apply.setBorder(IdeBorderFactory.createBorder((int)8));
        UIUtil.setBackgroundRecursively((Component)((Component)$this$apply), (Color)UIUtil.getListBackground());
        JBTextField jBTextField = $this$apply.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"textEditor");
        jBTextField.setBorder((Border)JBUI.Borders.empty());
        SearchTextField searchField2 = searchTextField;
        CollaborationToolsUIUtil.INSTANCE.attachSearch((JList)list2, searchField2, new Function1<SelectableWrapper<T>, String>(cellRenderer){
            final /* synthetic */ SelectionListCellRenderer $cellRenderer;

            @NotNull
            public final String invoke(SelectableWrapper<T> it) {
                return this.$cellRenderer.getText(it.getValue());
            }
            {
                this.$cellRenderer = selectionListCellRenderer;
                super(1);
            }
        });
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)scrollPane).addToTop((Component)searchField2.getTextEditor());
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026p(searchField.textEditor)");
        BorderLayoutPanel panel2 = borderLayoutPanel;
        ListUtil.installAutoSelectOnMouseMove((JList)((JList)list2));
        Function0<Unit> $fun$toggleSelection$2 = new Function0<Unit>(list2){
            final /* synthetic */ JBList $list;

            public final void invoke() {
                Iterator<E> iterator = this.$list.getSelectedValuesList().iterator();
                while (iterator.hasNext()) {
                    SelectableWrapper item2;
                    item2.setSelected(!(item2 = (SelectableWrapper)iterator.next()).getSelected());
                }
                this.$list.repaint();
            }
            {
                this.$list = jBList;
                super(0);
            }
        };
        list2.addMouseListener((MouseListener)new MouseAdapter($fun$toggleSelection$2){
            final /* synthetic */ showChooserPopup.2 $toggleSelection$2;

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    this.$toggleSelection$2.invoke();
                }
            }
            {
                this.$toggleSelection$2 = $captured_local_variable$0;
            }
        });
        Set originalSelection = CollectionsKt.toHashSet((Iterable)currentList);
        $this$apply = currentList;
        CollectionListModel collectionListModel = listModel;
        boolean $i$f$map = false;
        void var15_24 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl6 = false;
            SelectableWrapper<void> selectableWrapper = new SelectableWrapper<void>(it, true);
            collection.add(selectableWrapper);
        }
        collection = (List)destination$iv$iv;
        collectionListModel.add((List)collection);
        CompletableFuture<CollectionDelta<T>> result = new CompletableFuture<CollectionDelta<T>>();
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)searchField2).setRequestFocus(true).setCancelOnClickOutside(true).setTitle(popupTitle).setResizable(true).setMovable(true).setKeyboardActions(CollectionsKt.listOf((Object)Pair.create((Object)new ActionListener($fun$toggleSelection$2){
            final /* synthetic */ showChooserPopup.2 $toggleSelection$2;

            public final void actionPerformed(ActionEvent it) {
                this.$toggleSelection$2.invoke();
            }
            {
                this.$toggleSelection$2 = var1_1;
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)))).addListener(new JBPopupListener(list2, availableListFuture, originalSelection, cellRenderer, listModel, result){
            final /* synthetic */ JBList $list;
            final /* synthetic */ CompletableFuture $availableListFuture;
            final /* synthetic */ Set $originalSelection;
            final /* synthetic */ SelectionListCellRenderer $cellRenderer;
            final /* synthetic */ CollectionListModel $listModel;
            final /* synthetic */ CompletableFuture $result;

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$list.setPaintBusy(true);
                StatusText statusText = this.$list.getEmptyText();
                Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"list.emptyText");
                statusText.setText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
                CompletionStage completionStage = this.$availableListFuture.thenApplyAsync(new Function(this){
                    final /* synthetic */ showChooserPopup.6 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final List<SelectableWrapper<T>> apply(List<? extends T> available) {
                        void $this$mapTo$iv$iv;
                        List<? extends T> list2 = available;
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"available");
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            SelectableWrapper<void> selectableWrapper = new SelectableWrapper<void>(it, this.this$0.$originalSelection.contains(it));
                            collection.add(selectableWrapper);
                        }
                        Iterable iterable2 = (List)destination$iv$iv;
                        Comparator<T> comparator = Comparator.comparing(showChooserPopup.beforeShown.2.INSTANCE).thenComparing(new Function(this){
                            final /* synthetic */ showChooserPopup.beforeShown.1 this$0;

                            public final String apply(SelectableWrapper<T> it) {
                                return this.this$0.this$0.$cellRenderer.getText(it.getValue());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, showChooserPopup.beforeShown.4.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue(comparator, (String)"Comparator.comparing<Sel\u2026til.compare(a, b, true) }");
                        return CollectionsKt.sortedWith((Iterable)iterable2, comparator);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"availableListFuture\n    \u2026b, true) })\n            }");
                CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)completionStage, null, (Function1)((Function1)new Function1<List<? extends SelectableWrapper<T>>, Unit>(this, event){
                    final /* synthetic */ showChooserPopup.6 this$0;
                    final /* synthetic */ LightweightWindowEvent $event;

                    public final void invoke(List<SelectableWrapper<T>> it) {
                        this.this$0.$listModel.replaceAll(it);
                        this.this$0.$list.setPaintBusy(false);
                        StatusText statusText = this.this$0.$list.getEmptyText();
                        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"list.emptyText");
                        statusText.setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
                        this.$event.asPopup().pack(true, true);
                        if (this.this$0.$list.getSelectedIndex() == -1) {
                            this.this$0.$list.setSelectedIndex(0);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$event = lightweightWindowEvent;
                        super(1);
                    }
                }), (int)1, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onClosed(@NotNull LightweightWindowEvent event) {
                void $this$mapTo$iv$iv;
                SelectableWrapper it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List list2 = this.$listModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"listModel.items");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SelectableWrapper)element$iv$iv;
                    boolean bl = false;
                    if (!it.getSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SelectableWrapper)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    T t = it.getValue();
                    collection.add(t);
                }
                List selected = (List)destination$iv$iv;
                this.$result.complete(new CollectionDelta<T>(this.$originalSelection, selected));
            }
            {
                this.$list = $captured_local_variable$0;
                this.$availableListFuture = $captured_local_variable$1;
                this.$originalSelection = $captured_local_variable$2;
                this.$cellRenderer = $captured_local_variable$3;
                this.$listModel = $captured_local_variable$4;
                this.$result = $captured_local_variable$5;
            }
        }).createPopup().showUnderneathOf((Component)parentComponent);
        return result;
    }

    public final int getPRTimelineWidth() {
        return (int)(this.getFontEM(new JLabel()) * (float)42);
    }

    @NlsSafe
    @NotNull
    public final String getRepositoryDisplayName(@NotNull List<GHRepositoryCoordinates> allRepositories, @NotNull GHRepositoryCoordinates repository, boolean alwaysShowOwner) {
        Intrinsics.checkNotNullParameter(allRepositories, (String)"allRepositories");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        boolean showServer = this.needToShowRepositoryServer(allRepositories);
        boolean showOwner = showServer || alwaysShowOwner ? true : this.needToShowRepositoryOwner(allRepositories);
        StringBuilder builder = new StringBuilder();
        if (showServer) {
            builder.append(repository.getServerPath().toUrl(false)).append("/");
        }
        if (showOwner) {
            builder.append(repository.getRepositoryPath().getOwner()).append("/");
        }
        builder.append(repository.getRepositoryPath().getRepository());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public static /* synthetic */ String getRepositoryDisplayName$default(GHUIUtil gHUIUtil, List list2, GHRepositoryCoordinates gHRepositoryCoordinates, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return gHUIUtil.getRepositoryDisplayName(list2, gHRepositoryCoordinates, bl);
    }

    private final boolean needToShowRepositoryOwner(List<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            String firstOwner = ((GHRepositoryCoordinates)CollectionsKt.first(repos)).getRepositoryPath().getOwner();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getRepositoryPath().getOwner(), (Object)firstOwner) ^ true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean needToShowRepositoryServer(List<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            GithubServerPath firstServer = ((GHRepositoryCoordinates)CollectionsKt.first(repos)).getServerPath();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getServerPath(), (Object)firstServer) ^ true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private GHUIUtil() {
    }

    static {
        GHUIUtil gHUIUtil;
        INSTANCE = gHUIUtil = new GHUIUtil();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectableWrapper;", "T", "", "value", "selected", "", "(Ljava/lang/Object;Z)V", "getSelected", "()Z", "setSelected", "(Z)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Z)Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectableWrapper;", "equals", "other", "hashCode", "", "toString", "", "intellij.vcs.github"})
    public static final class SelectableWrapper<T> {
        private final T value;
        private boolean selected;

        public final T getValue() {
            return this.value;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean bl) {
            this.selected = bl;
        }

        public SelectableWrapper(T value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public /* synthetic */ SelectableWrapper(Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(object, bl);
        }

        public final T component1() {
            return this.value;
        }

        public final boolean component2() {
            return this.selected;
        }

        @NotNull
        public final SelectableWrapper<T> copy(T value, boolean selected) {
            return new SelectableWrapper<T>(value, selected);
        }

        public static /* synthetic */ SelectableWrapper copy$default(SelectableWrapper selectableWrapper, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = selectableWrapper.value;
            }
            if ((n & 2) != 0) {
                bl = selectableWrapper.selected;
            }
            return selectableWrapper.copy(object, bl);
        }

        @NotNull
        public String toString() {
            return "SelectableWrapper(value=" + this.value + ", selected=" + this.selected + ")";
        }

        public int hashCode() {
            T t = this.value;
            int n = (t != null ? t.hashCode() : 0) * 31;
            int n2 = this.selected ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SelectableWrapper)) break block3;
                    SelectableWrapper selectableWrapper = (SelectableWrapper)object;
                    if (!Intrinsics.areEqual(this.value, selectableWrapper.value) || this.selected != selectableWrapper.selected) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u00020\u0004:\u0003\u0019\u001a\u001bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJD\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "T", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectableWrapper;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "()V", "checkIconLabel", "Ljavax/swing/JLabel;", "mainLabel", "getIcon", "Ljavax/swing/Icon;", "value", "(Ljava/lang/Object;)Ljavax/swing/Icon;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "index", "", "isSelected", "", "cellHasFocus", "getText", "", "(Ljava/lang/Object;)Ljava/lang/String;", "Labels", "PRReviewers", "Users", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Users;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Labels;", "intellij.vcs.github"})
    public static abstract class SelectionListCellRenderer<T>
    extends BorderLayoutPanel
    implements ListCellRenderer<SelectableWrapper<T>> {
        private final JLabel mainLabel = new JLabel();
        private final JLabel checkIconLabel = new JLabel();

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends SelectableWrapper<T>> list2, @NotNull SelectableWrapper<T> value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
            this.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.mainLabel.setForeground(this.getForeground());
            this.mainLabel.setFont(this.getFont());
            this.mainLabel.setText(this.getText(value.getValue()));
            this.mainLabel.setIcon(this.getIcon(value.getValue()));
            Icon icon = LafIconLookup.getIcon$default((String)"checkmark", (boolean)isSelected, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)56, null);
            this.checkIconLabel.setIcon(value.getSelected() ? icon : (Icon)EmptyIcon.create((Icon)icon));
            return (Component)((Object)this);
        }

        @NlsContexts.Label
        @NotNull
        public abstract String getText(T var1);

        @NotNull
        public abstract Icon getIcon(T var1);

        private SelectionListCellRenderer() {
            this.checkIconLabel.setIconTextGap(JBUI.scale((int)4));
            this.checkIconLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            this.addToLeft(this.checkIconLabel);
            this.addToCenter(this.mainLabel);
            this.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        }

        public /* synthetic */ SelectionListCellRenderer(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "iconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class PRReviewers
        extends SelectionListCellRenderer<GHPullRequestRequestedReviewer> {
            private final GHAvatarIconsProvider iconsProvider;

            @Override
            @NotNull
            public String getText(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getShortName();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.iconsProvider.getIcon(value.getAvatarUrl());
            }

            public PRReviewers(@NotNull GHAvatarIconsProvider iconsProvider) {
                Intrinsics.checkNotNullParameter((Object)((Object)iconsProvider), (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Users;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "iconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class Users
        extends SelectionListCellRenderer<GHUser> {
            private final GHAvatarIconsProvider iconsProvider;

            @Override
            @NotNull
            public String getText(@NotNull GHUser value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getLogin();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHUser value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.iconsProvider.getIcon(value.getAvatarUrl());
            }

            public Users(@NotNull GHAvatarIconsProvider iconsProvider) {
                Intrinsics.checkNotNullParameter((Object)((Object)iconsProvider), (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Labels;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "()V", "getIcon", "Lcom/intellij/util/ui/ColorIcon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class Labels
        extends SelectionListCellRenderer<GHLabel> {
            @Override
            @NotNull
            public String getText(@NotNull GHLabel value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getName();
            }

            @NotNull
            public ColorIcon getIcon(@NotNull GHLabel value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new ColorIcon(16, ColorUtil.fromHex((String)value.getColor()));
            }

            public Labels() {
                super(null);
            }
        }
    }
}

