/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ParametersList
implements Cloneable {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(\\S+?)(?:=(.+))?");
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    private final List<CompositeParameterTargetedValue> myParameters = new ArrayList<CompositeParameterTargetedValue>();
    private final List<ParamsGroup> myGroups = new SmartList<ParamsGroup>();
    private final NotNullLazyValue<Map<String, String>> myMacroMap = NotNullLazyValue.createValue(ParametersList::computeMacroMap);
    private static Map<String, String> ourTestMacros;

    public boolean hasParameter(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(0);
        }
        return ContainerUtil.lastIndexOf(this.myParameters, value -> parameter.equals(value.getLocalValue())) != -1;
    }

    public boolean hasProperty(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(1);
        }
        return this.getPropertyValue(propertyName) != null;
    }

    @Nullable
    public String getPropertyValue(@NotNull @NonNls String propertyName) {
        String prefix;
        String exact;
        int index;
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(2);
        }
        if ((index = this.indexOfLocalParameter(arg_0 -> ParametersList.lambda$getPropertyValue$1(exact = "-D" + propertyName, prefix = "-D" + propertyName + "=", arg_0))) < 0) {
            return null;
        }
        String str = this.myParameters.get(index).getLocalValue();
        return str.length() == exact.length() ? "" : str.substring(prefix.length());
    }

    @NotNull
    public Map<String, String> getProperties() {
        Map<String, String> map2 = this.getProperties("");
        if (map2 == null) {
            ParametersList.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    public Map<String, String> getProperties(@NonNls String valueIfMissing) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        JBIterable<Matcher> matchers = JBIterable.from(this.myParameters).map(CompositeParameterTargetedValue::getLocalValue).map(PROPERTY_PATTERN::matcher).filter(Matcher::matches);
        for (Matcher matcher : matchers) {
            result.put(matcher.group(1), StringUtil.notNullize(matcher.group(2), valueIfMissing));
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            ParametersList.$$$reportNull$$$0(4);
        }
        return linkedHashMap;
    }

    @NotNull
    public String getParametersString() {
        return ParametersList.join(this.getList());
    }

    public String @NotNull [] getArray() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.getList());
        if (stringArray == null) {
            ParametersList.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public List<String> getList() {
        if (this.myGroups.isEmpty()) {
            List<String> list = Collections.unmodifiableList(this.getLocalParameters());
            if (list == null) {
                ParametersList.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<String> params = new ArrayList<String>(this.getLocalParameters());
        for (ParamsGroup group : this.myGroups) {
            params.addAll(group.getParameters());
        }
        List<String> list = Collections.unmodifiableList(params);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<CompositeParameterTargetedValue> getTargetedList() {
        if (this.myGroups.isEmpty()) {
            List<CompositeParameterTargetedValue> list = Collections.unmodifiableList(this.myParameters);
            if (list == null) {
                ParametersList.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<CompositeParameterTargetedValue> params = new ArrayList<CompositeParameterTargetedValue>(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            params.addAll(CompositeParameterTargetedValue.targetizeParameters(group.getParameters()));
        }
        List<CompositeParameterTargetedValue> list = Collections.unmodifiableList(params);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private List<String> getLocalParameters() {
        List<String> list = ContainerUtil.map(this.myParameters, CompositeParameterTargetedValue::getLocalValue);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private CompositeParameterTargetedValue createExpandedLocalValue(String param) {
        return new CompositeParameterTargetedValue(this.expandMacros(param));
    }

    public void clearAll() {
        this.myParameters.clear();
        this.myGroups.clear();
    }

    public void prepend(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(11);
        }
        this.addAt(0, parameter);
    }

    public void prepend(@Nullable CompositeParameterTargetedValue parameterTargetedValue) {
        this.myParameters.add(0, parameterTargetedValue);
    }

    public void prependAll(String ... parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(12);
        }
        this.addAll(parameter);
        Collections.rotate(this.myParameters, parameter.length);
    }

    public void addParametersString(@Nullable @NonNls String parameters) {
        if (StringUtil.isEmptyOrSpaces(parameters)) {
            return;
        }
        for (String param : ParametersList.parse(parameters)) {
            this.add(param);
        }
    }

    public void add(@Nullable @NonNls String parameter) {
        if (parameter == null) {
            return;
        }
        this.myParameters.add(this.createExpandedLocalValue(parameter));
    }

    public void add(@Nullable CompositeParameterTargetedValue parameterTargetedValue) {
        if (parameterTargetedValue == null) {
            return;
        }
        this.myParameters.add(parameterTargetedValue);
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull @NonNls String groupId) {
        if (groupId == null) {
            ParametersList.$$$reportNull$$$0(13);
        }
        ParamsGroup paramsGroup = this.addParamsGroup(new ParamsGroup(groupId));
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(14);
        }
        return paramsGroup;
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull ParamsGroup group) {
        if (group == null) {
            ParametersList.$$$reportNull$$$0(15);
        }
        this.myGroups.add(group);
        ParamsGroup paramsGroup = group;
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(16);
        }
        return paramsGroup;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index, @NotNull ParamsGroup group) {
        if (group == null) {
            ParametersList.$$$reportNull$$$0(17);
        }
        this.myGroups.add(index, group);
        ParamsGroup paramsGroup = group;
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(18);
        }
        return paramsGroup;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index, @NotNull @NonNls String groupId) {
        if (groupId == null) {
            ParametersList.$$$reportNull$$$0(19);
        }
        ParamsGroup group = new ParamsGroup(groupId);
        this.myGroups.add(index, group);
        ParamsGroup paramsGroup = group;
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(20);
        }
        return paramsGroup;
    }

    public int getParametersCount() {
        return this.myParameters.size();
    }

    public int getParamsGroupsCount() {
        return this.myGroups.size();
    }

    @NotNull
    public List<String> getParameters() {
        List<String> list = Collections.unmodifiableList(this.getLocalParameters());
        if (list == null) {
            ParametersList.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public List<ParamsGroup> getParamsGroups() {
        List<ParamsGroup> list = Collections.unmodifiableList(this.myGroups);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public ParamsGroup getParamsGroupAt(int index) {
        ParamsGroup paramsGroup = this.myGroups.get(index);
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(23);
        }
        return paramsGroup;
    }

    @Nullable
    public ParamsGroup getParamsGroup(@NotNull @NonNls String name) {
        if (name == null) {
            ParametersList.$$$reportNull$$$0(24);
        }
        for (ParamsGroup group : this.myGroups) {
            if (!name.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    @Nullable
    public ParamsGroup removeParamsGroup(int index) {
        return this.myGroups.remove(index);
    }

    public void addAt(int index, @NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(25);
        }
        this.myParameters.add(index, this.createExpandedLocalValue(parameter));
    }

    public void defineSystemProperty(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(26);
        }
        this.defineProperty(propertyName, System.getProperty(propertyName));
    }

    public void defineProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        String prefix;
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(27);
        }
        if (propertyValue == null) {
            return;
        }
        @NlsSafe String exact = "-D" + propertyName;
        int index = this.indexOfLocalParameter(arg_0 -> ParametersList.lambda$defineProperty$2(exact, prefix = "-D" + propertyName + "=", arg_0));
        if (index > -1) {
            return;
        }
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.myParameters.add(new CompositeParameterTargetedValue(value));
    }

    public void addProperty(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(28);
        }
        @NlsSafe String exact = "-D" + propertyName;
        @NlsSafe String prefix = "-D" + propertyName + "=";
        this.replaceOrAddAt(new CompositeParameterTargetedValue(exact), this.myParameters.size(), o -> o.equals(exact) || o.startsWith(prefix));
    }

    public void addProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(29);
        }
        if (propertyValue == null) {
            return;
        }
        @NlsSafe String exact = "-D" + propertyName;
        @NlsSafe String prefix = "-D" + propertyName + "=";
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.replaceOrAddAt(new CompositeParameterTargetedValue(value), this.myParameters.size(), o -> o.equals(exact) || o.startsWith(prefix));
    }

    public void addNotEmptyProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(30);
        }
        if (StringUtil.isEmptyOrSpaces(propertyValue)) {
            return;
        }
        this.addProperty(propertyName, propertyValue);
    }

    public void replaceOrAppend(@NotNull @NonNls String parameterPrefix, @NotNull @NonNls String replacement) {
        if (parameterPrefix == null) {
            ParametersList.$$$reportNull$$$0(31);
        }
        if (replacement == null) {
            ParametersList.$$$reportNull$$$0(32);
        }
        this.replaceOrAddAt(this.createExpandedLocalValue(replacement), this.myParameters.size(), o -> o.startsWith(parameterPrefix));
    }

    public void replaceOrPrepend(@NotNull @NonNls String parameterPrefix, @NotNull @NonNls String replacement) {
        if (parameterPrefix == null) {
            ParametersList.$$$reportNull$$$0(33);
        }
        if (replacement == null) {
            ParametersList.$$$reportNull$$$0(34);
        }
        this.replaceOrAddAt(this.createExpandedLocalValue(replacement), 0, o -> o.startsWith(parameterPrefix));
    }

    private void replaceOrAddAt(@NotNull CompositeParameterTargetedValue replacement, int position, @NotNull Condition<? super String> existingCondition) {
        if (replacement == null) {
            ParametersList.$$$reportNull$$$0(35);
        }
        if (existingCondition == null) {
            ParametersList.$$$reportNull$$$0(36);
        }
        int index = this.indexOfLocalParameter(existingCondition);
        boolean setNewValue = StringUtil.isNotEmpty(replacement.getLocalValue());
        if (index > -1 && setNewValue) {
            this.myParameters.set(index, replacement);
        } else if (index > -1) {
            this.myParameters.remove(index);
        } else if (setNewValue) {
            this.myParameters.add(position, replacement);
        }
    }

    private int indexOfLocalParameter(@NotNull @NonNls Condition<? super String> condition) {
        if (condition == null) {
            ParametersList.$$$reportNull$$$0(37);
        }
        return ContainerUtil.lastIndexOf(this.myParameters, value -> condition.value(value.getLocalValue()));
    }

    public void set(int ind, @NotNull @NonNls String value) {
        if (value == null) {
            ParametersList.$$$reportNull$$$0(38);
        }
        this.myParameters.set(ind, new CompositeParameterTargetedValue(value));
    }

    public String get(int ind) {
        return this.myParameters.get(ind).getLocalValue();
    }

    @Nullable
    public String getLast() {
        return this.myParameters.size() > 0 ? this.myParameters.get(this.myParameters.size() - 1).getLocalValue() : null;
    }

    public void add(@NotNull @NonNls String name, @NotNull @NonNls String value) {
        if (name == null) {
            ParametersList.$$$reportNull$$$0(39);
        }
        if (value == null) {
            ParametersList.$$$reportNull$$$0(40);
        }
        this.myParameters.add(new CompositeParameterTargetedValue(name));
        this.add(value);
    }

    public void addAll(String ... parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(41);
        }
        this.addAll(Arrays.asList(parameters));
    }

    public void addAll(@NotNull @NonNls List<String> parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(42);
        }
        for (String parameter : parameters) {
            this.add(parameter);
        }
    }

    public ParametersList clone() {
        return this.copyTo(new ParametersList());
    }

    @NotNull
    public ParametersList copyTo(@NotNull ParametersList target) {
        if (target == null) {
            ParametersList.$$$reportNull$$$0(43);
        }
        target.myParameters.addAll(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            target.myGroups.add(group.clone());
        }
        ParametersList parametersList = target;
        if (parametersList == null) {
            ParametersList.$$$reportNull$$$0(44);
        }
        return parametersList;
    }

    @NotNull
    public static String join(@NotNull @NonNls List<String> parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(45);
        }
        String string2 = ParametersListUtil.join(parameters);
        if (string2 == null) {
            ParametersList.$$$reportNull$$$0(46);
        }
        return string2;
    }

    @NotNull
    public static String join(String ... parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(47);
        }
        String string2 = ParametersListUtil.join(parameters);
        if (string2 == null) {
            ParametersList.$$$reportNull$$$0(48);
        }
        return string2;
    }

    public static String @NotNull [] parse(@NotNull @NonNls String string2) {
        if (string2 == null) {
            ParametersList.$$$reportNull$$$0(49);
        }
        String[] stringArray = ParametersListUtil.parseToArray(string2);
        if (stringArray == null) {
            ParametersList.$$$reportNull$$$0(50);
        }
        return stringArray;
    }

    @NotNull
    public String expandMacros(@NotNull @NonNls String text) {
        int start;
        if (text == null) {
            ParametersList.$$$reportNull$$$0(51);
        }
        if ((start = text.indexOf("${")) < 0) {
            String string2 = text;
            if (string2 == null) {
                ParametersList.$$$reportNull$$$0(52);
            }
            return string2;
        }
        Map<String, String> macroMap = this.myMacroMap.getValue();
        Matcher matcher = MACRO_PATTERN.matcher(text);
        StringBuilder sb = null;
        while (matcher.find(start)) {
            String value = macroMap.get(matcher.group(1));
            if (value != null) {
                if (sb == null) {
                    sb = new StringBuilder(2 * text.length()).append(text, 0, matcher.start());
                } else {
                    sb.append(text, start, matcher.start());
                }
                sb.append(value);
                start = matcher.end();
                continue;
            }
            if (sb != null) {
                sb.append(text, start, matcher.start() + 2);
            }
            start = matcher.start() + 2;
        }
        String string3 = sb == null ? text : sb.append(text, start, text.length()).toString();
        if (string3 == null) {
            ParametersList.$$$reportNull$$$0(53);
        }
        return string3;
    }

    @TestOnly
    public static void setTestMacros(@Nullable @NonNls Map<String, String> testMacros) {
        ourTestMacros = testMacros;
    }

    @NotNull
    private static Map<String, String> computeMacroMap() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() && ourTestMacros != null) {
            Map<String, String> map2 = ObjectUtils.notNull(ourTestMacros, Collections.emptyMap());
            if (map2 == null) {
                ParametersList.$$$reportNull$$$0(54);
            }
            return map2;
        }
        Map<String, String> map3 = CollectionFactory.createCaseInsensitiveStringMap();
        Map pathMacros = PathMacros.getInstance().getUserMacros();
        if (!pathMacros.isEmpty()) {
            for (String string2 : pathMacros.keySet()) {
                String value = (String)pathMacros.get(string2);
                if (value == null) continue;
                map3.put(string2, value);
            }
        }
        for (Map.Entry entry : EnvironmentUtil.getEnvironmentMap().entrySet()) {
            map3.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
        }
        Map<String, String> map4 = map3;
        if (map4 == null) {
            ParametersList.$$$reportNull$$$0(55);
        }
        return map4;
    }

    @NonNls
    public String toString() {
        return this.myParameters + (String)(this.myGroups.isEmpty() ? "" : " and " + this.myGroups);
    }

    private static /* synthetic */ boolean lambda$defineProperty$2(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }

    private static /* synthetic */ boolean lambda$getPropertyValue$1(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: 
            case 2: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/ParametersList";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 24: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterPrefix";
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingCondition";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 41: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/ParametersList";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetedList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalParameters";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addParamsGroup";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addParamsGroupAt";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsGroups";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsGroupAt";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTo";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "expandMacros";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMacroMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasParameter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prependAll";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addParamsGroup";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addParamsGroupAt";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getParamsGroup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addAt";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "defineSystemProperty";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "defineProperty";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addNotEmptyProperty";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "replaceOrAppend";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "replaceOrPrepend";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "replaceOrAddAt";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "indexOfLocalParameter";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "expandMacros";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

