/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.pty4j.windows.WinPtyProcess;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.winp.WinProcess;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0017Jc\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/execution/process/ProcessServiceImpl;", "Lcom/intellij/execution/process/ProcessService;", "()V", "createWinProcess", "Lorg/jvnet/winp/WinProcess;", "process", "Ljava/lang/Process;", "pid", "", "getCommand", "", "", "hasControllingTerminal", "", "isLocalPtyProcess", "killWinProcess", "", "killWinProcessRecursively", "sendWinProcessCtrlC", "startPtyProcess", "command", "", "directory", "env", "", "options", "Lcom/intellij/execution/process/LocalPtyOptions;", "app", "Lcom/intellij/openapi/application/Application;", "redirectErrorStream", "windowsAnsiColorEnabled", "unixOpenTtyToPreserveOutputAfterTermination", "([Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lcom/intellij/execution/process/LocalPtyOptions;Lcom/intellij/openapi/application/Application;ZZZ)Ljava/lang/Process;", "winPtyChildProcessId", "(Ljava/lang/Process;)Ljava/lang/Integer;", "intellij.platform.ide.util.io.impl"})
public final class ProcessServiceImpl
implements ProcessService {
    @Override
    @NotNull
    public Process startPtyProcess(@NotNull String[] command, @Nullable String directory, @NotNull Map<String, String> env, @NotNull LocalPtyOptions options, @Nullable Application app, boolean redirectErrorStream, boolean windowsAnsiColorEnabled, boolean unixOpenTtyToPreserveOutputAfterTermination) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        PtyProcessBuilder ptyProcessBuilder = new PtyProcessBuilder(command).setEnvironment(env).setDirectory(directory).setInitialColumns(options.getInitialColumns() > 0 ? Integer.valueOf(options.getInitialColumns()) : null).setInitialRows(options.getInitialRows() > 0 ? Integer.valueOf(options.getInitialRows()) : null).setConsole(options.getConsoleMode()).setCygwin(options.getUseCygwinLaunch() && SystemInfo.isWindows).setUseWinConPty(options.getUseWinConPty()).setLogFile(app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null).setRedirectErrorStream(redirectErrorStream).setWindowsAnsiColorEnabled(windowsAnsiColorEnabled).setUnixOpenTtyToPreserveOutputAfterTermination(unixOpenTtyToPreserveOutputAfterTermination);
        Intrinsics.checkNotNullExpressionValue((Object)ptyProcessBuilder, (String)"PtyProcessBuilder(comman\u2026veOutputAfterTermination)");
        PtyProcessBuilder builder = ptyProcessBuilder;
        PtyProcess ptyProcess = builder.start();
        Intrinsics.checkNotNullExpressionValue((Object)ptyProcess, (String)"builder.start()");
        return (Process)ptyProcess;
    }

    @Override
    public boolean sendWinProcessCtrlC(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        boolean r = this.createWinProcess(process2).sendCtrlC();
        try {
            OutputStream outputStream = process2.getOutputStream();
            if (outputStream != null) {
                OutputStream outputStream2 = outputStream;
                boolean bl = false;
                boolean bl2 = false;
                OutputStream $this$apply = outputStream2;
                boolean bl3 = false;
                $this$apply.write(-1);
                $this$apply.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    @Override
    @Deprecated(message="pid is not enough to emulate CTRL+C on Windows, we need a real process with stdin")
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public boolean sendWinProcessCtrlC(int pid) {
        Logger.getInstance(ProcessServiceImpl.class).warn("Deprecated method will be removed");
        return this.createWinProcess(pid).sendCtrlC();
    }

    @Override
    public void killWinProcessRecursively(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        this.createWinProcess(process2).killRecursively();
    }

    @Override
    public boolean isLocalPtyProcess(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        return process2 instanceof PtyProcess;
    }

    @Override
    @Nullable
    public Integer winPtyChildProcessId(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        if (process2 instanceof WinPtyProcess) {
            return (int)process2.pid();
        }
        return null;
    }

    @Override
    public boolean hasControllingTerminal(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        return process2 instanceof PtyProcess && !((PtyProcess)process2).isConsoleMode();
    }

    private final WinProcess createWinProcess(Process process2) {
        return new WinProcess((int)process2.pid());
    }

    private final WinProcess createWinProcess(int pid) {
        return new WinProcess(pid);
    }

    @Override
    public void killWinProcess(int pid) {
        this.createWinProcess(pid).kill();
    }

    @Override
    @NotNull
    public List<String> getCommand(@NotNull Process process2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Process process3 = process2;
        if (process3 instanceof WinConPtyProcess) {
            List list2 = ((WinConPtyProcess)process2).getCommand();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"process.command");
        } else if (process3 instanceof WinPtyProcess) {
            List list3 = ((WinPtyProcess)process2).getCommand();
            list = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"process.command");
        } else {
            Object object;
            try {
                ProcessHandle.Info info = process2.info();
                Intrinsics.checkNotNullExpressionValue((Object)info, (String)"process.info()");
                object = info;
            }
            catch (UnsupportedOperationException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ProcessServiceImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.debug("Cannot find command line for " + process2.getClass(), e);
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            ProcessHandle.Info processInfo = object;
            String string2 = processInfo.command().orElse(null);
            if (string2 != null) {
                object = string2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add(it);
                String[] stringArray = processInfo.arguments().orElse(new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"processInfo.arguments().orElse(emptyArray())");
                spreadBuilder.addSpread((Object)stringArray);
                return CollectionsKt.listOf((Object[])((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])));
            }
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        return list;
    }
}

