/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.Asn1Object;
import com.intellij.execution.rmi.ssl.DerParser;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Base64;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivateKeyReader {
    public static final String P1_BEGIN_MARKER = "-----BEGIN RSA PRIVATE KEY";
    public static final String P1_END_MARKER = "-----END RSA PRIVATE KEY";
    public static final String P8_BEGIN_MARKER = "-----BEGIN PRIVATE KEY";
    public static final String P8_END_MARKER = "-----END PRIVATE KEY";
    public static final String EP8_BEGIN_MARKER = "-----BEGIN ENCRYPTED PRIVATE KEY";
    public static final String EP8_END_MARKER = "-----END ENCRYPTED PRIVATE KEY";
    private static final Map<String, PrivateKey> keyCache = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final String myFileName;
    @NotNull
    private final char[] myPassword;

    public PrivateKeyReader(@NotNull String fileName, @Nullable char[] password) {
        if (fileName == null) {
            PrivateKeyReader.$$$reportNull$$$0(0);
        }
        this.myFileName = fileName;
        this.myPassword = password;
    }

    public PrivateKey getPrivateKey() throws IOException {
        PrivateKey key = keyCache.get(this.myFileName);
        if (key != null) {
            return key;
        }
        key = PrivateKeyReader.read(this.myFileName, this.myPassword);
        keyCache.put(this.myFileName, key);
        return key;
    }

    private static PrivateKey read(String fileName, @Nullable char[] password) throws IOException {
        KeyFactory factory;
        try {
            factory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("JCE error: " + e.getMessage());
        }
        List<String> lines = FileUtilRt.loadLines(fileName, "UTF-8");
        for (int i = 0; i < lines.size(); ++i) {
            KeySpec keySpec = PrivateKeyReader.findRSAKeySpec(lines, i);
            String enc = "PKCS#1";
            if (keySpec == null) {
                keySpec = PrivateKeyReader.findPKCS8EncodedKeySpec(lines, i);
                enc = "PKCS#8";
            }
            if (keySpec == null) {
                keySpec = PrivateKeyReader.findEncryptedKeySpec(lines, i, password);
                enc = "Encrypted key";
            }
            if (keySpec == null) continue;
            try {
                return factory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new IOException("Invalid " + enc + " PEM file: " + e.getMessage());
            }
        }
        throw new IOException("Invalid PEM file: no begin marker");
    }

    @Nullable
    private static EncodedKeySpec findEncryptedKeySpec(List<String> lines, int i, @Nullable char[] password) throws IOException {
        if (!lines.get(i).contains(EP8_BEGIN_MARKER)) {
            return null;
        }
        List<String> strings2 = lines.subList(i + 1, lines.size());
        byte[] keyBytes = PrivateKeyReader.readKeyMaterial(EP8_END_MARKER, strings2);
        EncryptedPrivateKeyInfo encrypted = new EncryptedPrivateKeyInfo(keyBytes);
        PBEKeySpec encryptedKeySpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory pbeKeyFactory = SecretKeyFactory.getInstance(encrypted.getAlgName());
            return encrypted.getKeySpec(pbeKeyFactory.generateSecret(encryptedKeySpec));
        }
        catch (GeneralSecurityException e) {
            throw new IOException("JCE error: " + e.getMessage());
        }
    }

    @Nullable
    private static EncodedKeySpec findPKCS8EncodedKeySpec(List<String> lines, int i) throws IOException {
        if (!lines.get(i).contains(P8_BEGIN_MARKER)) {
            return null;
        }
        List<String> strings2 = lines.subList(i + 1, lines.size());
        byte[] keyBytes = PrivateKeyReader.readKeyMaterial(P8_END_MARKER, strings2);
        return new PKCS8EncodedKeySpec(keyBytes);
    }

    @Nullable
    private static RSAPrivateCrtKeySpec findRSAKeySpec(List<String> lines, int i) throws IOException {
        if (!lines.get(i).contains(P1_BEGIN_MARKER)) {
            return null;
        }
        List<String> strings2 = lines.subList(i + 1, lines.size());
        byte[] keyBytes = PrivateKeyReader.readKeyMaterial(P1_END_MARKER, strings2);
        return PrivateKeyReader.getRSAKeySpec(keyBytes);
    }

    private static byte[] readKeyMaterial(String endMarker, List<String> strings2) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (String line : strings2) {
            if (line.contains(endMarker)) {
                return Base64.decode(buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException("Invalid PEM file: No end marker");
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/execution/rmi/ssl/PrivateKeyReader", "<init>"));
    }
}

