/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import java.awt.image.ImageFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconTransform {
    private static final Logger LOG = Logger.getInstance(IconTransform.class);
    private final boolean dark;
    private final IconPathPatcher @NotNull [] patchers;
    @Nullable
    private final ImageFilter filter;

    public IconTransform(boolean dark, IconPathPatcher @NotNull [] patchers, @Nullable ImageFilter filter2) {
        if (patchers == null) {
            IconTransform.$$$reportNull$$$0(0);
        }
        this.dark = dark;
        this.patchers = patchers;
        this.filter = filter2;
    }

    public boolean isDark() {
        return this.dark;
    }

    @Nullable
    public ImageFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public IconTransform withPathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconTransform.$$$reportNull$$$0(1);
        }
        return new IconTransform(this.dark, ArrayUtil.append(this.patchers, patcher), this.filter);
    }

    @NotNull
    public IconTransform withoutPathPatcher(@NotNull IconPathPatcher patcher) {
        IconPathPatcher[] newPatchers;
        if (patcher == null) {
            IconTransform.$$$reportNull$$$0(2);
        }
        return (newPatchers = ArrayUtil.remove(this.patchers, patcher)) == this.patchers ? this : new IconTransform(this.dark, newPatchers, this.filter);
    }

    @NotNull
    public IconTransform withFilter(ImageFilter filter2) {
        return filter2 == this.filter ? this : new IconTransform(this.dark, this.patchers, filter2);
    }

    @NotNull
    public IconTransform withDark(boolean dark) {
        return dark == this.dark ? this : new IconTransform(dark, this.patchers, this.filter);
    }

    @Nullable
    public Pair<String, ClassLoader> patchPath(@NotNull String path, @Nullable ClassLoader classLoader) {
        if (path == null) {
            IconTransform.$$$reportNull$$$0(3);
        }
        for (IconPathPatcher patcher : this.patchers) {
            Class<?> contextClass;
            String newPath;
            try {
                newPath = patcher.patchPath(path, classLoader);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(patcher + " cannot patch icon path", e);
                continue;
            }
            if (newPath == null) continue;
            LOG.debug("replace '" + path + "' with '" + newPath + "'");
            ClassLoader contextClassLoader = patcher.getContextClassLoader(path, classLoader);
            if (contextClassLoader == null && (contextClass = patcher.getContextClass(path)) != null) {
                contextClassLoader = contextClass.getClassLoader();
            }
            return new Pair<String, ClassLoader>(newPath, contextClassLoader);
        }
        return null;
    }

    @NotNull
    public IconTransform copy() {
        return new IconTransform(this.dark, this.patchers, this.filter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchers";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/icons/IconTransform";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withPathPatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withoutPathPatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "patchPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

