/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.intellij.openapi.util.StaxFactory;
import com.intellij.util.NoOpXmlInterner;
import com.intellij.util.XmlElement;
import com.intellij.util.XmlElementBuilder;
import com.intellij.util.XmlInterner;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0007\u001a\"\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000f"}, d2={"nextTag", "", "reader", "Lorg/codehaus/stax2/XMLStreamReader2;", "readAttributes", "", "", "interner", "Lcom/intellij/util/XmlInterner;", "readXmlAsModel", "Lcom/intellij/util/XmlElement;", "inputStream", "Ljava/io/InputStream;", "", "rootName", "intellij.platform.util.xmlDom"})
@JvmName(name="XmlDomReader")
@ApiStatus.Internal
public final class XmlDomReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        XMLStreamReader2 reader = StaxFactory.createXmlStreamReader(inputStream);
        try {
            int tag = XmlDomReader.nextTag(reader);
            String rootName = tag == 1 ? reader.getLocalName() : null;
            XmlElement xmlElement = XmlDomReader.readXmlAsModel(reader, rootName, NoOpXmlInterner.INSTANCE);
            return xmlElement;
        }
        finally {
            reader.closeCompletely();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull byte[] inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try (XMLStreamReader2 reader = StaxFactory.createXmlStreamReader(inputStream);){
            int tag = XmlDomReader.nextTag(reader);
            String rootName = tag == 1 ? reader.getLocalName() : null;
            XmlElement xmlElement = XmlDomReader.readXmlAsModel(reader, rootName, NoOpXmlInterner.INSTANCE);
            return xmlElement;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull XMLStreamReader2 reader, @Nullable String rootName, @NotNull XmlInterner interner) {
        XmlElementBuilder fragment;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)interner, (String)"interner");
        XmlElementBuilder current = fragment = new XmlElementBuilder(rootName == null ? "" : interner.name(rootName), XmlDomReader.readAttributes(reader, interner));
        ArrayDeque<XmlElementBuilder> stack = new ArrayDeque<XmlElementBuilder>();
        ArrayDeque<XmlElementBuilder> elementPool = new ArrayDeque<XmlElementBuilder>();
        int depth = 1;
        block7: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String string2 = reader.getLocalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reader.localName");
                    String name = interner.name(string2);
                    Map<String, String> attributes = XmlDomReader.readAttributes(reader, interner);
                    if (reader.isEmptyElement()) {
                        ArrayList<XmlElement> arrayList = current.children;
                        List<XmlElement> list = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList()");
                        arrayList.add(new XmlElement(name, attributes, list, null));
                        reader.skipElement();
                        continue block7;
                    }
                    XmlElementBuilder child = (XmlElementBuilder)elementPool.pollLast();
                    if (child == null) {
                        child = new XmlElementBuilder(name, attributes);
                    } else {
                        child.name = name;
                        child.attributes = attributes;
                    }
                    stack.addLast(current);
                    current = child;
                    ++depth;
                    continue block7;
                }
                case 2: {
                    List<XmlElement> children = null;
                    if (current.children.isEmpty()) {
                        List<XmlElement> list = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList()");
                        children = list;
                    } else {
                        XmlElement[] xmlElementArray = current.children.toArray(new XmlElement[current.children.size()]);
                        List<XmlElement> list = Arrays.asList(Arrays.copyOf(xmlElementArray, xmlElementArray.length));
                        Intrinsics.checkNotNullExpressionValue(list, (String)"Arrays.asList(*current.c\u2026(current.children.size)))");
                        children = list;
                        current.children.clear();
                    }
                    XmlElement result = new XmlElement(current.name, current.attributes, children, current.content);
                    current.content = null;
                    elementPool.addLast(current);
                    if (--depth == 0) {
                        return result;
                    }
                    Object e = stack.removeLast();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"stack.removeLast()");
                    current = (XmlElementBuilder)e;
                    current.children.add(result);
                    continue block7;
                }
                case 12: {
                    if (current.content == null) {
                        String string3 = current.name;
                        String string4 = reader.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"reader.text");
                        current.content = interner.value(string3, string4);
                        continue block7;
                    }
                    current.content = Intrinsics.stringPlus((String)current.content, (Object)reader.getText());
                    continue block7;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block7;
                    if (current.content == null) {
                        current.content = reader.getText();
                        continue block7;
                    }
                    current.content = Intrinsics.stringPlus((String)current.content, (Object)reader.getText());
                    continue block7;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    continue block7;
                }
            }
            throw (Throwable)new XMLStreamException("Unexpected XMLStream event " + reader.getEventType(), reader.getLocation());
        }
        throw (Throwable)new XMLStreamException("Unexpected end of input: " + reader.getEventType(), reader.getLocation());
    }

    private static final Map<String, String> readAttributes(XMLStreamReader2 reader, XmlInterner interner) {
        Map<String, String> map2;
        int attributeCount = reader.getAttributeCount();
        switch (attributeCount) {
            case 0: {
                Map<String, String> map3 = Collections.emptyMap();
                map2 = map3;
                Intrinsics.checkNotNullExpressionValue(map3, (String)"Collections.emptyMap()");
                break;
            }
            case 1: {
                String string2 = reader.getAttributeLocalName(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reader.getAttributeLocalName(0)");
                String name = interner.name(string2);
                String string3 = reader.getAttributeValue(0);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"reader.getAttributeValue(0)");
                Map<String, String> map4 = Collections.singletonMap(name, interner.value(name, string3));
                map2 = map4;
                Intrinsics.checkNotNullExpressionValue(map4, (String)"Collections.singletonMap\u2026er.getAttributeValue(0)))");
                break;
            }
            default: {
                Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap(attributeCount);
                for (int i = 0; i < attributeCount; ++i) {
                    String string4 = reader.getAttributeLocalName(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"reader.getAttributeLocalName(i)");
                    String name = interner.name(string4);
                    Map map5 = (Map)result;
                    String string5 = reader.getAttributeValue(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"reader.getAttributeValue(i)");
                    map5.put(name, interner.value(name, string5));
                }
                map2 = (Map<String, String>)result;
            }
        }
        return map2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int nextTag(XMLStreamReader2 reader) {
        int next;
        block5: while (true) {
            next = reader.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (!reader.isWhiteSpace()) throw (Throwable)new WFCException("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().", reader.getLocation());
                    continue block5;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            break;
        }
        throw (Throwable)new WFCException("Received event " + ErrorConsts.tokenTypeDesc((int)next) + ", instead of START_ELEMENT or END_ELEMENT.", reader.getLocation());
    }
}

