/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class MacUIUtil {
    public static final boolean USE_QUARTZ = "true".equals(System.getProperty("apple.awt.graphics.UseQuartz"));
    public static final String MAC_FILL_BORDER = "MAC_FILL_BORDER";
    public static final int MAC_COMBO_BORDER_V_OFFSET = 1;
    private static Cursor INVERTED_TEXT_CURSOR;

    private MacUIUtil() {
    }

    public static void hideCursor() {
        if (SystemInfoRt.isMac && Registry.is("ide.mac.hide.cursor.when.typing", true)) {
            Foundation.executeOnMainThread(false, false, () -> Foundation.invoke("NSCursor", "setHiddenUntilMouseMoves:", true));
        }
    }

    @NotNull
    public static Cursor getInvertedTextCursor() {
        if (INVERTED_TEXT_CURSOR == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image cursorImage = toolkit.getImage(MacUIUtil.class.getClassLoader().getResource("mac/text.png"));
            INVERTED_TEXT_CURSOR = toolkit.createCustomCursor(cursorImage, new Point(15, 13), "InvertedTextCursor");
        }
        Cursor cursor = INVERTED_TEXT_CURSOR;
        if (cursor == null) {
            MacUIUtil.$$$reportNull$$$0(0);
        }
        return cursor;
    }

    public static MouseEvent fixMacContextMenuIssue(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.isControlDown() && e.getID() == 501) {
            int modifiers = e.getModifiers() & 0xFFFFFFED | 4;
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), modifiers, e.getX(), e.getY(), e.getClickCount(), true, 3);
        }
        return e;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MacUIUtil", "getInvertedTextCursor"));
    }
}

