/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.idea.IdeaLogger;
import com.intellij.lang.Language;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.project.TestProjectManagerKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.OpenProjectTaskBuilder;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static LightProjectDescriptor ourProjectDescriptor;
    private static SdkLeakTracker myOldSdks;
    private ThreadTracker myThreadTracker;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private LibraryTableTracker myLibraryTableTracker;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private Disposable mySdkParentDisposable = Disposer.newDisposable((String)"sdk for project in light tests");

    protected Project getProject() {
        return ourProject;
    }

    protected Module getModule() {
        return ourModule;
    }

    @NotNull
    protected PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)this.getProject());
        }
        PsiManager psiManager = ourPsiManager;
        if (psiManager == null) {
            LightPlatformTestCase.$$$reportNull$$$0(0);
        }
        return psiManager;
    }

    public static TestApplicationManager getApplication() {
        return TestApplicationManager.getInstanceIfCreated();
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']%n", MockApplication.INSTANCES_CREATED);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']%n", TestProjectManagerKt.getTotalCreatedProjectsCount());
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']%n", totalGcTime);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']%n", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount());
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            LightPlatformTestCase.$$$reportNull$$$0(1);
        }
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(@NotNull LightProjectDescriptor descriptor) {
        if (descriptor == null) {
            LightPlatformTestCase.$$$reportNull$$$0(2);
        }
        ourProjectDescriptor = descriptor;
        if (ourProject != null) {
            LightPlatformTestCase.closeAndDeleteProject();
        }
        ApplicationManager.getApplication().runWriteAction(LightPlatformTestCase::cleanPersistedVFSContent);
        Path tempDirectory = TemporaryDirectory.generateTemporaryPath("light_temp.ipr");
        ourProject = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().newProject(tempDirectory, new OpenProjectTaskBuilder().build()));
        HeavyPlatformTestCase.synchronizeTempDirVfs(tempDirectory);
        ourPsiManager = null;
        try {
            ourProjectDescriptor.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

                @Override
                public void moduleCreated(@NotNull Module module) {
                    if (module == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ourModule = module;
                }

                @Override
                public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                    if (sourceRoot == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ourSourceRoot = sourceRoot;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "module";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "sourceRoot";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleCreated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "sourceRootCreated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (Throwable e) {
            try {
                LightPlatformTestCase.closeAndDeleteProject();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw new RuntimeException(e);
        }
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        TestApplicationManager testAppManager = TestApplicationManager.getInstance();
        EdtTestUtil.runInEdtAndWait(() -> {
            super.setUp();
            testAppManager.setDataProvider(this);
            LightProjectDescriptor descriptor = this.getProjectDescriptor();
            LightPlatformTestCase.doSetup(descriptor, this.configureLocalInspectionTools(), this.getTestRootDisposable(), this.mySdkParentDisposable);
            InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
            this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(() -> this.isStressTest() || ApplicationManager.getApplication() == null || ApplicationManager.getApplication() instanceof MockApplication ? null : CodeStyle.getDefaultSettings());
            this.myThreadTracker = new ThreadTracker();
            ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
            this.myLibraryTableTracker = new LibraryTableTracker();
        });
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return new SimpleLightProjectDescriptor(this.getModuleTypeId(), this.getProjectJDK());
    }

    @NotNull
    public static Pair.NonNull<Project, Module> doSetup(@NotNull LightProjectDescriptor descriptor, LocalInspectionTool @NotNull [] localInspectionTools, @NotNull Disposable parentDisposable, @NotNull Disposable sdkParentDisposable) {
        if (descriptor == null) {
            LightPlatformTestCase.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            LightPlatformTestCase.$$$reportNull$$$0(4);
        }
        if (sdkParentDisposable == null) {
            LightPlatformTestCase.$$$reportNull$$$0(5);
        }
        if (localInspectionTools == null) {
            LightPlatformTestCase.$$$reportNull$$$0(6);
        }
        Application app = ApplicationManager.getApplication();
        Ref reusedProject = new Ref((Object)true);
        app.invokeAndWait(() -> {
            IdeaLogger.ourErrorsOccurred = null;
            app.assertIsDispatchThread();
            myOldSdks = new SdkLeakTracker();
            descriptor.registerSdk(sdkParentDisposable);
            if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor)) {
                LightPlatformTestCase.initProject(descriptor);
                reusedProject.set((Object)false);
            }
        });
        Project project2 = ourProject;
        try {
            PlatformTestUtil.openProject(project2);
        }
        catch (Throwable e) {
            LightPlatformTestCase.setProject(null);
            throw e;
        }
        Ref result = new Ref();
        app.invokeAndWait(() -> {
            if (((Boolean)reusedProject.get()).booleanValue()) {
                WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)project2).makeRootsChange(EmptyRunnable.getInstance(), false, true));
            }
            MessageBusConnection connection = project2.getMessageBus().connect(parentDisposable);
            connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                public void moduleAdded(@NotNull Project project2, @NotNull Module module) {
                    if (project2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (module == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    TestCase.fail((String)"Adding modules is not permitted in light tests.");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "module";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/testFramework/LightPlatformTestCase$2";
                    objectArray[2] = "moduleAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            LightPlatformTestCase.clearUncommittedDocuments(project2);
            InspectionsKt.configureInspections((InspectionProfileEntry[])localInspectionTools, project2, parentDisposable);
            LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed());
            Boolean passed = null;
            try {
                passed = StartupManagerEx.getInstanceEx((Project)project2).startupActivityPassed();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LightPlatformTestCase.assertTrue((String)("open: " + project2.isOpen() + "; disposed:" + project2.isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)project2.isInitialized());
            CodeStyle.setTemporarySettings((Project)project2, (CodeStyleSettings)CodeStyle.createTestSettings());
            FileDocumentManager manager = FileDocumentManager.getInstance();
            if (manager instanceof FileDocumentManagerImpl) {
                Document[] unsavedDocuments = manager.getUnsavedDocuments();
                manager.saveAllDocuments();
                app.runWriteAction(() -> ((FileDocumentManagerImpl)((FileDocumentManagerImpl)manager)).dropAllUnsavedDocuments());
                LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
            }
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)new EmptyAction(true), (AnActionEvent)AnActionEvent.createFromDataContext((String)"", null, (DataContext)DataContext.EMPTY_CONTEXT));
            PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
            result.set((Object)Pair.createNonNull((Object)project2, (Object)ourModule));
        });
        Pair.NonNull nonNull = (Pair.NonNull)result.get();
        if (nonNull == null) {
            LightPlatformTestCase.$$$reportNull$$$0(7);
        }
        return nonNull;
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        if (tools == null) {
            LightPlatformTestCase.$$$reportNull$$$0(8);
        }
        InspectionsKt.enableInspectionTools(this.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (toolWrapper == null) {
            LightPlatformTestCase.$$$reportNull$$$0(9);
        }
        InspectionsKt.enableInspectionTool(this.getProject(), toolWrapper, this.getTestRootDisposable());
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            LightPlatformTestCase.$$$reportNull$$$0(10);
        }
        InspectionsKt.enableInspectionTool(this.getProject(), tool, this.getTestRootDisposable());
    }

    protected LocalInspectionTool @NotNull [] configureLocalInspectionTools() {
        if (LocalInspectionTool.EMPTY_ARRAY == null) {
            LightPlatformTestCase.$$$reportNull$$$0(11);
        }
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.getProject();
        RunAll.runAll(() -> {
            if (ApplicationManager.getApplication() != null) {
                CodeStyle.dropTemporarySettings((Project)project2);
            }
        }, () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                TestApplicationManagerKt.tearDownProjectAndApp(project2);
            }
        }, () -> {
            if (project2 != null) {
                ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project2)).clearScopesCachesForModules();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> super.tearDown(), () -> Disposer.dispose((Disposable)this.mySdkParentDisposable), () -> myOldSdks.checkForJdkTableLeaks(), () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            if (this.myVirtualFilePointerTracker != null) {
                this.myVirtualFilePointerTracker.assertPointersAreDisposed();
            }
        }, () -> {
            if (this.myLibraryTableTracker != null) {
                this.myLibraryTableTracker.assertDisposed();
            }
        }, () -> {
            if (ApplicationManager.getApplication() instanceof ApplicationEx) {
                HeavyPlatformTestCase.cleanupApplicationCaches(this.getProject());
            }
        }, () -> this.resetAllFields());
    }

    static void checkAssertions() throws Exception {
        if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    static void tearDownSourceRoot(@NotNull Project project2) {
        if (project2 == null) {
            LightPlatformTestCase.$$$reportNull$$$0(12);
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            if (ourSourceRoot != null) {
                try {
                    for (VirtualFile child : ourSourceRoot.getChildren()) {
                        child.delete(LightPlatformTestCase.class);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clearEncodingManagerDocumentQueue() {
        EncodingManager encodingManager = (EncodingManager)ApplicationManager.getApplication().getServiceIfCreated(EncodingManager.class);
        if (encodingManager instanceof EncodingManagerImpl) {
            ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
        }
    }

    public static void clearUncommittedDocuments(@NotNull Project project2) {
        if (project2 == null) {
            LightPlatformTestCase.$$$reportNull$$$0(13);
        }
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
        documentManager.clearUncommittedDocuments();
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
    }

    public static void checkEditorsReleased() {
        RunAll.runAll(() -> UIUtil.dispatchAllInvocationEvents(), () -> {
            EditorFactory editorFactory;
            Application app = ApplicationManager.getApplication();
            if (app != null && (editorFactory = (EditorFactory)app.getServiceIfCreated(EditorFactory.class)) != null) {
                ArrayList<ThrowableRunnable> actions = new ArrayList<ThrowableRunnable>();
                for (Editor editor : editorFactory.getAllEditors()) {
                    actions.add(() -> EditorFactoryImpl.throwNotReleasedError((Editor)editor));
                    actions.add(() -> editorFactory.releaseEditor(editor));
                }
                new RunAll(actions).run();
            }
        });
    }

    @Override
    protected void runBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            LightPlatformTestCase.$$$reportNull$$$0(14);
        }
        super.runBare(testRunnable);
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            LightPlatformTestCase.$$$reportNull$$$0(15);
        }
        ourAssertionsInTestDetected = true;
        super.runTestRunnable(testRunnable);
        ourAssertionsInTestDetected = false;
    }

    @Override
    protected void invokeTearDown() throws Exception {
        EdtTestUtil.runInEdtAndWait(() -> super.invokeTearDown());
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            LightPlatformTestCase.$$$reportNull$$$0(16);
        }
        return this.getProject() == null || this.getProject().isDisposed() ? null : new TestDataProvider(this.getProject()).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected String getModuleTypeId() {
        return "EMPTY_MODULE";
    }

    @NotNull
    protected PsiFile createFile(@NonNls @NotNull String fileName, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            LightPlatformTestCase.$$$reportNull$$$0(17);
        }
        if (text == null) {
            LightPlatformTestCase.$$$reportNull$$$0(18);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
        if (psiFile == null) {
            LightPlatformTestCase.$$$reportNull$$$0(19);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createLightFile(@NonNls @NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            LightPlatformTestCase.$$$reportNull$$$0(20);
        }
        if (text == null) {
            LightPlatformTestCase.$$$reportNull$$$0(21);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
        if (psiFile == null) {
            LightPlatformTestCase.$$$reportNull$$$0(22);
        }
        return psiFile;
    }

    @Override
    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        Object name = this.getName();
        if (!((String)(name = StringUtil.trimStart((String)name, (String)"test"))).isEmpty() && lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName((String)name)) {
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        String string = name;
        if (string == null) {
            LightPlatformTestCase.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)this.getProject());
        if (codeStyleSettings == null) {
            LightPlatformTestCase.$$$reportNull$$$0(24);
        }
        return codeStyleSettings;
    }

    @NotNull
    protected CommonCodeStyleSettings getLanguageSettings(@NotNull Language language) {
        if (language == null) {
            LightPlatformTestCase.$$$reportNull$$$0(25);
        }
        CommonCodeStyleSettings commonCodeStyleSettings = this.getCurrentCodeStyleSettings().getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            LightPlatformTestCase.$$$reportNull$$$0(26);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    protected <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> settingsClass) {
        if (settingsClass == null) {
            LightPlatformTestCase.$$$reportNull$$$0(27);
        }
        CustomCodeStyleSettings customCodeStyleSettings = this.getCurrentCodeStyleSettings().getCustomSettings(settingsClass);
        if (customCodeStyleSettings == null) {
            LightPlatformTestCase.$$$reportNull$$$0(28);
        }
        return (T)customCodeStyleSettings;
    }

    protected void commitDocument(@NotNull Document document) {
        if (document == null) {
            LightPlatformTestCase.$$$reportNull$$$0(29);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
    }

    protected void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    protected Document getDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            LightPlatformTestCase.$$$reportNull$$$0(30);
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    public static synchronized void closeAndDeleteProject() {
        Project project2 = ourProject;
        if (project2 == null) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeAndDeleteProject from under write action");
        }
        if (!project2.isDisposed()) {
            LightPlatformTestCase.assertEquals((Object)project2, (Object)ourModule.getProject());
            Path ioFile = Paths.get(project2.getProjectFilePath(), new String[0]);
            if (Files.exists(ioFile, new LinkOption[0])) {
                Path dir = ioFile.getParent();
                if (dir.getFileName().toString().startsWith("unitTest_")) {
                    PathKt.delete((Path)dir);
                } else {
                    PathKt.delete((Path)ioFile);
                }
            }
        }
        try {
            LightPlatformTestCase.assertTrue((boolean)ProjectManagerEx.getInstanceEx().forceCloseProject(project2));
            LightPlatformTestCase.assertTrue((boolean)project2.isDisposed());
            LightPlatformTestCase.assertTrue((boolean)ourModule.isDisposed());
            if (ourPsiManager != null) {
                LightPlatformTestCase.assertTrue((boolean)ourPsiManager.isDisposed());
            }
        }
        finally {
            LightPlatformTestCase.setProject(null);
            ourModule = null;
            ourPsiManager = null;
        }
    }

    protected static void setProject(Project project2) {
        ourProject = project2;
    }

    static {
        PlatformTestUtil.registerProjectCleanup(LightPlatformTestCase::closeAndDeleteProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightPlatformTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkParentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localInspectionTools";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doSetup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLocalInspectionTools";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createLightFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCodeStyleSettings";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetClassFields";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSetup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTools";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTool";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tearDownSourceRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearUncommittedDocuments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runBare";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLightFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final String myModuleTypeId;
        @Nullable
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(@NotNull String moduleTypeId, @Nullable Sdk sdk) {
            if (moduleTypeId == null) {
                SimpleLightProjectDescriptor.$$$reportNull$$$0(0);
            }
            this.myModuleTypeId = moduleTypeId;
            this.mySdk = sdk;
        }

        @Override
        @NotNull
        public String getModuleTypeId() {
            String string = this.myModuleTypeId;
            if (string == null) {
                SimpleLightProjectDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (!this.myModuleTypeId.equals(that.myModuleTypeId)) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleTypeId.hashCode();
        }

        private boolean areJdksEqual(Sdk newSdk) {
            OrderRootType[] rootTypes;
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            if (!this.mySdk.getName().equals(newSdk.getName())) {
                return false;
            }
            for (OrderRootType rootType : rootTypes = new OrderRootType[]{OrderRootType.CLASSES, AnnotationOrderRootType.getInstance()}) {
                Object[] myUrls = this.mySdk.getRootProvider().getUrls(rootType);
                Object[] newUrls = newSdk.getRootProvider().getUrls(rootType);
                if (ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleTypeId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleTypeId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

