/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull String category) {
        if (category == null) {
            TestLogger.$$$reportNull$$$0(0);
        }
        super(Logger.getLogger((String)category));
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            TestLogger.$$$reportNull$$$0(1);
        }
        if (LoggedErrorProcessor.getInstance().processError(this.myLogger.getName(), (String)message, TestLogger.ensureNotControlFlow((Throwable)t), details)) {
            if (t instanceof TestLoggerAssertionError && ((String)message).equals(t.getMessage()) && details.length == 0) {
                throw (TestLoggerAssertionError)((Object)t);
            }
            if (TestLoggerFactory.shouldSplitTestLogs()) {
                TestLoggerFactory.log(Level.ERROR.toString(), this.myLogger.getName(), (String)message, t);
                for (String detail : details) {
                    TestLoggerFactory.log(Level.ERROR.toString(), this.myLogger.getName(), detail, null);
                }
            }
            message = (String)message + DefaultLogger.attachmentsToString((Throwable)t);
            this.myLogger.info(message, t);
            DefaultLogger.dumpExceptionsToStderr((String)message, (Throwable)t, (String[])details);
            throw new TestLoggerAssertionError((String)message, t);
        }
    }

    public void warn(String message, @Nullable Throwable t) {
        if (LoggedErrorProcessor.getInstance().processWarn(this.myLogger.getName(), message, TestLogger.ensureNotControlFlow((Throwable)t))) {
            if (TestLoggerFactory.shouldSplitTestLogs()) {
                TestLoggerFactory.log(Level.WARN.toString(), this.myLogger.getName(), message, t);
            }
            this.myLogger.warn((Object)message, t);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, @Nullable Throwable t) {
        super.info(message, t);
        TestLoggerFactory.log(Level.INFO.toString(), this.myLogger.getName(), message, t);
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(@Nullable Throwable t) {
        this.debug(null, t);
    }

    public void debug(String message, @Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(message, t);
            TestLoggerFactory.log(Level.DEBUG.toString(), this.myLogger.getName(), message, t);
        }
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            super.trace(message);
            TestLoggerFactory.log(Level.TRACE.toString(), this.myLogger.getName(), message, null);
        }
    }

    public void trace(@Nullable Throwable t) {
        if (this.isTraceEnabled()) {
            super.trace(t);
            TestLoggerFactory.log(Level.TRACE.toString(), this.myLogger.getName(), null, t);
        }
    }

    public boolean isDebugEnabled() {
        return !Accessor.isInStressTest() || super.isDebugEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Accessor {
        @Nullable
        private static final MethodHandle isInStressTest = Accessor.getMethodHandle();

        private Accessor() {
        }

        private static MethodHandle getMethodHandle() {
            try {
                Class<?> clazz = Class.forName("com.intellij.openapi.application.ex.ApplicationManagerEx");
                return MethodHandles.publicLookup().findStatic(clazz, "isInStressTest", MethodType.methodType(Boolean.TYPE));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                return null;
            }
        }

        private static boolean isInStressTest() {
            try {
                return isInStressTest != null && isInStressTest.invokeExact();
            }
            catch (Throwable ignored) {
                return false;
            }
        }
    }

    static final class TestLoggerAssertionError
    extends AssertionError {
        private TestLoggerAssertionError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

