/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import git4idea.config.GitExecutable;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CachingFileTester {
    private static final Logger LOG = Logger.getInstance(CachingFileTester.class);
    private static final int FILE_TEST_TIMEOUT_MS = 30000;
    private final ReentrantLock LOCK = new ReentrantLock();
    @NotNull
    private final ConcurrentMap<GitExecutable, TestResult> myTestMap = new ConcurrentHashMap<GitExecutable, TestResult>();

    CachingFileTester() {
    }

    @NotNull
    final TestResult getResultFor(@NotNull GitExecutable executable) {
        if (executable == null) {
            CachingFileTester.$$$reportNull$$$0(0);
        }
        TestResult testResult = (TestResult)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.LOCK, (int)50, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
            TestResult result2 = (TestResult)this.myTestMap.get(executable);
            long currentLastModificationDate = 0L;
            try {
                currentLastModificationDate = CachingFileTester.getModificationTime(executable);
                if (result2 == null || result2.getFileLastModifiedTimestamp() != currentLastModificationDate) {
                    result2 = new TestResult(this.testOrAbort(executable), currentLastModificationDate);
                    this.myTestMap.put(executable, result2);
                }
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                result2 = new TestResult(e, currentLastModificationDate);
                this.myTestMap.put(executable, result2);
            }
            return result2;
        });
        if (testResult == null) {
            CachingFileTester.$$$reportNull$$$0(1);
        }
        return testResult;
    }

    private static long getModificationTime(@NotNull GitExecutable executable) throws IOException {
        if (executable == null) {
            CachingFileTester.$$$reportNull$$$0(2);
        }
        if (executable instanceof GitExecutable.Unknown) {
            return 0L;
        }
        if (executable instanceof GitExecutable.Local) {
            File exeFile;
            String filePath = executable.getExePath();
            if (!filePath.contains(File.separator) && (exeFile = PathEnvironmentVariableUtil.findInPath((String)filePath)) != null) {
                filePath = exeFile.getPath();
            }
            return Files.getLastModifiedTime(Paths.get(filePath, new String[0]), new LinkOption[0]).toMillis();
        }
        if (executable instanceof GitExecutable.Wsl) {
            return 0L;
        }
        LOG.error("Can't get modification time for " + executable);
        return 0L;
    }

    @NotNull
    private GitVersion testOrAbort(@NotNull GitExecutable executable) throws Exception {
        if (executable == null) {
            CachingFileTester.$$$reportNull$$$0(3);
        }
        int maxAttempts = 1;
        if (SystemInfo.isMac && "/usr/bin/git".equals(executable.getExePath())) {
            maxAttempts = 3;
        }
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            GitVersion result2 = this.runTestWithTimeout(executable);
            if (result2 == null) continue;
            GitVersion gitVersion = result2;
            if (gitVersion == null) {
                CachingFileTester.$$$reportNull$$$0(4);
            }
            return gitVersion;
        }
        throw new GitVersionIdentificationException("Cannot identify version of git executable: no response" + (maxAttempts > 1 ? String.format(" in %s attempts", maxAttempts) : ""), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GitVersion runTestWithTimeout(@NotNull GitExecutable executable) throws Exception {
        if (executable == null) {
            CachingFileTester.$$$reportNull$$$0(5);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        Ref exceptionRef = new Ref();
        Ref resultRef = new Ref();
        Semaphore semaphore = new Semaphore(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                resultRef.set((Object)this.testExecutable(executable));
            }
            catch (Exception e) {
                exceptionRef.set((Object)e);
            }
            finally {
                semaphore.release();
            }
        }, (ProgressIndicator)indicator));
        try {
            long start = System.currentTimeMillis();
            do {
                ProgressManager.checkCanceled();
            } while (!semaphore.tryAcquire(50L, TimeUnit.MILLISECONDS) && System.currentTimeMillis() - start <= 30000L);
            if (!resultRef.isNull()) {
                GitVersion gitVersion = (GitVersion)resultRef.get();
                return gitVersion;
            }
            if (!exceptionRef.isNull()) {
                throw (Exception)exceptionRef.get();
            }
            GitVersion gitVersion = null;
            return gitVersion;
        }
        finally {
            indicator.cancel();
        }
    }

    @Nullable
    public TestResult getCachedResultFor(@NotNull GitExecutable executable) {
        if (executable == null) {
            CachingFileTester.$$$reportNull$$$0(6);
        }
        return (TestResult)this.myTestMap.get(executable);
    }

    public void dropCache(@NotNull GitExecutable executable) {
        if (executable == null) {
            CachingFileTester.$$$reportNull$$$0(7);
        }
        this.myTestMap.remove(executable);
    }

    @NotNull
    protected abstract GitVersion testExecutable(@NotNull GitExecutable var1) throws Exception;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/CachingFileTester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/CachingFileTester";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "testOrAbort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResultFor";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTime";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "testOrAbort";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runTestWithTimeout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResultFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dropCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TestResult {
        @Nullable
        private final GitVersion myResult;
        @Nullable
        private final Exception myException;
        private final long myFileLastModifiedTimestamp;

        TestResult(@NotNull GitVersion result2, long timestamp) {
            if (result2 == null) {
                TestResult.$$$reportNull$$$0(0);
            }
            this.myResult = result2;
            this.myFileLastModifiedTimestamp = timestamp;
            this.myException = null;
        }

        TestResult(@NotNull Exception exception, long timestamp) {
            if (exception == null) {
                TestResult.$$$reportNull$$$0(1);
            }
            this.myFileLastModifiedTimestamp = timestamp;
            this.myResult = null;
            this.myException = exception;
        }

        @Nullable
        public GitVersion getResult() {
            return this.myResult;
        }

        @Nullable
        public Exception getException() {
            return this.myException;
        }

        private long getFileLastModifiedTimestamp() {
            return this.myFileLastModifiedTimestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exception";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/CachingFileTester$TestResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

