/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u001c\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lgit4idea/index/ui/GitStageRootInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "project", "Lcom/intellij/openapi/project/Project;", "tracker", "Lgit4idea/index/GitStageTracker;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/index/GitStageTracker;Lcom/intellij/openapi/Disposable;)V", "includedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "stagedRoots", "", "addInclusion", "", "items", "", "", "clearInclusion", "getInclusion", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "removeInclusion", "retainInclusion", "setInclusion", "Companion", "intellij.vcs.git"})
public final class GitStageRootInclusionModel
extends BaseInclusionModel {
    private Set<? extends VirtualFile> stagedRoots;
    private final Set<VirtualFile> includedRoots;
    private final Project project;
    private final GitStageTracker tracker;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Set<Object> getInclusion() {
        return GitStageRootInclusionModel.Companion.asRepositories(this.includedRoots, this.project);
    }

    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!(item instanceof GitRepository)) {
            return ThreeStateCheckBox.State.NOT_SELECTED;
        }
        if (this.includedRoots.contains(((GitRepository)item).getRoot())) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        return ThreeStateCheckBox.State.NOT_SELECTED;
    }

    public boolean isInclusionEmpty() {
        return this.includedRoots.isEmpty();
    }

    public void addInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.includedRoots.addAll(GitStageRootInclusionModel.Companion.asRoots(items));
        this.fireInclusionChanged();
    }

    public void removeInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        VcsUtil.removeAllFromSet(this.includedRoots, (Collection)GitStageRootInclusionModel.Companion.asRoots(items));
        this.fireInclusionChanged();
    }

    public void setInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.includedRoots.clear();
        this.includedRoots.addAll(GitStageRootInclusionModel.Companion.asRoots(items));
        this.fireInclusionChanged();
    }

    public void retainInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.includedRoots.retainAll(GitStageRootInclusionModel.Companion.asRoots(items));
        this.fireInclusionChanged();
    }

    public void clearInclusion() {
        this.includedRoots.clear();
        this.fireInclusionChanged();
    }

    public GitStageRootInclusionModel(@NotNull Project project, @NotNull GitStageTracker tracker, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.tracker = tracker;
        this.stagedRoots = SetsKt.emptySet();
        boolean bl = false;
        this.includedRoots = new LinkedHashSet();
        this.tracker.addListener(new GitStageTrackerListener(){

            @Override
            public void update() {
                block3: {
                    block2: {
                        Set removedRoots = SetsKt.minus((Set)stagedRoots, (Iterable)tracker.getState().getStagedRoots());
                        Set addedRoots = SetsKt.minus(tracker.getState().getStagedRoots(), (Iterable)stagedRoots);
                        stagedRoots = tracker.getState().getStagedRoots();
                        includedRoots.removeAll(removedRoots);
                        includedRoots.addAll(addedRoots);
                        Collection collection = removedRoots;
                        boolean bl = false;
                        if (!collection.isEmpty()) break block2;
                        collection = addedRoots;
                        bl = false;
                        if (!(!collection.isEmpty())) break block3;
                    }
                    this.fireInclusionChanged();
                }
            }
        }, disposable);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u0006H\u0002\u00a8\u0006\r"}, d2={"Lgit4idea/index/ui/GitStageRootInclusionModel$Companion;", "", "()V", "asRepositories", "", "Lgit4idea/repo/GitRepository;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "asRoots", "", "T", "intellij.vcs.git"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final <T> List<VirtualFile> asRoots(Collection<? extends T> $this$asRoots) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$asRoots;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile virtualFile;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                Object t = it;
                if (!(t instanceof GitRepository)) {
                    t = null;
                }
                GitRepository gitRepository = (GitRepository)t;
                if ((gitRepository != null ? gitRepository.getRoot() : null) == null) continue;
                virtualFile = virtualFile;
                boolean bl3 = false;
                boolean bl4 = false;
                VirtualFile it$iv$iv = virtualFile;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<GitRepository> asRepositories(Collection<? extends VirtualFile> $this$asRepositories, Project project) {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Iterable iterable = $this$asRepositories;
            boolean bl = false;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                GitRepository gitRepository;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl2 = false;
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl3 = false;
                Project $this$service$iv = project;
                boolean $i$f$service = false;
                Object object = $this$service$iv.getService(GitRepositoryManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                if ((GitRepository)((GitRepositoryManager)((Object)object)).getRepositoryForRootQuick(it) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                GitRepository it$iv = gitRepository;
                boolean bl6 = false;
                destination$iv.add(it$iv);
            }
            return (Set)destination$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

