/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.ignore.IgnoredToExcludedSynchronizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.impl.projectlevelman.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.GitContentRevision;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.index.LightFileStatus;
import git4idea.repo.GitRepository;
import git4idea.status.GitRefreshListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GitUntrackedFilesHolder
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final GitRepository myRepository;
    private final Set<FilePath> myUntrackedFiles;
    private final RecursiveFilePathSet myIgnoredFiles;
    private final Set<FilePath> myDirtyFiles;
    private boolean myEverythingDirty;
    private final MergingUpdateQueue myQueue;
    private final Object LOCK;
    private boolean myInUpdate;

    GitUntrackedFilesHolder(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(0);
        }
        this.myUntrackedFiles = new HashSet<FilePath>();
        this.myDirtyFiles = new HashSet<FilePath>();
        this.myEverythingDirty = true;
        this.LOCK = new Object();
        this.myInUpdate = false;
        this.myRepository = repository;
        this.myProject = repository.getProject();
        this.myRoot = repository.getRoot();
        this.myIgnoredFiles = new RecursiveFilePathSet(this.myRoot.isCaseSensitive());
        this.myQueue = VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).getIgnoreRefreshQueue();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myUntrackedFiles.clear();
            this.myIgnoredFiles.clear();
            this.myDirtyFiles.clear();
        }
    }

    public void add(@NotNull FilePath file) {
        if (file == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(1);
        }
        this.add(Collections.singletonList(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myUntrackedFiles.addAll(files);
            if (!this.myEverythingDirty) {
                this.myDirtyFiles.addAll(files);
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(3);
        }
        Object object = this.LOCK;
        synchronized (object) {
            files.forEach(this.myUntrackedFiles::remove);
            if (!this.myEverythingDirty) {
                this.myDirtyFiles.addAll(files);
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIgnored(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(4);
        }
        Object object = this.LOCK;
        synchronized (object) {
            files.forEach(arg_0 -> ((RecursiveFilePathSet)this.myIgnoredFiles).remove(arg_0));
            if (!this.myEverythingDirty) {
                if (ContainerUtil.exists(files, arg_0 -> ((RecursiveFilePathSet)this.myIgnoredFiles).hasAncestor(arg_0))) {
                    this.myEverythingDirty = true;
                } else {
                    this.myDirtyFiles.addAll(files);
                }
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPossiblyUntracked(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(5);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myEverythingDirty) {
                return;
            }
            for (FilePath filePath : files) {
                if (!this.myIgnoredFiles.contains(filePath) && this.myIgnoredFiles.hasAncestor(filePath)) continue;
                this.myDirtyFiles.add(filePath);
            }
        }
        this.scheduleUpdate();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        List list2 = ContainerUtil.mapNotNull(this.retrieveUntrackedFilePaths(), FilePath::getVirtualFile);
        if (list2 == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(6);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myEverythingDirty = true;
            this.myDirtyFiles.clear();
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUpdateMode() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myInUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<FilePath> getUntrackedFilePaths() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList<FilePath> arrayList = new ArrayList<FilePath>(this.myUntrackedFiles);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        GitUntrackedFilesHolder.$$$reportNull$$$0(7);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<FilePath> getIgnoredFilePaths() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList<FilePath> arrayList = new ArrayList<FilePath>(this.myIgnoredFiles.filePaths());
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        GitUntrackedFilesHolder.$$$reportNull$$$0(8);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFile(@NotNull FilePath filePath) {
        if (filePath == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(9);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.myUntrackedFiles.contains(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIgnoredFile(@NotNull FilePath filePath) {
        if (filePath == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(10);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.myIgnoredFiles.hasAncestor(filePath);
        }
    }

    @NotNull
    public Collection<FilePath> retrieveUntrackedFilePaths() throws VcsException {
        VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).awaitRefreshQueue();
        Collection<FilePath> collection = this.getUntrackedFilePaths();
        if (collection == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public Collection<FilePath> retrieveIgnoredFilePaths() {
        VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).awaitRefreshQueue();
        Collection<FilePath> collection = this.getIgnoredFilePaths();
        if (collection == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(12);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myEverythingDirty || !this.myDirtyFiles.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isDirty()) {
                return;
            }
            this.myInUpdate = true;
        }
        ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
        this.myQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)new ComparableObject.Impl(new Object[]{this, "update"}), this::update));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ArrayList<FilePath> dirtyFiles;
        boolean nothingToDo;
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = nothingToDo = !this.isDirty();
            if (nothingToDo) {
                this.myInUpdate = false;
            }
            dirtyFiles = this.myEverythingDirty ? null : new ArrayList<FilePath>(this.myDirtyFiles);
            this.myDirtyFiles.clear();
            this.myEverythingDirty = false;
        }
        if (nothingToDo) {
            ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
            return;
        }
        ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).progressStarted();
        try {
            ArrayList<FilePath> newIgnored;
            HashSet<FilePath> oldIgnored;
            RefreshResult result2 = this.refreshFiles(dirtyFiles);
            this.removePathsUnderOtherRoots(result2.untracked, "unversioned");
            this.removePathsUnderOtherRoots(result2.ignored, "ignored");
            RecursiveFilePathSet dirtyScope = null;
            if (dirtyFiles != null) {
                dirtyScope = new RecursiveFilePathSet(this.myRoot.isCaseSensitive());
                dirtyScope.addAll(dirtyFiles);
            }
            Object object2 = this.LOCK;
            synchronized (object2) {
                oldIgnored = new HashSet<FilePath>(this.myIgnoredFiles.filePaths());
                this.applyRefreshResult(result2, dirtyScope, oldIgnored);
                newIgnored = new ArrayList<FilePath>(this.myIgnoredFiles.filePaths());
                this.myInUpdate = this.isDirty();
            }
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).repositoryUpdated(this.myRepository);
            ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
            ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
            this.notifyExcludedSynchronizer(oldIgnored, newIgnored);
        }
        finally {
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).progressStopped();
        }
    }

    private void applyRefreshResult(@NotNull RefreshResult result2, @Nullable RecursiveFilePathSet dirtyScope, @NotNull Set<FilePath> oldIgnored) {
        if (result2 == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(13);
        }
        if (oldIgnored == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(14);
        }
        if (dirtyScope != null) {
            this.myUntrackedFiles.removeIf(filePath -> dirtyScope.hasAncestor(filePath));
            this.myUntrackedFiles.addAll(result2.untracked);
            this.myIgnoredFiles.clear();
            for (FilePath filePath2 : oldIgnored) {
                if (dirtyScope.hasAncestor(filePath2)) continue;
                this.myIgnoredFiles.add(filePath2);
            }
            for (FilePath filePath2 : result2.ignored) {
                if (this.myIgnoredFiles.hasAncestor(filePath2)) continue;
                this.myIgnoredFiles.add(filePath2);
            }
        } else {
            this.myUntrackedFiles.clear();
            this.myUntrackedFiles.addAll(result2.untracked);
            this.myIgnoredFiles.clear();
            this.myIgnoredFiles.addAll(result2.ignored);
        }
    }

    private void notifyExcludedSynchronizer(@NotNull Set<FilePath> oldIgnored, @NotNull List<FilePath> newIgnored) {
        if (oldIgnored == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(15);
        }
        if (newIgnored == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(16);
        }
        ArrayList<FilePath> addedIgnored = new ArrayList<FilePath>();
        for (FilePath filePath : newIgnored) {
            if (oldIgnored.contains(filePath)) continue;
            addedIgnored.add(filePath);
        }
        if (!addedIgnored.isEmpty()) {
            ((IgnoredToExcludedSynchronizer)this.myProject.getService(IgnoredToExcludedSynchronizer.class)).ignoredUpdateFinished(addedIgnored);
        }
    }

    private void removePathsUnderOtherRoots(@NotNull Collection<FilePath> untrackedFiles, @NonNls String type) {
        if (untrackedFiles == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(17);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        int removedFiles = 0;
        int maxFilesToReport = 10;
        Iterator<FilePath> it = untrackedFiles.iterator();
        while (it.hasNext()) {
            FilePath filePath = it.next();
            VirtualFile root = vcsManager.getVcsRootFor(filePath);
            if (this.myRoot.equals(root)) continue;
            it.remove();
            if (++removedFiles >= maxFilesToReport) continue;
            LOG.warn(String.format("Ignoring %s file under another root: %s; root: %s; mapped root: %s", type, filePath.getPresentableUrl(), this.myRoot.getPresentableUrl(), root != null ? root.getPresentableUrl() : "null"));
        }
        if (removedFiles >= maxFilesToReport) {
            LOG.warn(String.format("Ignoring %s files under another root: %s files total", type, removedFiles));
        }
    }

    @NotNull
    private RefreshResult refreshFiles(@Nullable List<FilePath> dirty) {
        RefreshResult refreshResult;
        try {
            boolean withIgnored = AdvancedSettings.getBoolean((String)"vcs.process.ignored");
            List<LightFileStatus.StatusRecord> fileStatuses = GitIndexStatusUtilKt.getFileStatus(this.myProject, this.myRoot, ContainerUtil.notNullize(dirty), false, true, withIgnored);
            RefreshResult result2 = new RefreshResult();
            for (LightFileStatus.StatusRecord status : fileStatuses) {
                if (GitIndexStatusUtilKt.isUntracked(status.getIndex())) {
                    result2.untracked.add(GitUntrackedFilesHolder.getFilePath(this.myRoot, status));
                }
                if (!GitIndexStatusUtilKt.isIgnored(status.getIndex())) continue;
                result2.ignored.add(GitUntrackedFilesHolder.getFilePath(this.myRoot, status));
            }
            refreshResult = result2;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return new RefreshResult();
        }
        if (refreshResult == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(18);
        }
        return refreshResult;
    }

    @NotNull
    private static FilePath getFilePath(@NotNull VirtualFile root, @NotNull LightFileStatus.StatusRecord status) {
        if (root == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(19);
        }
        if (status == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(20);
        }
        String path = status.getPath();
        FilePath filePath = GitContentRevision.createPath(root, path, path.endsWith("/"));
        if (filePath == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(21);
        }
        return filePath;
    }

    @TestOnly
    public Waiter createWaiter() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return new Waiter(this.myQueue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldIgnored";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIgnored";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedFiles";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUntrackedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUntrackedFilePaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilePaths";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUntrackedFilePaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveIgnoredFilePaths";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markPossiblyUntracked";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoredFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyRefreshResult";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifyExcludedSynchronizer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removePathsUnderOtherRoots";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @TestOnly
    public static class Waiter {
        private final MergingUpdateQueue myQueue;

        public Waiter(@NotNull MergingUpdateQueue queue) {
            if (queue == null) {
                Waiter.$$$reportNull$$$0(0);
            }
            this.myQueue = queue;
        }

        public void waitFor() {
            CountDownLatch waiter = new CountDownLatch(1);
            this.myQueue.queue(Update.create((Object)waiter, () -> waiter.countDown()));
            ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
            this.myQueue.waitForAllExecuted(10L, TimeUnit.SECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "git4idea/repo/GitUntrackedFilesHolder$Waiter", "<init>"));
        }
    }

    private static class RefreshResult {
        @NotNull
        public final Set<FilePath> untracked = new HashSet<FilePath>();
        @NotNull
        public final Set<FilePath> ignored = new HashSet<FilePath>();

        private RefreshResult() {
        }
    }
}

