/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.reset.GitResetMode;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitNewResetDialog
extends DialogWrapper {
    private static final String DIALOG_ID = "git.new.reset.dialog";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<GitRepository, VcsFullCommitDetails> myCommits;
    @NotNull
    private final GitResetMode myDefaultMode;
    @NotNull
    private final ButtonGroup myButtonGroup;
    private RadioButtonEnumModel<GitResetMode> myEnumModel;

    protected GitNewResetDialog(@NotNull Project project, @NotNull Map<GitRepository, VcsFullCommitDetails> commits2, @NotNull GitResetMode defaultMode) {
        if (project == null) {
            GitNewResetDialog.$$$reportNull$$$0(0);
        }
        if (commits2 == null) {
            GitNewResetDialog.$$$reportNull$$$0(1);
        }
        if (defaultMode == null) {
            GitNewResetDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myCommits = commits2;
        this.myDefaultMode = defaultMode;
        this.myButtonGroup = new ButtonGroup();
        this.init();
        this.setTitle(GitBundle.message("git.reset.dialog.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("git.reset.button", new Object[0]));
        this.setResizable(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultAnchor(21).setDefaultInsets(0, 10, 12, 0);
        String description = GitNewResetDialog.prepareDescription(this.myProject, this.myCommits);
        panel2.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)description)), gb.nextLine().next().coverLine());
        JBLabel descriptionLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("git.reset.dialog.description", new Object[0])), UIUtil.ComponentStyle.SMALL);
        panel2.add((Component)descriptionLabel, gb.nextLine().next().coverLine());
        for (GitResetMode mode : GitResetMode.values()) {
            JBRadioButton button2 = new JBRadioButton(mode.getName());
            button2.setMnemonic(mode.getName().charAt(0));
            this.myButtonGroup.add((AbstractButton)button2);
            panel2.add((Component)button2, gb.nextLine().next());
            panel2.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)mode.getDescription()), UIUtil.ComponentStyle.SMALL), gb.next());
        }
        this.myEnumModel = RadioButtonEnumModel.bindEnum(GitResetMode.class, (ButtonGroup)this.myButtonGroup);
        this.myEnumModel.setSelected((Enum)this.myDefaultMode);
        return panel2;
    }

    @Nullable
    protected String getHelpId() {
        return DIALOG_ID;
    }

    @Nls
    @NotNull
    private static String prepareDescription(@NotNull Project project, @NotNull Map<GitRepository, VcsFullCommitDetails> commits2) {
        if (project == null) {
            GitNewResetDialog.$$$reportNull$$$0(3);
        }
        if (commits2 == null) {
            GitNewResetDialog.$$$reportNull$$$0(4);
        }
        if (commits2.size() == 1 && !GitNewResetDialog.isMultiRepo(project)) {
            Map.Entry<GitRepository, VcsFullCommitDetails> entry = commits2.entrySet().iterator().next();
            String string = String.format("%s -> %s", GitNewResetDialog.getSourceText(entry.getKey()), GitNewResetDialog.getTargetText(entry.getValue()));
            if (string == null) {
                GitNewResetDialog.$$$reportNull$$$0(5);
            }
            return string;
        }
        @NlsSafe StringBuilder desc = new StringBuilder();
        for (Map.Entry<GitRepository, VcsFullCommitDetails> entry : commits2.entrySet()) {
            GitRepository repository = entry.getKey();
            VcsFullCommitDetails commit = entry.getValue();
            String sourceInRepo = GitBundle.message("git.reset.dialog.description.source.in.repository", GitNewResetDialog.getSourceText(repository), DvcsUtil.getShortRepositoryName((Repository)repository));
            desc.append(String.format("%s -> %s<br/>", sourceInRepo, GitNewResetDialog.getTargetText(commit)));
        }
        String string = desc.toString();
        if (string == null) {
            GitNewResetDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getTargetText(@NotNull VcsFullCommitDetails commit) {
        if (commit == null) {
            GitNewResetDialog.$$$reportNull$$$0(7);
        }
        String commitMessage = StringUtil.shortenTextWithEllipsis((String)commit.getSubject(), (int)20, (int)0);
        HtmlChunk.Element commitDetails = HtmlChunk.tag((String)"code").children(new HtmlChunk[]{HtmlChunk.text((String)((Hash)commit.getId()).toShortString()).bold(), HtmlChunk.text((String)(" \"" + commitMessage + "\""))});
        HtmlChunk.Element author = HtmlChunk.tag((String)"code").addText(VcsUserUtil.getShortPresentation((VcsUser)commit.getAuthor()));
        String string = GitBundle.message("git.reset.dialog.description.commit.details.by.author", commitDetails, author);
        if (string == null) {
            GitNewResetDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    @NonNls
    private static String getSourceText(@NotNull GitRepository repository) {
        if (repository == null) {
            GitNewResetDialog.$$$reportNull$$$0(9);
        }
        String currentRevision = repository.getCurrentRevision();
        assert (currentRevision != null);
        Object text = repository.getCurrentBranch() == null ? "HEAD (" + DvcsUtil.getShortHash((String)currentRevision) + ")" : repository.getCurrentBranch().getName();
        String string = XmlStringUtil.wrapInHtmlTag((String)text, (String)"b");
        if (string == null) {
            GitNewResetDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static boolean isMultiRepo(@NotNull Project project) {
        if (project == null) {
            GitNewResetDialog.$$$reportNull$$$0(11);
        }
        return GitRepositoryManager.getInstance(project).moreThanOneRoot();
    }

    @NotNull
    public GitResetMode getResetMode() {
        GitResetMode gitResetMode = (GitResetMode)this.myEnumModel.getSelected();
        if (gitResetMode == null) {
            GitNewResetDialog.$$$reportNull$$$0(12);
        }
        return gitResetMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMode";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/reset/GitNewResetDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/reset/GitNewResetDialog";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDescription";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareDescription";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTargetText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMultiRepo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

