/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.actions.GitFetch;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.BranchGroupingAction;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesDashboardControllerKt;
import git4idea.ui.branch.dashboard.BranchesDashboardUi;
import git4idea.ui.branch.dashboard.BranchesDashboardUiKt;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeModelKt;
import git4idea.ui.branch.dashboard.FilteringBranchesTree;
import git4idea.ui.branch.dashboard.NodeType;
import git4idea.ui.branch.dashboard.RemoteInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\"\b\u00c0\u0002\u0018\u00002\u00020\u0001: \u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006#"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions;", "", "()V", "BranchActionsBuilder", "BranchesActionBase", "BranchesTreeActionGroup", "ChangeBranchFilterAction", "CheckoutSelectedBranchAction", "CurrentBranchActions", "DeleteBranchAction", "EditRemoteAction", "FetchAction", "GroupActions", "GroupBranchAction", "GroupBranchByDirectoryAction", "GroupBranchByRepositoryAction", "GroupingSettingsGroup", "HideBranchesAction", "LocalBranchActions", "MultipleGroupActions", "MultipleLocalBranchActions", "NavigateLogToBranchAction", "NavigateLogToSelectedBranchAction", "NewBranchAction", "RemoteActionBase", "RemoteBranchActions", "RemoteGlobalActions", "RemoveRemoteAction", "RenameLocalBranch", "ShowArbitraryBranchesDiffAction", "ShowBranchDiffAction", "ShowMyBranchesAction", "ToggleFavoriteAction", "UpdateBranchFilterInLogAction", "UpdateSelectedBranchAction", "intellij.vcs.git"})
public final class BranchesDashboardActions {
    @NotNull
    public static final BranchesDashboardActions INSTANCE;

    private BranchesDashboardActions() {
    }

    static {
        BranchesDashboardActions branchesDashboardActions;
        INSTANCE = branchesDashboardActions = new BranchesDashboardActions();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesTreeActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "hideIfNoVisibleChildren", "", "intellij.vcs.git"})
    public static final class BranchesTreeActionGroup
    extends ActionGroup
    implements DumbAware {
        private final Project project;
        private final FilteringBranchesTree tree;

        public boolean hideIfNoVisibleChildren() {
            return true;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new BranchActionsBuilder(this.project, this.tree).build();
            if (anActionArray == null || (anActionArray = anActionArray.getChildren(e)) == null) {
                anActionArray = AnAction.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            }
            return anActionArray;
        }

        public BranchesTreeActionGroup(@NotNull Project project, @NotNull FilteringBranchesTree tree) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
            this.project = project;
            this.tree = tree;
            this.setPopup(true);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleLocalBranchActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class MultipleLocalBranchActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{(AnAction)new ShowArbitraryBranchesDiffAction(), (AnAction)new UpdateSelectedBranchAction(), (AnAction)new DeleteBranchAction()};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$CurrentBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "selectedRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class CurrentBranchActions
    extends GitBranchPopupActions.CurrentBranchActions {
        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = super.getChildren(e);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"super.getChildren(e)");
            ArrayList children = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(anActionArray, anActionArray.length));
            List list2 = this.myRepositories;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myRepositories");
            if (MultiRootBranches.diverged((Collection)list2)) {
                children.add(1, new GitBranchPopupActions.LocalBranchActions.CheckoutAction(this.myProject, this.myRepositories, this.myBranchName));
            }
            Collection $this$toTypedArray$iv = children;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray2 = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray2;
        }

        public CurrentBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Intrinsics.checkNotNullParameter((Object)selectedRepository, (String)"selectedRepository");
            super(project, repositories, branchName, selectedRepository);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$LocalBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$LocalBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "selectedRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class LocalBranchActions
    extends GitBranchPopupActions.LocalBranchActions {
        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = super.getChildren(e);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"super.getChildren(e)");
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(anActionArray, anActionArray.length));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray2 = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray2;
        }

        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Intrinsics.checkNotNullParameter((Object)selectedRepository, (String)"selectedRepository");
            super(project, repositories, branchName, selectedRepository);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "selectedRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class RemoteBranchActions
    extends GitBranchPopupActions.RemoteBranchActions {
        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = super.getChildren(e);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"super.getChildren(e)");
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(anActionArray, anActionArray.length));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray2 = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray2;
        }

        public RemoteBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NonNls @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Intrinsics.checkNotNullParameter((Object)selectedRepository, (String)"selectedRepository");
            super(project, repositories, branchName, selectedRepository);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class GroupActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])new AnAction[]{(AnAction)new EditRemoteAction(), (AnAction)new RemoveRemoteAction()});
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleGroupActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class MultipleGroupActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])new AnAction[]{(AnAction)new RemoveRemoteAction()});
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteGlobalActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class RemoteGlobalActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Object[] objectArray = new AnAction[1];
            AnAction anAction = ActionManager.getInstance().getAction("Git.Configure.Remotes");
            Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"ActionManager.getInstanc\u2026(\"Git.Configure.Remotes\")");
            objectArray[0] = anAction;
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchActionsBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;)V", "build", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.vcs.git"})
    public static final class BranchActionsBuilder {
        private final Project project;
        private final FilteringBranchesTree tree;

        @Nullable
        public final ActionGroup build() {
            List<BranchInfo> selectedBranches = this.tree.getSelectedBranches();
            boolean multipleBranchSelection = selectedBranches.size() > 1;
            AbstractRepositoryManager abstractRepositoryManager = GitUtil.getRepositoryManager(this.project);
            GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
            GitRepository gitRepository = (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)this.project, (AbstractRepositoryManager)abstractRepositoryManager, (String)gitVcsSettings.getRecentRootPath());
            if (gitRepository == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"DvcsUtil.guessCurrentRep\u2026tRootPath) ?: return null");
            GitRepository guessRepo = gitRepository;
            if (multipleBranchSelection) {
                return new MultipleLocalBranchActions();
            }
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.singleOrNull(selectedBranches);
            boolean headSelected = this.tree.getSelectedBranchFilters().contains("HEAD");
            if (branchInfo != null && !headSelected) {
                List<GitRepository> selectedRepositories = this.tree.getSelectedRepositories(branchInfo);
                GitRepository gitRepository2 = (GitRepository)CollectionsKt.singleOrNull(selectedRepositories);
                if (gitRepository2 == null) {
                    gitRepository2 = guessRepo;
                }
                GitRepository selectedRepository = gitRepository2;
                return branchInfo.isCurrent() ? (ActionGroup)new CurrentBranchActions(this.project, selectedRepositories, branchInfo.getBranchName(), selectedRepository) : (branchInfo.isLocal() ? (ActionGroup)new LocalBranchActions(this.project, selectedRepositories, branchInfo.getBranchName(), selectedRepository) : (ActionGroup)new RemoteBranchActions(this.project, selectedRepositories, branchInfo.getBranchName(), selectedRepository));
            }
            Set<RemoteInfo> selectedRemotes = this.tree.getSelectedRemotes();
            if (selectedRemotes.size() == 1) {
                return new GroupActions();
            }
            Collection selectedRepository = selectedRemotes;
            boolean bl = false;
            if (!selectedRepository.isEmpty()) {
                return new MultipleGroupActions();
            }
            Set<BranchNodeDescriptor> selectedBranchNodes = this.tree.getSelectedBranchNodes();
            if (selectedBranchNodes.size() == 1 && ((BranchNodeDescriptor)CollectionsKt.first((Iterable)selectedBranchNodes)).getType() == NodeType.REMOTE_ROOT) {
                return new RemoteGlobalActions();
            }
            String currentBranchName = guessRepo.getCurrentBranchName();
            if (currentBranchName != null && headSelected) {
                return (ActionGroup)new CurrentBranchActions(this.project, CollectionsKt.listOf((Object)guessRepo), currentBranchName, guessRepo);
            }
            return null;
        }

        public BranchActionsBuilder(@NotNull Project project, @NotNull FilteringBranchesTree tree) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
            this.project = project;
            this.tree = tree;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NewBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class NewBranchAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List branchFilters = (List)e.getData(BranchesTreeModelKt.getGIT_BRANCH_FILTERS());
            if (branchFilters != null && branchFilters.contains("HEAD")) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(true);
            } else {
                super.update(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            if (branches2.size() > 1) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setDescription(GitBundle.message("action.Git.New.Branch.description", new Object[0]));
                return;
            }
            Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BranchInfo p1 = (BranchInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = controller.getSelectedRepositories(p1);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, (List)repositories, (String)DvcsBundle.message((String)"action.not.possible.in.fresh.repo.new.branch", (Object[])new Object[0]));
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            Project project2 = project;
            List branchFilters = (List)e.getData(BranchesTreeModelKt.getGIT_BRANCH_FILTERS());
            if (branchFilters != null && branchFilters.contains("HEAD")) {
                GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
                List<GitRepository> list2 = gitRepositoryManager.getRepositories();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"GitRepositoryManager.get\u2026nce(project).repositories");
                GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project2, list2, "HEAD", null, null, 24, null);
            } else {
                void $this$flatMapTo$iv$iv;
                Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
                Intrinsics.checkNotNull((Object)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(GIT_BRANCHES)!!");
                List branches2 = (List)object;
                Object object2 = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
                Intrinsics.checkNotNull((Object)object2);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
                BranchesDashboardController controller = (BranchesDashboardController)object2;
                Iterable $this$flatMap$iv = branches2;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    BranchInfo p1 = (BranchInfo)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = controller.getSelectedRepositories(p1);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                String branchName = ((BranchInfo)CollectionsKt.first((List)branches2)).getBranchName();
                String string = branchName + "^0";
                String string2 = GitBundle.message("action.Git.New.Branch.dialog.title", branchName);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"action.Git.New.\u2026ialog.title\", branchName)");
                GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project2, repositories, string, string2, null, 16, null);
            }
        }

        public NewBranchAction() {
            super((Function0<String>)((Function0)1.INSTANCE), (Function0<String>)((Function0)2.INSTANCE), com.intellij.dvcs.ui.NewBranchAction.icon);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class UpdateSelectedBranchAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl2 = false;
                boolean bl3 = false;
                Project p1 = project2;
                boolean bl4 = false;
                bl = GitBranchActionsUtilKt.hasRemotes(p1);
            } else {
                bl = false;
            }
            boolean enabledAndVisible = bl;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(enabledAndVisible);
            if (enabledAndVisible) {
                super.update(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            Presentation presentation2 = presentation;
            GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(project);
            Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"GitFetchSupport.fetchSupport(project)");
            if (gitFetchSupport.isFetchRunning()) {
                presentation2.setEnabled(false);
                presentation2.setDescription(GitBundle.message("action.Git.Update.Selected.description.already.running", new Object[0]));
                return;
            }
            Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BranchInfo p1 = (BranchInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = controller.getSelectedRepositories(p1);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = branches2;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object bl = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = ((BranchInfo)receiver).getBranchName();
                collection.add(string);
            }
            List branchNames = (List)destination$iv$iv2;
            GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
            String $i$f$map22 = gitVcsSettings.getUpdateMethod().name();
            boolean bl = false;
            String string = $i$f$map22;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            String updateMethodName = string2;
            presentation2.setDescription(GitBundle.message("action.Git.Update.Selected.description", branches2.size(), updateMethodName));
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(branchNames, repositories);
            presentation2.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                presentation2.setDescription(GitBundle.message("action.Git.Update.Selected.description.tracking.not.configured", branches2.size()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(GIT_BRANCHES)!!");
            List branches2 = (List)object;
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            Project project2 = project;
            Object object2 = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BranchInfo p1 = (BranchInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = controller.getSelectedRepositories(p1);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = branches2;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object bl = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = ((BranchInfo)receiver).getBranchName();
                collection.add(string);
            }
            List branchNames = (List)destination$iv$iv2;
            GitBranchActionsUtilKt.updateBranches(project2, repositories, branchNames);
        }

        public UpdateSelectedBranchAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Update.Selected.text", new Object[0]), null, AllIcons.Actions.CheckOut, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "delete", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "controller", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "update", "intellij.vcs.git"})
    public static final class DeleteBranchAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(branches2, (String)"branches");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setText(GitBundle.message("action.Git.Delete.Branch.title", branches2.size()));
                Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
                Intrinsics.checkNotNull((Object)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
                BranchesDashboardController controller = (BranchesDashboardController)object;
                Iterable $this$any$iv = branches2;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BranchInfo it = (BranchInfo)element$iv;
                        boolean bl2 = false;
                        if (!(it.isCurrent() || !it.isLocal() && GitProtectedBranchesKt.isRemoteBranchProtected((Collection<? extends GitRepository>)controller.getSelectedRepositories(it), it.getBranchName()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean disabled = bl;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(!disabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(GIT_BRANCHES)!!");
            List branches2 = (List)object;
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            Project project2 = project;
            Object object2 = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            this.delete(project2, branches2, controller);
        }

        /*
         * WARNING - void declaration
         */
        private final void delete(Project project, Collection<BranchInfo> branches2, BranchesDashboardController controller) {
            void $this$associateTo$iv$iv;
            void localBranches;
            Object it;
            GitBrancher gitBrancher = GitBrancher.getInstance(project);
            Iterable $this$partition$iv = branches2;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                it = (BranchInfo)element$iv;
                boolean bl = false;
                if (((BranchInfo)it).isLocal() && !((BranchInfo)it).isCurrent()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list2 = (List)pair.component1();
            List remoteBranches = (List)pair.component2();
            boolean bl = false;
            boolean bl2 = false;
            GitBrancher $this$with = gitBrancher;
            boolean bl3 = false;
            Iterable $this$associate$iv = (Iterable)localBranches;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            it = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                BranchInfo it2 = (BranchInfo)element$iv$iv;
                boolean bl4 = false;
                Pair pair2 = TuplesKt.to((Object)it2.getBranchName(), controller.getSelectedRepositories(it2));
                boolean bl5 = false;
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Map branchesToContainingRepositories = destination$iv$iv;
            Function0 deleteRemoteBranches = (Function0)new Function0<Unit>($this$with, (List)localBranches, controller, remoteBranches){
                final /* synthetic */ GitBrancher $this_with;
                final /* synthetic */ List $localBranches$inlined;
                final /* synthetic */ BranchesDashboardController $controller$inlined;
                final /* synthetic */ List $remoteBranches$inlined;
                {
                    this.$this_with = gitBrancher;
                    this.$localBranches$inlined = list2;
                    this.$controller$inlined = branchesDashboardController;
                    this.$remoteBranches$inlined = list3;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    Object object;
                    T receiver;
                    boolean bl;
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.$remoteBranches$inlined;
                    GitBrancher gitBrancher = this.$this_with;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T item$iv$iv;
                        T t = item$iv$iv = iterator.next();
                        collection = destination$iv$iv;
                        bl = false;
                        object = ((BranchInfo)receiver).getBranchName();
                        collection.add((String)object);
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = this.$remoteBranches$inlined;
                    boolean $i$f$flatMap = false;
                    $this$mapTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    iterator = $this$flatMapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv;
                        receiver = element$iv$iv = iterator.next();
                        bl = false;
                        Iterable list$iv$iv = ((BranchInfo)receiver).getRepositories();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                    gitBrancher.deleteRemoteBranches((List<String>)collection, CollectionsKt.distinct((Iterable)((Iterable)object)));
                }
            };
            Set localBranchNames = branchesToContainingRepositories.keySet();
            Collection collection = localBranchNames;
            boolean bl6 = false;
            if (!collection.isEmpty()) {
                collection = deleteRemoteBranches;
                $this$with.deleteBranches(branchesToContainingRepositories, new Runnable((Function0)collection){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ void run() {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                    }
                });
            } else {
                deleteRemoteBranches.invoke();
            }
        }

        public DeleteBranchAction() {
            super(null, null, AllIcons.Actions.GC, 3, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class ShowBranchDiffAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(branches2, (String)"branches");
                Iterable $this$none$iv = branches2;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        BranchInfo it = (BranchInfo)element$iv;
                        boolean bl2 = false;
                        if (!(!it.isCurrent())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setDescription(GitBundle.message("action.Git.Update.Selected.description.select.non.current", new Object[0]));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Object object2 = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getData(GIT_BRANCHES)!!");
            List branches2 = (List)object2;
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            Project project2 = project;
            GitBrancher gitBrancher = GitBrancher.getInstance(project2);
            Iterable $this$filterNot$iv = branches2;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator = $this$filterNotTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator.next();
                boolean bl = false;
                if (((BranchInfo)receiver).isCurrent()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (BranchInfo branch : (List)destination$iv$iv) {
                gitBrancher.compare(branch.getBranchName(), controller.getSelectedRepositories(branch));
            }
        }

        public ShowBranchDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.With.Current.title", new Object[0]), null, AllIcons.Actions.Diff, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowArbitraryBranchesDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "commonRepositories", "Lgit4idea/repo/GitRepository;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "branchOne", "branchTwo", "intellij.vcs.git"})
    public static final class ShowArbitraryBranchesDiffAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            if (branches2.size() != 2) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabledAndVisible(false);
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setDescription("");
            } else {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setDescription(GitBundle.message("action.Git.Compare.Selected.description", new Object[0]));
                BranchInfo branchOne = (BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)0);
                BranchInfo branchTwo = (BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)1);
                Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
                Intrinsics.checkNotNull((Object)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
                BranchesDashboardController controller = (BranchesDashboardController)object;
                if (Intrinsics.areEqual((Object)branchOne.getBranchName(), (Object)branchTwo.getBranchName()) || this.commonRepositories(controller, branchOne, branchTwo).isEmpty()) {
                    Presentation presentation3 = e.getPresentation();
                    Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
                    presentation3.setEnabled(false);
                    Presentation presentation4 = e.getPresentation();
                    Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
                    presentation4.setDescription(GitBundle.message("action.Git.Compare.Selected.description.disabled", new Object[0]));
                }
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List branches2;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Object object2 = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getData(GIT_BRANCHES)!!");
            List list2 = branches2 = (List)object2;
            int n = 0;
            int n2 = 0;
            BranchInfo branchOne = (BranchInfo)list2.get(n);
            List list3 = branches2;
            n2 = 1;
            boolean bl = false;
            BranchInfo branchTwo = (BranchInfo)list3.get(n2);
            Collection<GitRepository> commonRepositories = this.commonRepositories(controller, branchOne, branchTwo);
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            GitBrancher.getInstance(project).compareAny(branchOne.getBranchName(), branchTwo.getBranchName(), CollectionsKt.toList((Iterable)commonRepositories));
        }

        private final Collection<GitRepository> commonRepositories(BranchesDashboardController $this$commonRepositories, BranchInfo branchOne, BranchInfo branchTwo) {
            return CollectionsKt.intersect((Iterable)$this$commonRepositories.getSelectedRepositories(branchOne), (Iterable)$this$commonRepositories.getSelectedRepositories(branchTwo));
        }

        public ShowArbitraryBranchesDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.Selected.title", new Object[0]), null, AllIcons.Actions.Diff, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "uiController", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardController;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.vcs.git"})
    public static final class ShowMyBranchesAction
    extends ToggleAction
    implements DumbAware {
        private final BranchesDashboardController uiController;

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.uiController.getShowOnlyMy();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.uiController.setShowOnlyMy(state);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            boolean isGraphReady;
            boolean supportsIndexing;
            block12: {
                Object it;
                boolean bl2;
                VcsProjectLog log;
                Project project;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.update(e);
                    project = (Project)e.getData(CommonDataKeys.PROJECT);
                    if (project == null) {
                        Presentation presentation = e.getPresentation();
                        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                        presentation.setEnabled(false);
                        return;
                    }
                    VcsProjectLog vcsProjectLog = log = VcsProjectLog.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"log");
                    Object object = vcsProjectLog.getDataManager();
                    if (object != null && (object = object.getLogProviders()) != null) {
                        Object $this$all$iv = object;
                        boolean $i$f$all = false;
                        if ($this$all$iv.isEmpty()) {
                            bl2 = true;
                        } else {
                            Object object2 = $this$all$iv;
                            boolean bl3 = false;
                            for (Map.Entry element$iv : object2.entrySet()) {
                                it = element$iv;
                                boolean bl4 = false;
                                Object object3 = VcsLogProperties.SUPPORTS_INDEXING.getOrDefault((VcsLogProvider)it.getValue());
                                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"VcsLogProperties.SUPPORT\u2026NG.getOrDefault(it.value)");
                                if (((Boolean)object3).booleanValue()) continue;
                                bl2 = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                }
                supportsIndexing = bl2;
                VcsLogData vcsLogData = log.getDataManager();
                isGraphReady = vcsLogData != null && (vcsLogData = vcsLogData.getDataPack()) != null ? vcsLogData.isFull() : false;
                GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
                List<GitRepository> list2 = gitRepositoryManager.getRepositories();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"GitRepositoryManager.get\u2026nce(project).repositories");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Map.Entry element$iv : $this$all$iv) {
                        boolean bl5;
                        it = (GitRepository)((Object)element$iv);
                        boolean bl6 = false;
                        VcsLogData vcsLogData2 = log.getDataManager();
                        if (vcsLogData2 != null && (vcsLogData2 = vcsLogData2.getIndex()) != null) {
                            Object object = it;
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
                            bl5 = vcsLogData2.isIndexed(object.getRoot());
                        } else {
                            bl5 = false;
                        }
                        if (bl5) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            boolean allRootsIndexed = bl;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(supportsIndexing && isGraphReady && allRootsIndexed);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setDescription(!supportsIndexing ? GitBundle.message("action.Git.Show.My.Branches.description.not.support.indexing", new Object[0]) : (!allRootsIndexed ? GitBundle.message("action.Git.Show.My.Branches.description.not.all.roots.indexed", new Object[0]) : (!isGraphReady ? GitBundle.message("action.Git.Show.My.Branches.description.not.graph.ready", new Object[0]) : GitBundle.message("action.Git.Show.My.Branches.description.is.my.branch", new Object[0]))));
        }

        public ShowMyBranchesAction(@NotNull BranchesDashboardController uiController) {
            Intrinsics.checkNotNullParameter((Object)uiController, (String)"uiController");
            Object object = GitBundleExtensions.INSTANCE.messagePointer("action.Git.Show.My.Branches.title", new Object[0]);
            if (object != null) {
                Function0<String> function0 = object;
                object = new Supplier(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ Object get() {
                        return this.function.invoke();
                    }
                };
            }
            super((Supplier)object, AllIcons.Actions.Find);
            this.uiController = uiController;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$FetchAction;", "Lgit4idea/actions/GitFetch;", "ui", "Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onFetchFinished", "result", "Lgit4idea/fetch/GitFetchResult;", "update", "intellij.vcs.git"})
    public static final class FetchAction
    extends GitFetch {
        private final BranchesDashboardUi ui;

        @Override
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean bl = false;
            boolean bl2 = false;
            Presentation $this$with = presentation;
            boolean bl3 = false;
            $this$with.setText(GitBundle.message("action.Git.Fetch.title", new Object[0]));
            $this$with.setIcon(AllIcons.Vcs.Fetch);
            $this$with.setDescription("");
            Project project = e.getProject();
            if (project == null) {
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return@with");
                Project project2 = project;
                GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(project2);
                Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"GitFetchSupport.fetchSupport(project)");
                if (gitFetchSupport.isFetchRunning()) {
                    $this$with.setEnabled(false);
                    $this$with.setDescription(GitBundle.message("action.Git.Fetch.description.fetch.in.progress", new Object[0]));
                }
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.ui.startLoadingBranches();
            super.actionPerformed(e);
        }

        @Override
        protected void onFetchFinished(@NotNull GitFetchResult result2) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            this.ui.stopLoadingBranches();
        }

        public FetchAction(@NotNull BranchesDashboardUi ui) {
            Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
            this.ui = ui;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class ToggleFavoriteAction
    extends BranchesActionBase {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            Project project2 = project;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(GIT_BRANCHES)!!");
            List branches2 = (List)object;
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            Object object2 = $this$service$iv.getService(GitBranchManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
            GitBranchManager gitBranchManager = (GitBranchManager)((Object)object2);
            for (BranchInfo branch : branches2) {
                GitBranchType type = branch.isLocal() ? GitBranchType.LOCAL : GitBranchType.REMOTE;
                Object object3 = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
                Intrinsics.checkNotNull((Object)object3);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
                BranchesDashboardController controller = (BranchesDashboardController)object3;
                List<GitRepository> repositories = controller.getSelectedRepositories(branch);
                for (GitRepository repository : repositories) {
                    gitBranchManager.setFavorite(type, repository, branch.getBranchName(), !branch.isFavorite());
                }
            }
        }

        public ToggleFavoriteAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Toggle.Favorite.title", new Object[0]), null, AllIcons.Nodes.Favorite, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ChangeBranchFilterAction;", "Lcom/intellij/vcs/log/ui/actions/BooleanPropertyToggleAction;", "()V", "getProperty", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "", "setSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "state", "intellij.vcs.git"})
    public static final class ChangeBranchFilterAction
    extends BooleanPropertyToggleAction {
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.setSelected(e, state);
            ((VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)).set((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getNAVIGATE_LOG_TO_BRANCH_ON_BRANCH_SELECTION_PROPERTY(), (Object)false);
        }

        @NotNull
        protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
            return (VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getCHANGE_LOG_FILTER_ON_BRANCH_SELECTION_PROPERTY();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NavigateLogToBranchAction;", "Lcom/intellij/vcs/log/ui/actions/BooleanPropertyToggleAction;", "()V", "getProperty", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.vcs.git"})
    public static final class NavigateLogToBranchAction
    extends BooleanPropertyToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return super.isSelected(e) && (Boolean)((VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)).get((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getCHANGE_LOG_FILTER_ON_BRANCH_SELECTION_PROPERTY()) == false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.setSelected(e, state);
            ((VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)).set((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getCHANGE_LOG_FILTER_ON_BRANCH_SELECTION_PROPERTY(), (Object)false);
        }

        @NotNull
        protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
            return (VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getNAVIGATE_LOG_TO_BRANCH_ON_BRANCH_SELECTION_PROPERTY();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupingSettingsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class GroupingSettingsGroup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.setPopup(GroupBranchByRepositoryAction.Companion.isEnabledAndVisible(e));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByDirectoryAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchAction;", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class GroupBranchByDirectoryAction
    extends GroupBranchAction {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Supplier supplier = DvcsBundle.messagePointer((String)"action.text.branch.group.by.directory", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"DvcsBundle.messagePointe\u2026anch.group.by.directory\")");
            Supplier groupByDirectory = supplier;
            Function0<String> groupingSeparator = GitBundleExtensions.INSTANCE.messagePointer("group.Git.Log.Branches.Grouping.Settings.text", new Object[0]);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setText(GroupBranchByRepositoryAction.Companion.isEnabledAndVisible(e) ? (String)groupByDirectory.get() : (String)groupingSeparator.invoke() + " " + (String)groupByDirectory.get());
        }

        public GroupBranchByDirectoryAction() {
            super(GroupingKey.GROUPING_BY_DIRECTORY);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchAction;", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.vcs.git"})
    public static final class GroupBranchByRepositoryAction
    extends GroupBranchAction {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(Companion.isEnabledAndVisible(e));
        }

        public GroupBranchByRepositoryAction() {
            super(GroupingKey.GROUPING_BY_REPOSITORY);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction$Companion;", "", "()V", "isEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
        public static final class Companion {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                Project project2 = project;
                if (project == null) return false;
                Project project3 = project2;
                RepositoryChangesBrowserNode.Companion companion = RepositoryChangesBrowserNode.Companion;
                boolean bl = false;
                boolean bl2 = false;
                Project p1 = project3;
                boolean bl3 = false;
                VcsLogColorManagerImpl vcsLogColorManagerImpl = companion.getColorManager(p1);
                project2 = vcsLogColorManagerImpl;
                if (vcsLogColorManagerImpl == null) return false;
                boolean bl4 = project2.hasMultiplePaths();
                return bl4;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchAction;", "Lgit4idea/ui/branch/BranchGroupingAction;", "key", "Lcom/intellij/dvcs/branch/GroupingKey;", "(Lcom/intellij/dvcs/branch/GroupingKey;)V", "setSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "state", "", "intellij.vcs.git"})
    public static abstract class GroupBranchAction
    extends BranchGroupingAction {
        @Override
        public void setSelected(@NotNull AnActionEvent e, @NotNull GroupingKey key, boolean state) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                BranchesDashboardController branchesDashboardController = (BranchesDashboardController)e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
                if (branchesDashboardController == null) break block0;
                branchesDashboardController.toggleGrouping(key, state);
            }
        }

        public GroupBranchAction(@NotNull GroupingKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, null, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$HideBranchesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.git"})
    public static final class HideBranchesAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(properties != null && properties.exists((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY()));
            super.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties != null && properties.exists((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY())) {
                properties.set((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY(), (Object)false);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoveRemoteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "()V", "doAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "update", "intellij.vcs.git"})
    public static final class RemoveRemoteAction
    extends RemoteActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setText(GitBundle.message("action.Git.Log.Remove.Remote.text", selectedRemotes.size()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            Object object = selectedRemotes;
            boolean bl = false;
            Iterator<Map.Entry<GitRepository, ? extends Set<GitRemote>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void repository;
                Map.Entry<GitRepository, ? extends Set<GitRemote>> entry;
                Map.Entry<GitRepository, ? extends Set<GitRemote>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Set<GitRemote> remotes = entry2.getValue();
                boolean $i$f$service = false;
                Class<Git> serviceClass$iv = Git.class;
                Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object2 == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                GitConfigureRemotesDialogKt.removeRemotes$default((Git)object2, (GitRepository)repository, remotes, null, 8, null);
            }
        }

        public RemoveRemoteAction() {
            super(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$EditRemoteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "()V", "doAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "update", "intellij.vcs.git"})
    public static final class EditRemoteAction
    extends RemoteActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            if (selectedRemotes.size() != 1) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabledAndVisible(false);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            void repository;
            Map.Entry entry;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            Map.Entry entry2 = entry = (Map.Entry)CollectionsKt.first((Iterable)selectedRemotes.entrySet());
            boolean bl = false;
            GitRepository gitRepository = (GitRepository)entry2.getKey();
            entry2 = entry;
            bl = false;
            Set remotes = (Set)entry2.getValue();
            boolean $i$f$service = false;
            Class<Git> serviceClass$iv = Git.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            GitConfigureRemotesDialogKt.editRemote$default((Git)object, (GitRepository)repository, (GitRemote)CollectionsKt.first((Iterable)remotes), null, 8, null);
        }

        public EditRemoteAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Log.Edit.Remote.text", new Object[0]), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B1\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011H&J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "description", "icon", "Ljavax/swing/Icon;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doAction", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "update", "intellij.vcs.git"})
    public static abstract class RemoteActionBase
    extends DumbAwareAction {
        private final Function0<String> description;

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
        }

        public abstract void doAction(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull Map<GitRepository, ? extends Set<GitRemote>> var3);

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            project = e.getProject();
            controller = (BranchesDashboardController)e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            v0 = controller;
            if (v0 == null || (v0 = v0.getSelectedRemotes()) == null) {
                v0 = selectedRemotes = MapsKt.emptyMap();
            }
            if (project == null) ** GOTO lbl-1000
            var6_5 = selectedRemotes;
            var7_6 = false;
            if (var6_5.isEmpty() == false) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            enabled = v1;
            v2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"e.presentation");
            v2.setEnabled(enabled);
            v3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"e.presentation");
            v3.setDescription((String)this.description.invoke());
            if (enabled) {
                v4 = project;
                Intrinsics.checkNotNull((Object)v4);
                this.update(e, v4, (Map<GitRepository, ? extends Set<GitRemote>>)selectedRemotes);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
            Project project2 = project;
            Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Map<GitRepository, Set<GitRemote>> selectedRemotes = controller.getSelectedRemotes();
            this.doAction(e, project2, selectedRemotes);
        }

        public RemoteActionBase(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Function0<String> text, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull Function0<String> description, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter(text, (String)"text");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            Function0<String> function0 = text;
            Supplier supplier = new /* invalid duplicate definition of identical inner class */;
            function0 = description;
            super(supplier, new /* invalid duplicate definition of identical inner class */, icon);
            this.description = description;
        }

        public /* synthetic */ RemoteActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 2) != 0) {
                function02 = 2.INSTANCE;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        public RemoteActionBase() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B1\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "description", "icon", "Ljavax/swing/Icon;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static abstract class BranchesActionBase
    extends DumbAwareAction {
        private final Function0<String> description;

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            controller = (BranchesDashboardController)e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            branches = (List)e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            project = e.getProject();
            if (project == null || controller == null || branches == null) ** GOTO lbl-1000
            var6_5 = branches;
            var7_6 = false;
            if (var6_5.isEmpty() == false) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            enabled = v0;
            v1 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"e.presentation");
            v1.setEnabled(enabled);
            v2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"e.presentation");
            v2.setDescription((String)this.description.invoke());
            if (enabled) {
                v3 = project;
                Intrinsics.checkNotNull((Object)v3);
                v4 = branches;
                Intrinsics.checkNotNull((Object)v4);
                this.update(e, v3, v4);
            }
        }

        public BranchesActionBase(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Function0<String> text, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull Function0<String> description, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter(text, (String)"text");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            Function0<String> function0 = text;
            Supplier supplier = new /* invalid duplicate definition of identical inner class */;
            function0 = description;
            super(supplier, new /* invalid duplicate definition of identical inner class */, icon);
            this.description = description;
        }

        public /* synthetic */ BranchesActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 2) != 0) {
                function02 = 2.INSTANCE;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        public BranchesActionBase() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$CheckoutSelectedBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class CheckoutSelectedBranchAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            if (branches2.size() > 1) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
                return;
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            Project project2 = project;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(GIT_BRANCHES)!!");
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.firstOrNull((List)((List)object));
            if (branchInfo == null) {
                return;
            }
            BranchInfo branch = branchInfo;
            Object object2 = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            List<GitRepository> repositories = controller.getSelectedRepositories(branch);
            if (branch.isLocal()) {
                GitBranchPopupActions.LocalBranchActions.CheckoutAction.checkoutBranch(project2, repositories, branch.getBranchName());
            } else {
                GitBranchPopupActions.RemoteBranchActions.CheckoutRemoteBranchAction.checkoutRemoteBranch(project2, repositories, branch.getBranchName());
            }
        }

        public CheckoutSelectedBranchAction() {
            super(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateBranchFilterInLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.git"})
    public static final class UpdateBranchFilterInLogAction
    extends DumbAwareAction {
        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            branchFilters = (List)e.getData(BranchesTreeModelKt.getGIT_BRANCH_FILTERS());
            uiController = (BranchesDashboardController)e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            project = e.getProject();
            if (project == null || uiController == null || branchFilters == null) ** GOTO lbl-1000
            var6_5 = branchFilters;
            var7_6 = false;
            if (var6_5.isEmpty() == false && e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) instanceof BranchesTreeComponent) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            enabled = v0;
            v1 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"e.presentation");
            v1.setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ((BranchesDashboardController)e.getRequiredData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER())).updateLogBranchFilter();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NavigateLogToSelectedBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.git"})
    public static final class NavigateLogToSelectedBranchAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            boolean visible;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List branchFilters = (List)e.getData(BranchesTreeModelKt.getGIT_BRANCH_FILTERS());
            BranchesDashboardController uiController = (BranchesDashboardController)e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Project project = e.getProject();
            boolean bl = visible = project != null && uiController != null;
            if (!visible) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabledAndVisible(visible);
                return;
            }
            boolean enabled = branchFilters != null && branchFilters.size() == 1;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ((BranchesDashboardController)e.getRequiredData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER())).navigateLogToSelectedBranch();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RenameLocalBranch;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class RenameLocalBranch
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            block10: {
                block9: {
                    boolean bl;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter(branches2, (String)"branches");
                        if (branches2.size() > 1) {
                            Presentation presentation = e.getPresentation();
                            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                            presentation.setEnabled(false);
                            return;
                        }
                        BranchInfo branch = (BranchInfo)CollectionsKt.first((Iterable)branches2);
                        Object object = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
                        Intrinsics.checkNotNull((Object)object);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
                        BranchesDashboardController controller = (BranchesDashboardController)object;
                        List<GitRepository> repositories = controller.getSelectedRepositories(branch);
                        if (!branch.isLocal()) break block9;
                        Iterable $this$any$iv = repositories;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Repository p1 = (Repository)element$iv;
                                boolean bl2 = false;
                                if (!p1.isFresh()) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block10;
                }
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            Project project2 = project;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getData(GIT_BRANCHES)!!");
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.firstOrNull((List)((List)object));
            if (branchInfo == null) {
                return;
            }
            BranchInfo branch = branchInfo;
            Object object2 = e.getData(BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getData(BRANCHES_UI_CONTROLLER)!!");
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            List<GitRepository> repositories = controller.getSelectedRepositories(branch);
            GitBranchPopupActions.LocalBranchActions.RenameBranchAction.rename(project2, repositories, branch.getBranchName());
        }

        public RenameLocalBranch() {
            super(null, null, null, 7, null);
        }
    }
}

