/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.GeneralSettingsPanel;
import org.jetbrains.idea.svn.NetworkSettingsPanel;
import org.jetbrains.idea.svn.PresentationSettingsPanel;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.dialogs.SshSettingsPanel;

public abstract class SvnConfigurable
extends ConfigurableBase<ConfigurableUi<SvnConfiguration>, SvnConfiguration> {
    @NonNls
    private static final String ID = "vcs.Subversion";
    @NonNls
    private static final String HELP_ID = "project.propSubversion";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Supplier<? extends ConfigurableUi<SvnConfiguration>> myUiSupplier;

    @NlsContexts.ConfigurableName
    @NotNull
    public static String getGroupDisplayName() {
        return "Subversion";
    }

    protected SvnConfigurable(@NotNull Project project, @NonNls @NotNull String idSuffix, @NlsContexts.ConfigurableName @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier) {
        if (project == null) {
            SvnConfigurable.$$$reportNull$$$0(0);
        }
        if (idSuffix == null) {
            SvnConfigurable.$$$reportNull$$$0(1);
        }
        if (displayName == null) {
            SvnConfigurable.$$$reportNull$$$0(2);
        }
        if (uiSupplier == null) {
            SvnConfigurable.$$$reportNull$$$0(3);
        }
        this(project, "vcs.Subversion." + idSuffix, displayName, uiSupplier, "project.propSubversion." + idSuffix);
    }

    protected SvnConfigurable(@NotNull Project project, @NonNls @NotNull String id, @NlsContexts.ConfigurableName @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier, @NonNls @NotNull String helpId) {
        if (project == null) {
            SvnConfigurable.$$$reportNull$$$0(4);
        }
        if (id == null) {
            SvnConfigurable.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            SvnConfigurable.$$$reportNull$$$0(6);
        }
        if (uiSupplier == null) {
            SvnConfigurable.$$$reportNull$$$0(7);
        }
        if (helpId == null) {
            SvnConfigurable.$$$reportNull$$$0(8);
        }
        super(id, displayName, helpId);
        this.myProject = project;
        this.myUiSupplier = uiSupplier;
    }

    protected ConfigurableUi<SvnConfiguration> createUi() {
        return this.myUiSupplier.get();
    }

    @NotNull
    protected SvnConfiguration getSettings() {
        SvnConfiguration svnConfiguration = SvnConfiguration.getInstance(this.myProject);
        if (svnConfiguration == null) {
            SvnConfigurable.$$$reportNull$$$0(9);
        }
        return svnConfiguration;
    }

    public static void selectConfigurationDirectory(@NotNull String path, @NotNull Consumer<? super String> dirConsumer, Project project, @Nullable Component component) {
        if (path == null) {
            SvnConfigurable.$$$reportNull$$$0(10);
        }
        if (dirConsumer == null) {
            SvnConfigurable.$$$reportNull$$$0(11);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(SvnBundle.message("dialog.title.select.configuration.directory", new Object[0])).withDescription(SvnBundle.message("dialog.description.select.configuration.directory", new Object[0])).withShowFileSystemRoots(true).withHideIgnored(false).withShowHiddenFiles(true);
        path = "file://" + ((String)path).replace(File.separatorChar, '/');
        VirtualFile root = VirtualFileManager.getInstance().findFileByUrl((String)path);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)component, (Project)project, (VirtualFile)root);
        if (file == null) {
            return;
        }
        String resultPath = file.getPath().replace('/', File.separatorChar);
        dirConsumer.consume((Object)resultPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idSuffix";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnConfigurable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnConfigurable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectConfigurationDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Ssh
    extends SvnConfigurable {
        public Ssh(@NotNull Project project) {
            if (project == null) {
                Ssh.$$$reportNull$$$0(0);
            }
            super(project, "SSH", SvnBundle.message("configurable.name.svn.ssh", new Object[0]), () -> new SshSettingsPanel(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Ssh", "<init>"));
        }
    }

    public static class Network
    extends SvnConfigurable {
        public Network(@NotNull Project project) {
            if (project == null) {
                Network.$$$reportNull$$$0(0);
            }
            super(project, "Network", SvnBundle.message("configurable.name.svn.network", new Object[0]), () -> new NetworkSettingsPanel(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Network", "<init>"));
        }
    }

    public static class Presentation
    extends SvnConfigurable {
        public Presentation(@NotNull Project project) {
            if (project == null) {
                Presentation.$$$reportNull$$$0(0);
            }
            super(project, "Presentation", SvnBundle.message("configurable.name.svn.presentation", new Object[0]), () -> new PresentationSettingsPanel(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$Presentation", "<init>"));
        }
    }

    public static class General
    extends SvnConfigurable {
        public General(@NotNull Project project) {
            if (project == null) {
                General.$$$reportNull$$$0(0);
            }
            super(project, SvnConfigurable.ID, General.getGroupDisplayName(), () -> new GeneralSettingsPanel(project), SvnConfigurable.HELP_ID);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnConfigurable$General", "<init>"));
        }
    }
}

