/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevDocumentationProvider;
import com.jetbrains.python.console.completion.PydevConsoleReference;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.documentation.PyRuntimeDocstringFormatter;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.sdk.PythonSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonRuntimeServiceImpl
extends PythonRuntimeService {
    @Override
    public boolean isInPydevConsole(@NotNull PsiElement file) {
        if (file == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(0);
        }
        return PydevConsoleRunner.isInPydevConsole(file);
    }

    @Override
    public boolean isInScratchFile(@NotNull PsiElement element) {
        if (element == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(1);
        }
        return ScratchUtil.isScratch((VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    @Override
    @Nullable
    public Sdk getConsoleSdk(@NotNull PsiElement foothold) {
        if (foothold == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(2);
        }
        return PydevConsoleRunner.getConsoleSdk(foothold);
    }

    @Override
    public String createPydevDoc(PsiElement element, PsiElement originalElement) {
        return PydevDocumentationProvider.createDoc(element, originalElement);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(3);
        }
        return languageLevel;
    }

    @Override
    public PsiPolyVariantReference getPydevConsoleReference(@NotNull PyReferenceExpression element, @NotNull PyResolveContext context2) {
        ConsoleCommunication communication;
        PsiFile file;
        if (element == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(5);
        }
        if ((file = element.getContainingFile()) != null && (communication = (ConsoleCommunication)file.getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY)) != null) {
            PyExpression qualifier = element.getQualifier();
            String prefix = qualifier == null ? "" : qualifier.getText() + ".";
            return new PydevConsoleReference(element, communication, prefix, context2.allowRemote());
        }
        return null;
    }

    @Override
    public PythonConsoleData getPythonConsoleData(@Nullable ASTNode node) {
        return PydevConsoleRunner.getPythonConsoleData(node);
    }

    @Override
    public String formatDocstring(Module module, DocStringFormat format, String docstring) {
        return PyRuntimeDocstringFormatter.runExternalTool(module, format, docstring);
    }

    @Override
    public String mapToRemote(@NotNull String localRoot, @NotNull Sdk sdk) {
        RemoteSdkAdditionalData remoteSdkData;
        if (localRoot == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(6);
        }
        if (sdk == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(7);
        }
        if ((remoteSdkData = PyUtil.as(sdk.getSdkAdditionalData(), RemoteSdkAdditionalData.class)) != null) {
            return remoteSdkData.getPathMappings().convertToRemote(localRoot);
        }
        return localRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonRuntimeServiceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonRuntimeServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInPydevConsole";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInScratchFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleSdk";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPydevConsoleReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mapToRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

