/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueDescriptor;
import com.jetbrains.python.debugger.PyDebugValueGroupsKt;
import com.jetbrains.python.debugger.PyDebuggerEvaluator;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStackFrame
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance(PyStackFrame.class);
    private static final Object STACK_FRAME_EQUALITY_OBJECT = new Object();
    public static final String DOUBLE_UNDERSCORE = "__";
    @NotNull
    @NonNls
    public static final Set<String> HIDE_TYPES = Set.of("function", "type", "classobj", "module");
    @NotNull
    @NonNls
    public static final Set<String> HIDE_MODULES = Set.of("typing");
    public static final int DUNDER_VALUES_IND = 0;
    public static final int SPECIAL_TYPES_IND = 1;
    public static final int IPYTHON_VALUES_IND = 2;
    public static final int NUMBER_OF_GROUPS = 3;
    @NotNull
    @NonNls
    public static final Set<String> COMPREHENSION_NAMES = Set.of("<genexpr>", "<listcomp>", "<dictcomp>", "<setcomp>");
    private final Project myProject;
    private final PyFrameAccessor myDebugProcess;
    private final PyStackFrameInfo myFrameInfo;
    private final XSourcePosition myPosition;
    @Nullable
    private Map<String, PyDebugValueDescriptor> myChildrenDescriptors;

    public PyStackFrame(@NotNull Project project, @NotNull PyFrameAccessor debugProcess, @NotNull PyStackFrameInfo frameInfo, XSourcePosition position) {
        if (project == null) {
            PyStackFrame.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            PyStackFrame.$$$reportNull$$$0(1);
        }
        if (frameInfo == null) {
            PyStackFrame.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDebugProcess = debugProcess;
        this.myFrameInfo = frameInfo;
        this.myPosition = position;
    }

    public Object getEqualityObject() {
        return STACK_FRAME_EQUALITY_OBJECT;
    }

    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    public XDebuggerEvaluator getEvaluator() {
        return new PyDebuggerEvaluator(this.myProject, this.myDebugProcess);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            PyStackFrame.$$$reportNull$$$0(3);
        }
        component.setIcon(AllIcons.Debugger.Frame);
        if (this.myPosition == null) {
            component.append(PyBundle.message("debugger.stack.frame.frame.not.available", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
            return;
        }
        VirtualFile file = this.myPosition.getFile();
        boolean isExternal = (Boolean)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null) {
                return !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(file);
            }
            return true;
        });
        component.append(this.myFrameInfo.getName(), PyStackFrame.gray(isExternal));
        component.append(", ", PyStackFrame.gray(isExternal));
        component.append(this.myPosition.getFile().getName(), PyStackFrame.gray(isExternal));
        component.append(":", PyStackFrame.gray(isExternal));
        component.append(Integer.toString(this.myPosition.getLine() + 1), PyStackFrame.gray(isExternal));
    }

    protected static SimpleTextAttributes gray(boolean gray) {
        return gray ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(4);
        }
        if (node.isObsolete()) {
            return;
        }
        this.myDebugProcess.setCurrentRootNode(node);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                boolean cached = this.myDebugProcess.isFrameCached(this);
                XValueChildrenList values = this.myDebugProcess.loadFrame(this);
                if (!node.isObsolete()) {
                    this.addChildren(node, values);
                }
                if (values != null && !cached) {
                    PyDebugValue.getAsyncValues(this, this.myDebugProcess, values);
                }
            }
            catch (PyDebuggerException e) {
                if (!node.isObsolete()) {
                    node.setErrorMessage(PyBundle.message("debugger.stack.frame.unable.to.display.frame.variables", new Object[0]));
                }
                LOG.warn((Throwable)e);
            }
        });
    }

    protected void addChildren(@NotNull XCompositeNode node, @Nullable XValueChildrenList children2) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(5);
        }
        if (children2 == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
        XValueChildrenList filteredChildren = new XValueChildrenList();
        HashMap<String, XValue> returnedValues = new HashMap<String, XValue>();
        ArrayList<Map<String, XValue>> specialValuesGroups = new ArrayList<Map<String, XValue>>();
        IntStream.range(0, 3).mapToObj(i -> new HashMap()).forEach(specialValuesGroups::add);
        boolean isSpecialEmpty = true;
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            XValue value = children2.getValue(i2);
            String name = children2.getName(i2);
            if (!(value instanceof PyDebugValue)) continue;
            PyDebugValue pyValue = (PyDebugValue)value;
            this.restoreValueDescriptor(pyValue);
            if (pyValue.isReturnedVal() && debuggerSettings.isWatchReturnValues()) {
                returnedValues.put(name, value);
                continue;
            }
            if (!debuggerSettings.isSimplifiedView()) {
                filteredChildren.add(name, value);
                continue;
            }
            int groupIndex = -1;
            if (name.startsWith(DOUBLE_UNDERSCORE) && name.endsWith(DOUBLE_UNDERSCORE) && name.length() > 4 && !name.equals("__exception__")) {
                groupIndex = 0;
            } else if (pyValue.isIPythonHidden()) {
                groupIndex = 2;
            } else if (HIDE_TYPES.contains(pyValue.getType()) || HIDE_MODULES.contains(pyValue.getTypeQualifier())) {
                groupIndex = 1;
            }
            if (groupIndex > -1) {
                specialValuesGroups.get(groupIndex).put(name, value);
                isSpecialEmpty = false;
                continue;
            }
            filteredChildren.add(name, value);
        }
        node.addChildren(filteredChildren, returnedValues.isEmpty() && isSpecialEmpty);
        if (!returnedValues.isEmpty()) {
            PyDebugValueGroupsKt.addGroupValues(PyBundle.message("debugger.stack.frame.return.values", new Object[0]), AllIcons.Debugger.WatchLastReturnValue, node, returnedValues, "()");
        }
        if (!isSpecialEmpty) {
            Map<String, XValue> specialElements = PyStackFrame.mergeSpecialGroupElementsOrdered(specialValuesGroups);
            PyDebugValueGroupsKt.addGroupValues(PyBundle.message("debugger.stack.frame.special.variables", new Object[0]), PythonIcons.Python.Debug.SpecialVar, node, specialElements, null);
        }
    }

    private static Map<String, XValue> mergeSpecialGroupElementsOrdered(List<Map<String, XValue>> specialValuesGroups) {
        LinkedHashMap<String, XValue> result = new LinkedHashMap<String, XValue>();
        for (Map<String, XValue> group2 : specialValuesGroups) {
            result.putAll(group2);
        }
        return result;
    }

    public String getThreadId() {
        return this.myFrameInfo.getThreadId();
    }

    public String getFrameId() {
        return this.myFrameInfo.getId();
    }

    public String getThreadFrameId() {
        return this.myFrameInfo.getThreadId() + ":" + this.myFrameInfo.getId();
    }

    protected XSourcePosition getPosition() {
        return this.myPosition;
    }

    @NotNull
    public String getName() {
        String string = this.myFrameInfo.getName();
        if (string == null) {
            PyStackFrame.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isComprehension() {
        return COMPREHENSION_NAMES.contains(this.getName());
    }

    public void setChildrenDescriptors(@Nullable Map<String, PyDebugValueDescriptor> childrenDescriptors) {
        this.myChildrenDescriptors = childrenDescriptors;
    }

    public void restoreChildrenDescriptors(@NotNull Map<String, Map<String, PyDebugValueDescriptor>> descriptorsCache) {
        if (descriptorsCache == null) {
            PyStackFrame.$$$reportNull$$$0(7);
        }
        String threadFrameId = this.getThreadFrameId();
        Map<String, PyDebugValueDescriptor> childrenDescriptors = descriptorsCache.getOrDefault(threadFrameId, Maps.newHashMap());
        this.setChildrenDescriptors(childrenDescriptors);
        descriptorsCache.put(threadFrameId, childrenDescriptors);
    }

    private void restoreValueDescriptor(PyDebugValue value) {
        if (this.myChildrenDescriptors != null) {
            PyDebugValueDescriptor descriptor2 = this.myChildrenDescriptors.getOrDefault(value.getName(), null);
            if (descriptor2 == null) {
                descriptor2 = new PyDebugValueDescriptor();
                this.myChildrenDescriptors.put(value.getName(), descriptor2);
            }
            value.setDescriptor(descriptor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyStackFrame";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyStackFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restoreChildrenDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

