/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ift;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.ift.PythonLessonsBundle;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectVirtualEnvConfiguration;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002J\u001c\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010\u000eH\u0016J=\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00102!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u00170'H\u0016J\u001e\u0010+\u001a\u00020\u00172\u0014\u0010,\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00170'H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006-"}, d2={"Lcom/jetbrains/python/ift/PythonBasedLangSupport;", "Ltraining/lang/AbstractLangSupport;", "()V", "langCourseFeedback", "", "getLangCourseFeedback", "()Ljava/lang/String;", "projectSandboxRelativePath", "getProjectSandboxRelativePath", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "applyBaseSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "preferredSdk", "existingSdks", "", "module", "Lcom/intellij/openapi/module/Module;", "applyProjectSdk", "", "sdk", "blockProjectFileModification", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkSdk", "createVenv", "getExistingSdks", "getSdkForProject", "selectedSdk", "installAndOpenLearningProject", "contentRoot", "Ljava/nio/file/Path;", "projectToClose", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "startFromWelcomeFrame", "startCallback", "intellij.python.featuresTrainer"})
public abstract class PythonBasedLangSupport
extends AbstractLangSupport {
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator();
    @NotNull
    private final String projectSandboxRelativePath;

    @Nullable
    public String getLangCourseFeedback() {
        return UtilsKt.getFeedbackLink((LangSupport)((LangSupport)this), (boolean)false);
    }

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    public void installAndOpenLearningProject(@NotNull Path contentRoot, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        OpenProjectTask openProjectTask = new OpenProjectTask(false, projectToClose, false, false, null, null, false, null, null, 0, 0, false, false, false, null, true, false, null, null, null, 1015805, null);
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(contentRoot, (LangSupport)this, openProjectTask, postInitCallback);
    }

    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (selectedSdk != null) {
            Object[] objectArray = PyStatisticToolsKt.getModules(project);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
            Module module = (Module)ArraysKt.first((Object[])objectArray);
            List<Sdk> existingSdks2 = this.getExistingSdks();
            return this.applyBaseSdk(project, selectedSdk, existingSdks2, module);
        }
        if (PySdkExtKt.getPythonSdk(project) != null) {
            return null;
        }
        return this.createVenv(project);
    }

    private final Sdk createVenv(Project project) {
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Module module = (Module)ArraysKt.first((Object[])objectArray);
        List<Sdk> existingSdks2 = this.getExistingSdks();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks2, module, (UserDataHolder)project);
        Sdk preferredSdk = PyProjectVirtualEnvConfiguration.INSTANCE.findPreferredVirtualEnvBaseSdk(baseSdks);
        return this.applyBaseSdk(project, preferredSdk, existingSdks2, module);
    }

    private final Sdk applyBaseSdk(Project project, Sdk preferredSdk, List<? extends Sdk> existingSdks2, Module module) {
        Sdk sdk;
        Sdk venvSdk;
        String string = FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(project.getBasePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDepende\u2026sePath(project.basePath))");
        String venvRoot = string;
        Sdk sdk2 = venvSdk = PyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously$default(PyProjectVirtualEnvConfiguration.INSTANCE, preferredSdk, existingSdks2, venvRoot, project.getBasePath(), project, module, (UserDataHolder)project, false, false, 384, null);
        if (sdk2 != null) {
            Sdk sdk3 = sdk2;
            boolean bl = false;
            boolean bl2 = false;
            Sdk it = sdk3;
            boolean bl3 = false;
            SdkConfigurationUtil.addSdk((Sdk)it);
            sdk = sdk3;
        } else {
            sdk = null;
        }
        return sdk;
    }

    public void applyProjectSdk(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Object object = ArraysKt.first((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.modules.first()");
        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, (Module)object, sdk);
    }

    private final List<Sdk> getExistingSdks() {
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        List<Sdk> list = pyConfigurableInterpreterList.getAllPythonSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"PyConfigurableInterprete\u2026tance(null).allPythonSdks");
        Iterable iterable = list;
        PreferredSdkComparator preferredSdkComparator = PreferredSdkComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)preferredSdkComparator, (String)"PreferredSdkComparator.INSTANCE");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)preferredSdkComparator);
    }

    public void checkSdk(@Nullable Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public boolean blockProjectFileModification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)this.getProjectSandboxRelativePath()) ^ true;
    }

    @NotNull
    public String getProjectSandboxRelativePath() {
        return this.projectSandboxRelativePath;
    }

    public void startFromWelcomeFrame(@NotNull Function1<? super Sdk, Unit> startCallback) {
        Intrinsics.checkNotNullParameter(startCallback, (String)"startCallback");
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        ProjectSdksModel projectSdksModel = pyConfigurableInterpreterList.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)projectSdksModel, (String)"PyConfigurableInterprete\u2026t.getInstance(null).model");
        Sdk[] sdkArray = projectSdksModel.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"PyConfigurableInterprete\u2026Instance(null).model.sdks");
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray, sdkArray.length));
        List<Sdk> list = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"ProjectSpecificSettingsS\u2026thonSdks(allExistingSdks)");
        List<Sdk> existingSdks2 = list;
        UserDataHolderBase context2 = new UserDataHolderBase();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks2, null, (UserDataHolder)context2);
        if (baseSdks.isEmpty()) {
            JPanel formPanel;
            PySdkPathChoosingComboBox baseSdkField = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
            JLabel warningPlaceholder = new JLabel();
            FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)warningPlaceholder).addLabeledComponent(PySdkBundle.message("python.venv.base.label", new Object[0]), (JComponent)((Object)baseSdkField));
            Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026se.label\"), baseSdkField)");
            JPanel jPanel = formPanel = formBuilder.getPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"formPanel");
            int n = formPanel.getPreferredSize().width;
            int n2 = 500;
            boolean bl = false;
            jPanel.setPreferredSize(new Dimension(Math.max(n, n2), formPanel.getPreferredSize().height));
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            DialogWrapper dialog2 = new DialogWrapper(formPanel, projectManager.getDefaultProject()){
                final /* synthetic */ JPanel $formPanel;

                @NotNull
                protected JComponent createCenterPanel() {
                    JPanel jPanel = this.$formPanel;
                    Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"formPanel");
                    return jPanel;
                }
                {
                    this.$formPanel = $captured_local_variable$0;
                    super($super_call_param$1);
                    this.setTitle(PyBundle.message("sdk.select.path", new Object[0]));
                    this.init();
                }
            };
            PyAddSdkPanelKt.addBaseInterpretersAsync(baseSdkField, existingSdks2, null, (UserDataHolder)context2, (Function0<Unit>)((Function0)new Function0<Unit>(baseSdkField, warningPlaceholder){
                final /* synthetic */ PySdkPathChoosingComboBox $baseSdkField;
                final /* synthetic */ JLabel $warningPlaceholder;

                public final void invoke() {
                    Sdk selectedSdk = this.$baseSdkField.getSelectedSdk();
                    if (selectedSdk instanceof PySdkToInstall) {
                        PySdkToInstall pySdkToInstall = (PySdkToInstall)selectedSdk;
                        String string = Messages.getOkButton();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Messages.getOkButton()");
                        String installationWarning = pySdkToInstall.getInstallationWarning(string);
                        this.$warningPlaceholder.setText("<html>" + installationWarning + "</html>");
                    } else {
                        this.$warningPlaceholder.setText("");
                    }
                }
                {
                    this.$baseSdkField = pySdkPathChoosingComboBox;
                    this.$warningPlaceholder = jLabel;
                    super(0);
                }
            }));
            dialog2.setTitle(PythonLessonsBundle.INSTANCE.message("choose.python.sdk.to.start.learning.header", new Object[0]));
            if (dialog2.showAndGet()) {
                Sdk selectedSdk = baseSdkField.getSelectedSdk();
                if (selectedSdk == null) {
                    return;
                }
                startCallback.invoke((Object)selectedSdk);
            }
        } else {
            startCallback.invoke(null);
        }
    }

    public PythonBasedLangSupport() {
        this.projectSandboxRelativePath = "src/sandbox.py";
    }
}

