/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PlainDocString;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Substring;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocstringTypesInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyDocstringTypesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyDocstringTypesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyDocstringTypesInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ChangeTypeQuickFix
    implements LocalQuickFix {
        private final String myParamName;
        private final Substring myTypeSubstring;
        private final String myNewType;
        private final SmartPsiElementPointer<PyStringLiteralExpression> myStringLiteralExpression;

        private ChangeTypeQuickFix(String name, Substring substring, String type, PyStringLiteralExpression expression) {
            this.myParamName = name;
            this.myTypeSubstring = substring;
            this.myNewType = type;
            this.myStringLiteralExpression = SmartPointerManager.createPointer((PsiElement)expression);
        }

        @NotNull
        public String getName() {
            String string = PyPsiBundle.message("INSP.docstring.types.change.type", this.myParamName, this.myTypeSubstring.getValue(), this.myNewType);
            if (string == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.docstring.types.fix.docstring", new Object[0]);
            if (string == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(3);
            }
            String newValue = this.myTypeSubstring.getTextRange().replace(this.myTypeSubstring.getSuperString(), this.myNewType);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            PyStringLiteralExpression stringLiteralExpression = (PyStringLiteralExpression)this.myStringLiteralExpression.getElement();
            if (stringLiteralExpression != null) {
                stringLiteralExpression.replace((PsiElement)elementGenerator.createDocstring(newValue).getExpression());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction function) {
            String name;
            if (function == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((name = function.getName()) != null && !name.startsWith("_")) {
                this.checkDocString(function);
            }
        }

        private void checkDocString(@NotNull PyFunction function) {
            PySignature signature;
            PySignatureCacheManager manager;
            PyStringLiteralExpression docStringExpression;
            if (function == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((docStringExpression = function.getDocStringExpression()) != null && (manager = PySignatureCacheManager.getInstance(function.getProject())) != null && (signature = manager.findSignature(function)) != null) {
                this.checkParameters(function, docStringExpression, signature);
            }
        }

        private void checkParameters(PyFunction function, PyStringLiteralExpression node, PySignature signature) {
            StructuredDocString docString = DocStringUtil.parseDocString(node);
            if (docString instanceof PlainDocString) {
                return;
            }
            for (String param : docString.getParameters()) {
                String dynamicType;
                @NlsSafe Substring type = docString.getParamTypeSubstring(param);
                if (type == null || (dynamicType = signature.getArgTypeQualifiedName(param)) == null) continue;
                @NlsSafe String dynamicTypeShortName = this.getShortestImportableName(function, dynamicType);
                if (this.match(function, dynamicType, type.getValue())) continue;
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.docstring.types.dynamically.inferred.type.does.not.match.specified.type", dynamicTypeShortName, type), ProblemHighlightType.WEAK_WARNING, null, type.getTextRange(), new ChangeTypeQuickFix(param, type, dynamicTypeShortName, node));
            }
        }

        @Nullable
        private String getShortestImportableName(@Nullable PsiElement anchor, @NotNull String type) {
            PyType pyType;
            if (type == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((pyType = PyTypeParser.getTypeByName(anchor, type, this.myTypeEvalContext)) instanceof PyClassType) {
                return ((PyClassType)pyType).getPyClass().getQualifiedName();
            }
            if (pyType != null) {
                return Visitor.getPrintableName(pyType);
            }
            return type;
        }

        @Nullable
        private static String getPrintableName(@Nullable PyType type) {
            if (type instanceof PyUnionType) {
                return StreamEx.of(((PyUnionType)type).getMembers()).map(Visitor::getPrintableName).joining((CharSequence)" or ");
            }
            if (type != null) {
                return type.getName();
            }
            return "Any";
        }

        private boolean match(PsiElement anchor, String dynamicTypeName, String specifiedTypeName) {
            PyType dynamicType = PyTypeParser.getTypeByName(anchor, dynamicTypeName, this.myTypeEvalContext);
            PyType specifiedType = PyTypeParser.getTypeByName(anchor, specifiedTypeName, this.myTypeEvalContext);
            return PyTypeChecker.match(specifiedType, dynamicType, this.myTypeEvalContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyDocstringTypesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkDocString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getShortestImportableName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

