/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PyShadowingBuiltinsInspection
extends PyInspection {
    public List<String> ignoredNames = new ArrayList<String>();

    @NotNull
    protected LocalQuickFix[] createQuickFixes(String name, PsiElement problemElement) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        LocalQuickFix qf = PythonUiService.getInstance().createPyRenameElementQuickFix(problemElement);
        if (qf != null) {
            fixes.add(qf);
        }
        fixes.add(new PyIgnoreBuiltinQuickFix(name));
        LocalQuickFix[] localQuickFixArray = fixes.toArray(new LocalQuickFix[fixes.size()]);
        if (localQuickFixArray == null) {
            PyShadowingBuiltinsInspection.$$$reportNull$$$0(0);
        }
        return localQuickFixArray;
    }

    public JComponent createOptionsPanel() {
        return PythonUiService.getInstance().createListEditForm(PyPsiBundle.message("INSP.shadowing.builtins.column.name.ignore.built.ins", new Object[0]), PyPsiBundle.message("INSP.shadowing.builtins.ignore.built.ins.label", new Object[0]), this.ignoredNames);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyShadowingBuiltinsInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyShadowingBuiltinsInspection.$$$reportNull$$$0(2);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session), this.ignoredNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickFixes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredNames;

        Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context2, Collection<String> ignoredNames) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (ignoredNames == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, context2);
            this.myIgnoredNames = ImmutableSet.copyOf(ignoredNames);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (!node.isQualified()) {
                this.processElement(node);
            }
        }

        private void processElement(@NotNull PsiNameIdentifierOwner element) {
            PyBuiltinCache builtinCache;
            PsiElement builtin;
            ScopeOwner owner;
            if (element == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if ((owner = ScopeUtil.getScopeOwner((PsiElement)element)) instanceof PyClass) {
                return;
            }
            String name = element.getName();
            if (name != null && !this.myIgnoredNames.contains(name) && (builtin = (builtinCache = PyBuiltinCache.getInstance((PsiElement)element)).getByName(name)) != null && !PyUtil.inSameFile(builtin, (PsiElement)element)) {
                PsiElement identifier = element.getNameIdentifier();
                PsiElement problemElement = identifier != null ? identifier : element;
                this.registerProblem(problemElement, PyPsiBundle.message("INSP.shadowing.builtins.shadows.built.in.name", name), ProblemHighlightType.WEAK_WARNING, null, PyShadowingBuiltinsInspection.this.createQuickFixes(name, problemElement));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredNames";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNamedParameter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PyIgnoreBuiltinQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        @NotNull
        @NlsSafe
        private final String myName;

        private PyIgnoreBuiltinQuickFix(@NotNull String name) {
            if (name == null) {
                PyIgnoreBuiltinQuickFix.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = PyPsiBundle.message("QFIX.ignore.shadowed.built.in.name", this.myName);
            if (string == null) {
                PyIgnoreBuiltinQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.NAME.ignore.shadowed.built.in.name", new Object[0]);
            if (string == null) {
                PyIgnoreBuiltinQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                PyIgnoreBuiltinQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                PyIgnoreBuiltinQuickFix.$$$reportNull$$$0(4);
            }
            if ((element = descriptor2.getPsiElement()) != null) {
                InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
                    String toolName = PyShadowingBuiltinsInspection.class.getSimpleName();
                    PyShadowingBuiltinsInspection inspection = (PyShadowingBuiltinsInspection)it.getUnwrappedTool(toolName, element);
                    if (inspection != null && !inspection.ignoredNames.contains(this.myName)) {
                        inspection.ignoredNames.add(this.myName);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$PyIgnoreBuiltinQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$PyIgnoreBuiltinQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

