/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyJavaPackageType
implements PyType {
    private final PsiPackage myPackage;
    @Nullable
    private final Module myModule;

    public PyJavaPackageType(PsiPackage aPackage, @Nullable Module module) {
        this.myPackage = aPackage;
        this.myModule = module;
    }

    @Override
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PsiClass[] classes;
        if (name == null) {
            PyJavaPackageType.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            PyJavaPackageType.$$$reportNull$$$0(1);
        }
        if (resolveContext == null) {
            PyJavaPackageType.$$$reportNull$$$0(2);
        }
        Project project = this.myPackage.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        String childName = this.myPackage.getQualifiedName() + "." + name;
        GlobalSearchScope scope = this.getScope(project);
        ResolveResultList result = new ResolveResultList();
        for (PsiClass aClass : classes = facade.findClasses(childName, scope)) {
            result.poke((PsiElement)aClass, 0);
        }
        PsiPackage psiPackage = facade.findPackage(childName);
        if (psiPackage != null) {
            result.poke((PsiElement)psiPackage, 0);
        }
        return result;
    }

    private GlobalSearchScope getScope(Project project) {
        return this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(false) : ProjectScope.getAllScope((Project)project);
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context2) {
        PsiPackage[] subPackages;
        PsiClass[] classes;
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
        GlobalSearchScope scope = this.getScope(location.getProject());
        for (PsiClass psiClass : classes = this.myPackage.getClasses(scope)) {
            variants.add(LookupElementBuilder.create((PsiNamedElement)psiClass).withIcon(psiClass.getIcon(0)));
        }
        for (PsiPackage subPackage : subPackages = this.myPackage.getSubPackages(scope)) {
            variants.add(LookupElementBuilder.create((PsiNamedElement)subPackage).withIcon(subPackage.getIcon(0)));
        }
        return ArrayUtil.toObjectArray(variants);
    }

    @Override
    public String getName() {
        return this.myPackage.getQualifiedName();
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "direction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "resolveContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/psi/impl/PyJavaPackageType";
        objectArray[2] = "resolveMember";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

