/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyClassStubImpl;
import com.jetbrains.python.psi.impl.stubs.PyCustomClassStub;
import com.jetbrains.python.psi.impl.stubs.PyCustomClassStubType;
import com.jetbrains.python.psi.impl.stubs.PyCustomizableStubElementType;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.stubs.PyClassAttributesIndex;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyClassNameIndexInsensitive;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyExportedModuleAttributeIndex;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.stubs.PySuperClassIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassElementType
extends PyStubElementType<PyClassStub, PyClass>
implements PyCustomizableStubElementType<PyClass, PyCustomClassStub, PyCustomClassStubType<? extends PyCustomClassStub>> {
    public PyClassElementType() {
        this("CLASS_DECLARATION");
    }

    public PyClassElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            PyClassElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            PyClassElementType.$$$reportNull$$$0(1);
        }
        return new PyClassImpl(node);
    }

    public PyClass createPsi(@NotNull PyClassStub stub) {
        if (stub == null) {
            PyClassElementType.$$$reportNull$$$0(2);
        }
        return new PyClassImpl(stub);
    }

    @NotNull
    public PyClassStub createStub(@NotNull PyClass psi, StubElement parentStub) {
        if (psi == null) {
            PyClassElementType.$$$reportNull$$$0(3);
        }
        return new PyClassStubImpl(psi.getName(), parentStub, PyClassElementType.getSuperClassQNames(psi), ContainerUtil.map((Object[])psi.getSuperClassExpressions(), PsiElement::getText), PyPsiUtils.asQualifiedName(psi.getMetaClassExpression()), psi.getOwnSlots(), PyPsiUtils.strValue(psi.getDocStringExpression()), this.getStubElementType(), (PyCustomClassStub)this.createCustomStub(psi));
    }

    @NotNull
    public static Map<QualifiedName, QualifiedName> getSuperClassQNames(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyClassElementType.$$$reportNull$$$0(4);
        }
        LinkedHashMap<QualifiedName, QualifiedName> result = new LinkedHashMap<QualifiedName, QualifiedName>();
        for (PyExpression expression : PyClassImpl.getUnfoldedSuperClassExpressions(pyClass)) {
            QualifiedName importedQName = PyPsiUtils.asQualifiedName(expression);
            QualifiedName originalQName = PyClassElementType.resolveOriginalSuperClassQName(expression);
            result.put(importedQName, originalQName);
        }
        LinkedHashMap<QualifiedName, QualifiedName> linkedHashMap = result;
        if (linkedHashMap == null) {
            PyClassElementType.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    @NotNull
    private static List<PySubscriptionExpression> getSubscriptedSuperClasses(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyClassElementType.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.mapNotNull((Object[])pyClass.getSuperClassExpressions(), x -> PyUtil.as(x, PySubscriptionExpression.class));
        if (list == null) {
            PyClassElementType.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<PySubscriptionExpression> getSubscriptedSuperClassesStubLike(@NotNull PyClass pyClass) {
        PyClassStub classStub;
        if (pyClass == null) {
            PyClassElementType.$$$reportNull$$$0(8);
        }
        if ((classStub = (PyClassStub)pyClass.getStub()) == null) {
            return PyClassElementType.getSubscriptedSuperClasses(pyClass);
        }
        List list = ContainerUtil.mapNotNull(classStub.getSuperClassesText(), x -> PyUtil.as(PyUtil.createExpressionFromFragment(x, (PsiElement)pyClass.getContainingFile()), PySubscriptionExpression.class));
        if (list == null) {
            PyClassElementType.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static QualifiedName resolveOriginalSuperClassQName(@NotNull PyExpression superClassExpression) {
        if (superClassExpression == null) {
            PyClassElementType.$$$reportNull$$$0(10);
        }
        if (superClassExpression instanceof PyReferenceExpression) {
            PyReferenceExpression reference = (PyReferenceExpression)superClassExpression;
            String referenceName = reference.getName();
            if (referenceName == null) {
                return PyPsiUtils.asQualifiedName(superClassExpression);
            }
            Optional qualifiedName = ((StreamEx)StreamEx.of(PyResolveUtil.resolveLocally(reference)).select(PyImportElement.class).filter(element -> element.getAsName() != null)).map(PyImportElement::getImportedQName).findAny(Objects::nonNull);
            if (qualifiedName.isPresent()) {
                return (QualifiedName)qualifiedName.get();
            }
        }
        return PyPsiUtils.asQualifiedName(superClassExpression);
    }

    public void serialize(@NotNull PyClassStub pyClassStub, @NotNull StubOutputStream dataStream) throws IOException {
        if (pyClassStub == null) {
            PyClassElementType.$$$reportNull$$$0(11);
        }
        if (dataStream == null) {
            PyClassElementType.$$$reportNull$$$0(12);
        }
        dataStream.writeName(pyClassStub.getName());
        Map<QualifiedName, QualifiedName> superClasses = pyClassStub.getSuperClasses();
        dataStream.writeByte(superClasses.size());
        for (Map.Entry<QualifiedName, QualifiedName> entry : superClasses.entrySet()) {
            QualifiedName.serialize((QualifiedName)entry.getKey(), (StubOutputStream)dataStream);
            QualifiedName.serialize((QualifiedName)entry.getValue(), (StubOutputStream)dataStream);
        }
        List<String> baseClassesText = pyClassStub.getSuperClassesText();
        dataStream.writeByte(baseClassesText.size());
        for (String text2 : baseClassesText) {
            dataStream.writeName(text2);
        }
        QualifiedName.serialize((QualifiedName)pyClassStub.getMetaClass(), (StubOutputStream)dataStream);
        PyFileElementType.writeNullableList(dataStream, pyClassStub.getSlots());
        String string = pyClassStub.getDocString();
        dataStream.writeUTFFast(string != null ? string : "");
        this.serializeCustomStub(pyClassStub.getCustomStub(PyCustomClassStub.class), dataStream);
    }

    @NotNull
    public PyClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PyClassElementType.$$$reportNull$$$0(13);
        }
        String name = dataStream.readNameString();
        int superClassCount = dataStream.readByte();
        LinkedHashMap<QualifiedName, QualifiedName> superClasses = new LinkedHashMap<QualifiedName, QualifiedName>();
        for (int i = 0; i < superClassCount; ++i) {
            superClasses.put(QualifiedName.deserialize((StubInputStream)dataStream), QualifiedName.deserialize((StubInputStream)dataStream));
        }
        int baseClassesCount = dataStream.readByte();
        ArrayList<String> baseClassesText = new ArrayList<String>();
        for (int i = 0; i < baseClassesCount; ++i) {
            baseClassesText.add(dataStream.readNameString());
        }
        QualifiedName metaClass = QualifiedName.deserialize((StubInputStream)dataStream);
        List<String> slots = PyFileElementType.readNullableList(dataStream);
        String docStringInStub = dataStream.readUTFFast();
        String docString = docStringInStub.length() > 0 ? docStringInStub : null;
        PyCustomClassStub customStub = (PyCustomClassStub)this.deserializeCustomStub(dataStream);
        return new PyClassStubImpl(name, parentStub, superClasses, baseClassesText, metaClass, slots, docString, this.getStubElementType(), customStub);
    }

    @Override
    public void indexStub(@NotNull PyClassStub stub, @NotNull IndexSink sink) {
        String name;
        if (stub == null) {
            PyClassElementType.$$$reportNull$$$0(14);
        }
        if (sink == null) {
            PyClassElementType.$$$reportNull$$$0(15);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(PyClassNameIndex.KEY, (Object)name);
            sink.occurrence(PyClassNameIndexInsensitive.KEY, (Object)StringUtil.toLowerCase((String)name));
            if (stub.getParentStub() instanceof PyFileStub && PyUtil.getInitialUnderscores(name) == 0) {
                sink.occurrence(PyExportedModuleAttributeIndex.KEY, (Object)name);
            }
        }
        for (String attribute : PyClassAttributesIndex.getAllDeclaredAttributeNames((PyClass)stub.getPsi())) {
            sink.occurrence(PyClassAttributesIndex.KEY, (Object)attribute);
        }
        stub.getSuperClasses().values().stream().filter(Objects::nonNull).map(QualifiedName::getLastComponent).filter(Objects::nonNull).forEach(className -> sink.occurrence(PySuperClassIndex.KEY, className));
    }

    @NotNull
    protected IStubElementType getStubElementType() {
        PyStubElementType<PyClassStub, PyClass> pyStubElementType = PyElementTypes.CLASS_DECLARATION;
        if (pyStubElementType == null) {
            PyClassElementType.$$$reportNull$$$0(16);
        }
        return pyStubElementType;
    }

    @Override
    @NotNull
    public List<PyCustomClassStubType<? extends PyCustomClassStub>> getExtensions() {
        List list = PyCustomClassStubType.EP_NAME.getExtensionList();
        if (list == null) {
            PyClassElementType.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/stubs/PyClassElementType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClassStub";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyClassElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassQNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubscriptedSuperClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubscriptedSuperClassesStubLike";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubElementType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassQNames";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubscriptedSuperClasses";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSubscriptedSuperClassesStubLike";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveOriginalSuperClassQName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

