/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyParamSpecType
implements PyType {
    @NotNull
    private final String myName;
    @Nullable
    private final PyTargetExpression myTargetExpression;
    @Nullable
    private final List<PyCallableParameter> myParameters;

    public PyParamSpecType(@NotNull String name) {
        if (name == null) {
            PyParamSpecType.$$$reportNull$$$0(0);
        }
        this(name, null, null);
    }

    private PyParamSpecType(@NotNull String name, @Nullable PyTargetExpression target, @Nullable List<PyCallableParameter> parameters) {
        if (name == null) {
            PyParamSpecType.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myTargetExpression = target;
        this.myParameters = parameters;
    }

    @NotNull
    public PyParamSpecType withParameters(@Nullable List<PyCallableParameter> parameters, @NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyParamSpecType.$$$reportNull$$$0(2);
        }
        return new PyParamSpecType(this.myName, this.myTargetExpression, PyParamSpecType.getNamelessParameters(parameters, context2));
    }

    @NotNull
    public PyParamSpecType withTargetExpression(@Nullable PyTargetExpression target) {
        return new PyParamSpecType(this.myName, target, this.myParameters);
    }

    @Nullable
    private static List<PyCallableParameter> getNamelessParameters(@Nullable List<PyCallableParameter> parameters, @NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyParamSpecType.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            return null;
        }
        return ContainerUtil.map(parameters, it -> {
            if (it.isPositionalContainer()) {
                return PyCallableParameterImpl.positionalNonPsi(null, it.getType(context2));
            }
            if (it.isKeywordContainer()) {
                return PyCallableParameterImpl.keywordNonPsi(null, it.getType(context2));
            }
            return PyCallableParameterImpl.nonPsi(it.getType(context2));
        });
    }

    @Nullable
    public List<PyCallableParameter> getParameters() {
        return this.myParameters;
    }

    @Override
    @Nullable
    public PyTargetExpression getDeclarationElement() {
        return this.myTargetExpression;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyParamSpecType.$$$reportNull$$$0(4);
        }
        if (direction == null) {
            PyParamSpecType.$$$reportNull$$$0(5);
        }
        if (resolveContext == null) {
            PyParamSpecType.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context2) {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myParameters == null) {
            String string = String.format("ParamSpec(\"%s\")", this.myName);
            if (string == null) {
                PyParamSpecType.$$$reportNull$$$0(7);
            }
            return string;
        }
        TypeEvalContext context2 = TypeEvalContext.codeInsightFallback(null);
        String string = String.format("[%s]", StringUtil.join(this.myParameters, param -> {
            if (param != null) {
                StringBuilder builder = new StringBuilder();
                PyType type = param.getType(context2);
                builder.append(type != null ? type.getName() : "Any");
                return builder.toString();
            }
            return "Any";
        }, (String)", "));
        if (string == null) {
            PyParamSpecType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyParamSpecType type = (PyParamSpecType)o;
        return this.myName.equals(type.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyParamSpecType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyParamSpecType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNamelessParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

