/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.NameSuggesterUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import com.jetbrains.python.refactoring.introduce.PyIntroduceDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandler
implements RefactoringActionHandler {
    private final IntroduceValidator myValidator;
    @NlsContexts.DialogTitle
    protected final String myDialogTitle;

    protected static PsiElement findAnchor(List<? extends PsiElement> occurrences) {
        PyStatement statement;
        Object anchor = occurrences.get(0);
        Pair data = (Pair)anchor.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (data != null && occurrences.size() == 1) {
            return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)data.getFirst()), PyStatement.class);
        }
        block0: while ((statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatement.class)) != null) {
            PsiElement parent = statement.getParent();
            for (PsiElement psiElement : occurrences) {
                if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)psiElement, (boolean)true)) continue;
                anchor = statement;
                continue block0;
            }
        }
        return statement;
    }

    protected static void ensureName(IntroduceOperation operation) {
        if (operation.getName() == null) {
            Collection<String> suggestedNames = operation.getSuggestedNames();
            if (suggestedNames.size() > 0) {
                operation.setName(suggestedNames.iterator().next());
            } else {
                operation.setName("x");
            }
        }
    }

    @Nullable
    protected static PsiElement findOccurrenceUnderCaret(List<? extends PsiElement> occurrences, Editor editor2) {
        if (occurrences.isEmpty()) {
            return null;
        }
        int offset = editor2.getCaretModel().getOffset();
        for (PsiElement iterator : occurrences) {
            if (iterator == null || !iterator.getTextRange().contains(offset)) continue;
            return iterator;
        }
        int line2 = editor2.getDocument().getLineNumber(offset);
        for (PsiElement psiElement : occurrences) {
            PyPsiUtils.assertValid(psiElement);
            if (!psiElement.isValid() || editor2.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset()) != line2) continue;
            return psiElement;
        }
        Iterator<? extends PsiElement> iterator = occurrences.iterator();
        if (iterator.hasNext()) {
            PsiElement psiElement = iterator.next();
            PyPsiUtils.assertValid(psiElement);
            return psiElement;
        }
        return null;
    }

    @Nullable
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        PyExpressionStatement statement = (PyExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PyExpressionStatement.class);
        if (statement != null && statement.getExpression() == expression && expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE) == null) {
            statement.delete();
            return null;
        }
        return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
    }

    protected IntroduceHandler(@NotNull IntroduceValidator validator, @NotNull @NlsContexts.DialogTitle String dialogTitle) {
        if (validator == null) {
            IntroduceHandler.$$$reportNull$$$0(0);
        }
        if (dialogTitle == null) {
            IntroduceHandler.$$$reportNull$$$0(1);
        }
        this.myValidator = validator;
        this.myDialogTitle = dialogTitle;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(2);
        }
        this.performAction(new IntroduceOperation(project, editor2, file, null));
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            IntroduceHandler.$$$reportNull$$$0(4);
        }
    }

    public Collection<String> getSuggestedNames(@NotNull PyExpression expression) {
        if (expression == null) {
            IntroduceHandler.$$$reportNull$$$0(5);
        }
        Collection<String> candidates = this.generateSuggestedNames(expression);
        ArrayList<String> res = new ArrayList<String>();
        for (String name : candidates) {
            if (!this.myValidator.checkPossibleName(name, expression)) continue;
            res.add(name);
        }
        if (res.isEmpty()) {
            for (String name : candidates) {
                int index = 1;
                while (!this.myValidator.checkPossibleName(name + index, expression)) {
                    ++index;
                }
                res.add(name + index);
            }
        }
        return res;
    }

    protected Collection<String> generateSuggestedNames(PyExpression expression) {
        PyKeywordArgument kwArg;
        String typeName;
        TypeEvalContext context2;
        PyType type;
        PyExpression callee;
        LinkedHashSet<String> candidates = new LinkedHashSet<String>(){

            @Override
            public boolean add(String s) {
                if (PyNames.isReserved(s)) {
                    return false;
                }
                return super.add(s);
            }
        };
        String text2 = PyStringLiteralUtil.getStringValue((PsiElement)expression);
        Pair selection = (Pair)expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (selection != null) {
            text2 = ((TextRange)selection.getSecond()).substring(((PsiElement)selection.getFirst()).getText());
        }
        if (expression instanceof PyCallExpression && (callee = ((PyCallExpression)expression).getCallee()) != null) {
            text2 = callee.getText();
        }
        if (text2 != null) {
            candidates.addAll(NameSuggesterUtil.generateNames(text2));
        }
        if ((type = (context2 = TypeEvalContext.userInitiated(expression.getProject(), expression.getContainingFile())).getType(expression)) != null && type != PyNoneType.INSTANCE && (typeName = type.getName()) != null) {
            if (type.isBuiltin()) {
                typeName = typeName.substring(0, 1);
            }
            candidates.addAll(NameSuggesterUtil.generateNamesByType(typeName));
        }
        if ((kwArg = (PyKeywordArgument)PsiTreeUtil.getParentOfType((PsiElement)expression, PyKeywordArgument.class)) != null && kwArg.getValueExpression() == expression) {
            candidates.add(kwArg.getKeyword());
        }
        Optional.ofNullable((PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)expression, PyArgumentList.class)).map(PyArgumentList::getCallExpression).ifPresent(call -> StreamEx.of(call.multiMapArguments(PyResolveContext.defaultContext(context2))).map(mapping -> mapping.getMappedParameters().get(expression)).nonNull().map(PyCallableParameter::getName).nonNull().forEach(candidates::add));
        return candidates;
    }

    public void performAction(IntroduceOperation operation) {
        TemplateState templateState;
        PsiFile file = operation.getFile();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        Editor editor2 = operation.getEditor();
        if (editor2.getSettings().isVariableInplaceRenameEnabled() && (templateState = TemplateManagerImpl.getTemplateState((Editor)operation.getEditor())) != null && !templateState.isFinished()) {
            return;
        }
        Object element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor2.getSelectionModel();
        boolean singleElementSelection = false;
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                int startOffset = element1.getTextRange().getEndOffset();
                element1 = file.findElementAt(startOffset);
            }
            if (element2 instanceof PsiWhiteSpace) {
                int endOffset = element2.getTextRange().getStartOffset();
                element2 = file.findElementAt(endOffset - 1);
            }
            if (element1 == element2) {
                singleElementSelection = true;
            }
        } else {
            if (this.smartIntroduce(operation)) {
                return;
            }
            CaretModel caretModel = editor2.getCaretModel();
            Document document = editor2.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document.getLineEndOffset(lineNumber) - 1);
            }
        }
        Project project = operation.getProject();
        if (element1 == null || element2 == null) {
            this.showCannotPerformError(project, editor2);
            return;
        }
        element1 = PyRefactoringUtil.getSelectedExpression(project, file, element1, element2);
        PyComprehensionElement comprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)element1, PyComprehensionElement.class, (boolean)true);
        if (element1 == null || comprehension != null) {
            this.showCannotPerformError(project, editor2);
            return;
        }
        if (singleElementSelection && element1 instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression literal = (PyStringLiteralExpression)element1;
            if (literal.getStringNodes().size() > 1) {
                this.showCannotPerformError(project, editor2);
                return;
            }
            int offset = element1.getTextOffset();
            TextRange selectionRange = TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            TextRange elementRange = element1.getTextRange();
            if (!elementRange.equals((Object)selectionRange) && elementRange.contains(selectionRange)) {
                TextRange innerRange = literal.getStringValueTextRange();
                TextRange intersection = selectionRange.shiftRight(-offset).intersection(innerRange);
                TextRange finalRange = intersection != null ? intersection : selectionRange;
                String text2 = literal.getText();
                if (PyStringFormatParser.getFormatValueExpression(literal) != null && IntroduceHandler.breaksStringFormatting(text2, finalRange) || PyStringFormatParser.getNewStyleFormatValueExpression(literal) != null && IntroduceHandler.breaksNewStyleStringFormatting(text2, finalRange) || IntroduceHandler.breaksStringEscaping(text2, finalRange)) {
                    this.showCannotPerformError(project, editor2);
                    return;
                }
                element1.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, (Object)Pair.create((Object)element1, (Object)finalRange));
            }
        }
        if (!this.checkIntroduceContext(file, editor2, (PsiElement)element1)) {
            return;
        }
        operation.setElement((PsiElement)element1);
        this.performActionOnElement(operation);
    }

    private static boolean breaksStringFormatting(@NotNull String s, @NotNull TextRange range) {
        if (s == null) {
            IntroduceHandler.$$$reportNull$$$0(6);
        }
        if (range == null) {
            IntroduceHandler.$$$reportNull$$$0(7);
        }
        return IntroduceHandler.breaksRanges(PyStringFormatParser.substitutionsToRanges(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(s))), range);
    }

    private static boolean breaksNewStyleStringFormatting(@NotNull String s, @NotNull TextRange range) {
        if (s == null) {
            IntroduceHandler.$$$reportNull$$$0(8);
        }
        if (range == null) {
            IntroduceHandler.$$$reportNull$$$0(9);
        }
        return IntroduceHandler.breaksRanges(PyStringFormatParser.substitutionsToRanges(PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parseNewStyleFormat(s))), range);
    }

    private static boolean breaksStringEscaping(@NotNull String s, @NotNull TextRange range) {
        if (s == null) {
            IntroduceHandler.$$$reportNull$$$0(10);
        }
        if (range == null) {
            IntroduceHandler.$$$reportNull$$$0(11);
        }
        return IntroduceHandler.breaksRanges(PyStringFormatParser.getEscapeRanges(s), range);
    }

    private static boolean breaksRanges(@NotNull List<TextRange> ranges, @NotNull TextRange range) {
        if (ranges == null) {
            IntroduceHandler.$$$reportNull$$$0(12);
        }
        if (range == null) {
            IntroduceHandler.$$$reportNull$$$0(13);
        }
        for (TextRange r : ranges) {
            if (range.contains(r) || !range.intersectsStrict(r)) continue;
            return true;
        }
        return false;
    }

    private void showCannotPerformError(Project project, Editor editor2) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.myDialogTitle, (String)"refactoring.extractMethod");
    }

    private boolean smartIntroduce(final IntroduceOperation operation) {
        int offset;
        Editor editor2 = operation.getEditor();
        PsiFile file = operation.getFile();
        PsiElement elementAtCaret = file.findElementAt(offset = editor2.getCaretModel().getOffset());
        if ((elementAtCaret instanceof PsiWhiteSpace && offset == elementAtCaret.getTextOffset() || elementAtCaret == null) && offset > 0) {
            elementAtCaret = file.findElementAt(offset - 1);
        }
        if (!this.checkIntroduceContext(file, editor2, elementAtCaret)) {
            return true;
        }
        ArrayList<PyExpression> expressions = new ArrayList<PyExpression>();
        while (elementAtCaret != null && !(elementAtCaret instanceof PyStatement) && !(elementAtCaret instanceof PyFile)) {
            if (elementAtCaret instanceof PyExpression && IntroduceHandler.isValidIntroduceVariant(elementAtCaret)) {
                expressions.add((PyExpression)elementAtCaret);
            }
            elementAtCaret = elementAtCaret.getParent();
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            operation.setElement((PsiElement)expressions.get(0));
            this.performActionOnElement(operation);
            return true;
        }
        if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor2, expressions, (Pass)new Pass<PyExpression>(){

                public void pass(PyExpression pyExpression) {
                    operation.setElement((PsiElement)pyExpression);
                    IntroduceHandler.this.performActionOnElement(operation);
                }
            }, pyExpression -> pyExpression.getText());
            return true;
        }
        return false;
    }

    protected boolean checkIntroduceContext(PsiFile file, Editor editor2, PsiElement element) {
        if (!this.isValidIntroduceContext(element)) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor2, (String)PyBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.myDialogTitle, (String)"refactoring.extractMethod");
            return false;
        }
        return true;
    }

    protected boolean isValidIntroduceContext(PsiElement element) {
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)element, PyDecorator.class);
        if (decorator != null && PsiTreeUtil.isAncestor((PsiElement)decorator.getCallee(), (PsiElement)element, (boolean)false)) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class) == null;
    }

    private static boolean isValidIntroduceVariant(PsiElement element) {
        PyCallExpression call = PyUtil.as(element.getParent(), PyCallExpression.class);
        if (call != null && call.getCallee() == element) {
            return false;
        }
        PyComprehensionElement comprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyComprehensionElement.class, (boolean)true);
        return comprehension == null;
    }

    private void performActionOnElement(IntroduceOperation operation) {
        if (!this.checkEnabled(operation)) {
            this.showCanNotIntroduceErrorHint(operation.getProject(), operation.getEditor());
            return;
        }
        PsiElement element = operation.getElement();
        PyExpression initializer = this.getInitializerForElement(element);
        operation.setInitializer(initializer);
        if (initializer != null) {
            operation.setOccurrences(this.getOccurrences(element, initializer));
            operation.setSuggestedNames(this.getSuggestedNames(initializer));
        }
        if (operation.getOccurrences().size() == 0) {
            operation.setReplaceAll(false);
        }
        this.performActionOnElementOccurrences(operation);
    }

    protected void showCanNotIntroduceErrorHint(@NotNull Project project, @NotNull Editor editor2) {
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(14);
        }
        if (editor2 == null) {
            IntroduceHandler.$$$reportNull$$$0(15);
        }
    }

    protected void performActionOnElementOccurrences(final IntroduceOperation operation) {
        Editor editor2 = operation.getEditor();
        if (editor2.getSettings().isVariableInplaceRenameEnabled()) {
            IntroduceHandler.ensureName(operation);
            if (operation.isReplaceAll() != null) {
                this.performInplaceIntroduce(operation);
            } else {
                OccurrencesChooser.simpleChooser((Editor)editor2).showChooser((Object)operation.getElement(), operation.getOccurrences(), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                    public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                        operation.setReplaceAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                        IntroduceHandler.this.performInplaceIntroduce(operation);
                    }
                });
            }
        } else {
            this.performIntroduceWithDialog(operation);
        }
    }

    @Nullable
    protected PyExpression getInitializerForElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PyAssignmentStatement ? ((PyAssignmentStatement)parent).getAssignedValue() : (element instanceof PyExpression ? (PyExpression)element : null);
    }

    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof PyAssignmentStatement) {
            PyTargetExpression target = (PyTargetExpression)((PyAssignmentStatement)statement).getTargets()[0];
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = IntroduceHandler.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            PsiElement elementForCaret = occurrence != null ? occurrence : target;
            operation.getEditor().getCaretModel().moveToOffset(elementForCaret.getTextRange().getStartOffset());
            PyInplaceVariableIntroducer introducer = new PyInplaceVariableIntroducer(target, operation, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    protected void performIntroduceWithDialog(IntroduceOperation operation) {
        Project project = operation.getProject();
        if (operation.getName() == null) {
            PyIntroduceDialog dialog2 = new PyIntroduceDialog(project, this.myDialogTitle, this.myValidator, this.getHelpId(), operation);
            if (!dialog2.showAndGet()) {
                return;
            }
            operation.setName(dialog2.getName());
            operation.setReplaceAll(dialog2.doReplaceAllOccurrences());
            operation.setInitPlace(dialog2.getInitPlace());
        }
        PsiElement declaration = this.performRefactoring(operation);
        Editor editor2 = operation.getEditor();
        editor2.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
        editor2.getSelectionModel().removeSelection();
    }

    protected PsiElement performRefactoring(IntroduceOperation operation) {
        PyAssignmentStatement declaration = this.createDeclaration(operation);
        declaration = this.performReplace(declaration, operation);
        declaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)declaration);
        return declaration;
    }

    public PyAssignmentStatement createDeclaration(IntroduceOperation operation) {
        Project project = operation.getProject();
        PyExpression initializer = operation.getInitializer();
        String assignmentText = operation.getName() + " = " + new InitializerTextBuilder(initializer).result();
        PsiElement anchor = operation.isReplaceAll() != false ? IntroduceHandler.findAnchor(operation.getOccurrences()) : PsiTreeUtil.getParentOfType((PsiElement)initializer, PyStatement.class);
        return this.createDeclaration(project, assignmentText, anchor);
    }

    protected abstract String getHelpId();

    protected PyAssignmentStatement createDeclaration(Project project, String assignmentText, PsiElement anchor) {
        LanguageLevel langLevel = ((PyFile)anchor.getContainingFile()).getLanguageLevel();
        return PyElementGenerator.getInstance(project).createFromText(langLevel, PyAssignmentStatement.class, assignmentText);
    }

    protected boolean checkEnabled(IntroduceOperation operation) {
        return true;
    }

    protected List<PsiElement> getOccurrences(PsiElement element, @NotNull PyExpression expression) {
        if (expression == null) {
            IntroduceHandler.$$$reportNull$$$0(16);
        }
        return PyRefactoringUtil.getOccurrences((PsiElement)expression, (PsiElement)ScopeUtil.getScopeOwner((PsiElement)expression));
    }

    private PsiElement performReplace(@NotNull PsiElement declaration, IntroduceOperation operation) {
        if (declaration == null) {
            IntroduceHandler.$$$reportNull$$$0(17);
        }
        PyExpression expression = operation.getInitializer();
        Project project = operation.getProject();
        SmartPsiElementPointer result = (SmartPsiElementPointer)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{expression.getContainingFile()}).compute(() -> {
            PsiElement insertedDeclaration;
            RefactoringEventData afterData;
            try {
                afterData = new RefactoringEventData();
                afterData.addElement(declaration);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(this.getRefactoringId(), afterData);
                insertedDeclaration = this.addDeclaration(operation, declaration);
                PyExpression newExpression = this.createExpression(project, operation.getName(), declaration);
                if (operation.isReplaceAll().booleanValue()) {
                    ArrayList<PsiElement> newOccurrences = new ArrayList<PsiElement>();
                    for (PsiElement occurrence : operation.getOccurrences()) {
                        PsiElement replaced = this.replaceExpression(occurrence, newExpression, operation);
                        if (replaced == null) continue;
                        newOccurrences.add(replaced);
                    }
                    operation.setOccurrences(newOccurrences);
                } else {
                    PsiElement replaced = this.replaceExpression((PsiElement)expression, newExpression, operation);
                    operation.setOccurrences(Collections.singletonList(replaced));
                }
                this.postRefactoring(operation.getElement());
            }
            finally {
                afterData = new RefactoringEventData();
                afterData.addElement(declaration);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(this.getRefactoringId(), afterData);
            }
            return (SmartPsiElementPointer)ObjectUtils.doIfNotNull((Object)insertedDeclaration, SmartPointerManager::createPointer);
        });
        return (PsiElement)ObjectUtils.doIfNotNull((Object)result, SmartPsiElementPointer::getElement);
    }

    protected abstract String getRefactoringId();

    @Nullable
    public PsiElement addDeclaration(IntroduceOperation operation, PsiElement declaration) {
        PyExpression expression = operation.getInitializer();
        Pair data = (Pair)expression.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
        if (data == null) {
            return this.addDeclaration((PsiElement)expression, declaration, operation);
        }
        return this.addDeclaration((PsiElement)data.first, declaration, operation);
    }

    protected PyExpression createExpression(Project project, String name, PsiElement declaration) {
        return PyElementGenerator.getInstance(project).createExpressionFromText(LanguageLevel.forElement(declaration), name);
    }

    @Nullable
    protected abstract PsiElement addDeclaration(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull IntroduceOperation var3);

    protected void postRefactoring(PsiElement element) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/introduce/IntroduceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuggestedNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksStringFormatting";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksNewStyleStringFormatting";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksStringEscaping";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "breaksRanges";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "showCanNotIntroduceErrorHint";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getOccurrences";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "performReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PyInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyTargetExpression myTarget;

        PyInplaceVariableIntroducer(PyTargetExpression target, IntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), PyBundle.message("python.introduce.variable.refactoring.name", new Object[0]), occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.myTarget = target;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }
    }

    private static class InitializerTextBuilder
    extends PyRecursiveElementVisitor {
        private final StringBuilder myResult;
        private final boolean myPreserveFormatting;

        InitializerTextBuilder(@NotNull PyExpression expression) {
            if (expression == null) {
                InitializerTextBuilder.$$$reportNull$$$0(0);
            }
            this.myResult = new StringBuilder();
            this.myPreserveFormatting = InitializerTextBuilder.shouldPreserveFormatting(expression);
            if (PsiTreeUtil.findChildOfType((PsiElement)expression, PsiComment.class) != null) {
                this.myResult.append(expression.getText());
            } else {
                expression.accept(this);
            }
            if (InitializerTextBuilder.needToWrapTopLevelExpressionInParenthesis(expression)) {
                this.myResult.insert(0, "(").append(")");
            }
        }

        public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
            if (space == null) {
                InitializerTextBuilder.$$$reportNull$$$0(1);
            }
            String text2 = space.getText();
            this.myResult.append(this.myPreserveFormatting ? text2 : text2.replace('\n', ' ').replace("\\", ""));
        }

        @Override
        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
            Pair data;
            if (node == null) {
                InitializerTextBuilder.$$$reportNull$$$0(2);
            }
            if ((data = (Pair)node.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) != null) {
                PsiElement parent = (PsiElement)data.getFirst();
                String text2 = parent.getText();
                Pair detectedQuotes = PyStringLiteralUtil.getQuotes(text2);
                Pair quotes = detectedQuotes != null ? detectedQuotes : Pair.create((Object)"'", (Object)"'");
                TextRange range = (TextRange)data.getSecond();
                String substring = range.substring(text2);
                this.myResult.append((String)quotes.getFirst()).append(substring).append((String)quotes.getSecond());
            } else {
                for (ASTNode child = node.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    String text3 = child.getText();
                    if (child.getElementType() == TokenType.WHITE_SPACE) {
                        if (!text3.contains("\n")) continue;
                        if (!text3.contains("\\")) {
                            this.myResult.append("\\");
                        }
                        this.myResult.append(text3);
                        continue;
                    }
                    this.myResult.append(text3);
                }
            }
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                InitializerTextBuilder.$$$reportNull$$$0(3);
            }
            if (element.getChildren().length == 0) {
                this.myResult.append(element.getText());
            } else {
                super.visitElement(element);
            }
        }

        private static boolean shouldPreserveFormatting(@NotNull PyExpression expression) {
            if (expression == null) {
                InitializerTextBuilder.$$$reportNull$$$0(4);
            }
            if (expression instanceof PyParenthesizedExpression) {
                return ((PyParenthesizedExpression)expression).getContainedExpression() instanceof PyTupleExpression;
            }
            return expression instanceof PySequenceExpression && !(expression instanceof PyTupleExpression);
        }

        private static boolean needToWrapTopLevelExpressionInParenthesis(@NotNull PyExpression node) {
            PsiElement firstChild;
            if (node == null) {
                InitializerTextBuilder.$$$reportNull$$$0(5);
            }
            return node instanceof PyGeneratorExpression && (firstChild = node.getFirstChild()) != null && firstChild.getNode().getElementType() != PyTokenTypes.LPAR;
        }

        public String result() {
            return this.myResult.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "space";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/introduce/IntroduceHandler$InitializerTextBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhiteSpace";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStringLiteralExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldPreserveFormatting";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "needToWrapTopLevelExpressionInParenthesis";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum InitPlace {
        SAME_METHOD,
        CONSTRUCTOR,
        SET_UP;

    }
}

