/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Disposer;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/project/Project;)V", "pyRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "targetEnvRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetEnvRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "RootInfo", "StateFile", "intellij.python.community.impl"})
public final class PyTargetsRemoteSourcesRefresher {
    private final HelpersAwareTargetEnvironmentRequest pyRequest;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final TargetEnvironmentRequest getTargetEnvRequest() {
        return this.pyRequest.getTargetEnvironmentRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(@NotNull ProgressIndicator indicator) throws ExecutionException {
        block15: {
            Path localUploadDir;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Path localRemoteSourcesRoot = Files.createDirectories(Paths.get(PythonSdkUtil.getRemoteSourcesLocalPath(this.sdk.getHomePath()), new String[0]), new FileAttribute[0]);
            Path path = localUploadDir = Files.createTempDirectory("remote_sync", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"localUploadDir");
            TargetEnvironment.UploadRoot uploadVolume = new TargetEnvironment.UploadRoot(path, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
            Collection collection = this.getTargetEnvRequest().getUploadVolumes();
            boolean bl = false;
            collection.add(uploadVolume);
            TargetEnvironment.DownloadRoot downloadVolume = new TargetEnvironment.DownloadRoot(localRemoteSourcesRoot, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), null, 4, null);
            Collection collection2 = this.getTargetEnvRequest().getDownloadVolumes();
            boolean bl2 = false;
            collection2.add(downloadVolume);
            PythonScriptExecution execution = PythonScripts.prepareHelperScriptExecution(PythonHelper.REMOTE_SYNC, this.pyRequest);
            Path path2 = localRemoteSourcesRoot;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"localRemoteSourcesRoot");
            Path path3 = path2;
            Object object = ".state.json";
            boolean bl3 = false;
            Path path4 = path3.resolve((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
            Path stateFilePath = path4;
            FileTime stateFilePrevTimestamp = null;
            if (Files.exists(stateFilePath, new LinkOption[0])) {
                FileTime fileTime = Files.getLastModifiedTime(stateFilePath, new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"Files.getLastModifiedTime(stateFilePath)");
                stateFilePrevTimestamp = fileTime;
                object = localUploadDir;
                String string = ".state.json";
                boolean bl4 = false;
                Path path5 = object.resolve(string);
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
                Files.copy(stateFilePath, path5, new CopyOption[0]);
                execution.addParameter("--state-file");
                execution.addParameter(TargetEnvironmentFunctions.getRelativeTargetPath((Function)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)uploadVolume), (String)".state.json"));
            } else {
                FileTime fileTime = FileTime.from(Instant.MIN);
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"FileTime.from(Instant.MIN)");
                stateFilePrevTimestamp = fileTime;
            }
            execution.addParameter(TargetEnvironmentFunctions.getTargetDownloadPath((TargetEnvironment.DownloadRoot)downloadVolume));
            TargetProgressIndicatorAdapter targetIndicator = new TargetProgressIndicatorAdapter(indicator);
            TargetEnvironment environment = this.getTargetEnvRequest().prepareEnvironment((TargetProgressIndicator)targetIndicator);
            Iterable $this$forEach$iv = environment.getUploadVolumes().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TargetEnvironment.UploadableVolume it = (TargetEnvironment.UploadableVolume)element$iv;
                boolean bl5 = false;
                it.upload(".", (TargetProgressIndicator)targetIndicator);
            }
            TargetedCommandLine cmd = PythonScripts.buildTargetedCommandLine(execution, environment, this.sdk, CollectionsKt.emptyList());
            PythonScripts.execute(cmd, environment, indicator);
            Iterable $this$forEach$iv2 = environment.getDownloadVolumes().values();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv2) {
                TargetEnvironment.DownloadableVolume it = (TargetEnvironment.DownloadableVolume)element$iv;
                boolean bl6 = false;
                it.download(".", indicator);
            }
            if (!Files.exists(stateFilePath, new LinkOption[0])) {
                throw (Throwable)new IllegalStateException(stateFilePath + " is missing");
            }
            if (Files.getLastModifiedTime(stateFilePath, new LinkOption[0]).compareTo(stateFilePrevTimestamp) <= 0) {
                throw (Throwable)new IllegalStateException(stateFilePath + " has not been updated");
            }
            StateFile stateFile = null;
            Closeable $i$f$forEach22 = Files.newBufferedReader(stateFilePath);
            boolean element$iv = false;
            boolean bl7 = false;
            Object object2 = null;
            try {
                BufferedReader it = (BufferedReader)$i$f$forEach22;
                boolean bl8 = false;
                Object object3 = new Gson().fromJson((Reader)it, StateFile.class);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"Gson().fromJson(it, StateFile::class.java)");
                stateFile = (StateFile)object3;
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                object2 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$f$forEach22, (Throwable)object2);
            }
            PathMappingSettings pathMappings = new PathMappingSettings();
            for (RootInfo root : stateFile.getRoots()) {
                Path rootZip;
                String remoteRootPath = root.getPath();
                String localRootName = String.valueOf(remoteRootPath.hashCode());
                Path path6 = localRemoteSourcesRoot;
                boolean bl9 = false;
                Path path7 = path6.resolve(localRootName);
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"this.resolve(other)");
                Path localRoot = Files.createDirectories(path7, new FileAttribute[0]);
                pathMappings.addMappingCheckUnique(((Object)localRoot).toString(), remoteRootPath);
                Path path8 = localRemoteSourcesRoot;
                String string = root.getZipName();
                boolean bl10 = false;
                Intrinsics.checkNotNullExpressionValue((Object)path8.resolve(string), (String)"this.resolve(other)");
                ZipUtil.extract((Path)rootZip, (Path)localRoot, null, (boolean)true);
                for (String invalidEntryRelPath : root.getInvalidEntries()) {
                    Path localInvalidEntry;
                    String string2;
                    Path path9;
                    Intrinsics.checkNotNullExpressionValue((Object)localRoot, (String)"localRoot");
                    Intrinsics.checkNotNullExpressionValue((Object)PathUtil.toSystemDependentName((String)invalidEntryRelPath), (String)"PathUtil.toSystemDepende\u2026Name(invalidEntryRelPath)");
                    boolean bl11 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)path9.resolve(string2), (String)"this.resolve(other)");
                    LOG.debug("Removing the mapped file " + invalidEntryRelPath + " from " + remoteRootPath);
                    PathKt.deleteWithParentsIfEmpty$default((Path)localInvalidEntry, (Path)localRemoteSourcesRoot, (boolean)false, (int)2, null);
                }
                path8 = rootZip;
                boolean bl12 = false;
                Files.delete(path8);
            }
            SdkAdditionalData sdkAdditionalData = this.sdk.getSdkAdditionalData();
            if (!(sdkAdditionalData instanceof RemoteSdkProperties)) {
                sdkAdditionalData = null;
            }
            RemoteSdkProperties remoteSdkProperties = (RemoteSdkProperties)sdkAdditionalData;
            if (remoteSdkProperties == null) break block15;
            remoteSdkProperties.setPathMappings(pathMappings);
        }
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    public PyTargetsRemoteSourcesRefresher(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.sdk = sdk;
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(this.sdk, project);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (helpersAwareTargetEnvironmentRequest == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.pyRequest = helpersAwareTargetEnvironmentRequest;
        boolean bl5 = !(this.sdk instanceof Disposable) || !Disposer.isDisposed((Disposable)((Disposable)this.sdk));
        bl = false;
        bl2 = false;
        if (_Assertions.ENABLED && !bl5) {
            bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyTargetsRemoteSourcesRefresher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$StateFile;", "", "()V", "roots", "", "Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$RootInfo;", "getRoots", "()Ljava/util/List;", "setRoots", "(Ljava/util/List;)V", "intellij.python.community.impl"})
    private static final class StateFile {
        @NotNull
        private List<RootInfo> roots = CollectionsKt.emptyList();

        @NotNull
        public final List<RootInfo> getRoots() {
            return this.roots;
        }

        public final void setRoots(@NotNull List<RootInfo> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.roots = list;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$RootInfo;", "", "()V", "invalidEntries", "", "", "getInvalidEntries", "()Ljava/util/List;", "setInvalidEntries", "(Ljava/util/List;)V", "path", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "zipName", "getZipName", "setZipName", "intellij.python.community.impl"})
    private static final class RootInfo {
        @NotNull
        private String path = "";
        @SerializedName(value="zip_name")
        @NotNull
        private String zipName = "";
        @SerializedName(value="invalid_entries")
        @NotNull
        private List<String> invalidEntries = CollectionsKt.emptyList();

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final String getZipName() {
            return this.zipName;
        }

        public final void setZipName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.zipName = string;
        }

        @NotNull
        public final List<String> getInvalidEntries() {
            return this.invalidEntries;
        }

        public final void setInvalidEntries(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.invalidEntries = list;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

