/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\n\u00100\u001a\u0004\u0018\u00010\bH\u0016J\b\u00101\u001a\u00020-H\u0014J\b\u00102\u001a\u00020-H\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0007H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0012\"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u0014\u0010%\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010'\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u0014\u0010*\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0012\u00a8\u00065"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;)V", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getCondaPathField", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "defaultBaseDir", "getDefaultBaseDir", "()Ljava/lang/String;", "envName", "getEnvName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "languageLevelsField", "Ljavax/swing/JComboBox;", "getLanguageLevelsField", "()Ljavax/swing/JComboBox;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "value", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "pathField", "getPathField", "projectBasePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getProjectBasePath", "selectedLanguageLevel", "getSelectedLanguageLevel", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getOrCreateSdk", "layoutComponents", "updatePathField", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.python.community.impl"})
public class PyAddNewCondaEnvPanel
extends PyAddNewEnvPanel {
    @NotNull
    private final String envName;
    @NotNull
    private final Icon icon;
    @NotNull
    private final JComboBox<String> languageLevelsField;
    @NotNull
    private final TextFieldWithBrowseButton condaPathField;
    @NotNull
    private final TextFieldWithBrowseButton pathField;
    private final JBCheckBox makeSharedField;
    @Nullable
    private String newProjectPath;
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.new.environment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"python\u2026el.name.new.environment\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected final JComboBox<String> getLanguageLevelsField() {
        return this.languageLevelsField;
    }

    @NotNull
    protected final TextFieldWithBrowseButton getCondaPathField() {
        return this.condaPathField;
    }

    @NotNull
    protected final TextFieldWithBrowseButton getPathField() {
        return this.pathField;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.updatePathField();
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(PyBundle.message("sdk.create.venv.conda.dialog.label.location", new Object[0]), (JComponent)this.pathField).addLabeledComponent(PyBundle.message("sdk.create.venv.conda.dialog.label.python.version", new Object[0]), (JComponent)this.languageLevelsField).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField);
        Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026omponent(makeSharedField)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{CondaEnvSdkFlavor.validateCondaPath(this.condaPathField.getText()), PyAddSdkPanel.Companion.validateEnvironmentDirectoryLocation(this.pathField)});
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        String string = this.condaPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"condaPathField.text");
        String condaPath = string;
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(this, condaPath, this.project, PyBundle.message("python.sdk.creating.conda.environment.title", new Object[0]), false){
            final /* synthetic */ PyAddNewCondaEnvPanel this$0;
            final /* synthetic */ String $condaPath;

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                String string = PyCondaPackageManagerImpl.createVirtualEnv(this.$condaPath, this.this$0.getPathField().getText(), PyAddNewCondaEnvPanel.access$getSelectedLanguageLevel$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyCondaPackageManagerImp\u2026t, selectedLanguageLevel)");
                return string;
            }
            {
                this.this$0 = this$0;
                this.$condaPath = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
        boolean shared = this.makeSharedField.isSelected();
        String associatedPath = !shared ? this.getProjectBasePath() : null;
        Sdk sdk = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), this.existingSdks, null, associatedPath, null);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        if (!shared) {
            PySdkExtKt.associateWithModule(sdk2, this.module, this.getNewProjectPath());
        }
        PyCondaPackageService.onCondaEnvCreated(condaPath);
        PySdkExtKt.excludeInnerVirtualEnv(this.project, sdk2);
        return sdk2;
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        DocumentAdapter documentListener2 = new DocumentAdapter(listener2){
            final /* synthetic */ Runnable $listener;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.run();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        };
        JTextField jTextField = this.pathField.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"pathField.textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)documentListener2);
        JTextField jTextField2 = this.condaPathField.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField2, (String)"condaPathField.textField");
        jTextField2.getDocument().addDocumentListener((DocumentListener)documentListener2);
    }

    private final void updatePathField() {
        String string;
        String baseDir;
        String string2 = this.getDefaultBaseDir();
        if (string2 == null) {
            string2 = baseDir = SystemProperties.getUserHome() + "/.conda/envs";
        }
        if ((string = this.getProjectBasePath()) == null) {
            string = "untitled";
        }
        String string3 = PathUtil.getFileName((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PathUtil.getFileName(pro\u2026ctBasePath ?: \"untitled\")");
        String dirName = string3;
        this.pathField.setText(FileUtil.toSystemDependentName((String)(baseDir + '/' + dirName)));
    }

    private final String getDefaultBaseDir() {
        String string = this.condaPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"condaPathField.text");
        String conda = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(conda);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ath(conda) ?: return null");
        VirtualFile condaFile = virtualFile;
        VirtualFile virtualFile2 = condaFile.getParent();
        return virtualFile2 != null && (virtualFile2 = virtualFile2.getParent()) != null && (virtualFile2 = virtualFile2.findChild("envs")) != null ? virtualFile2.getPath() : null;
    }

    private final String getProjectBasePath() {
        String string;
        String string2 = this.getNewProjectPath();
        if (string2 == null) {
            Module module = this.module;
            string2 = string = module != null ? BasePySdkExtKt.getBasePath(module) : null;
        }
        if (string2 == null) {
            Project project = this.project;
            string = project != null ? project.getBasePath() : null;
        }
        return string;
    }

    private final String getSelectedLanguageLevel() {
        String string = this.languageLevelsField.getItemAt(this.languageLevelsField.getSelectedIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"languageLevelsField.getI\u2026evelsField.selectedIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public PyAddNewCondaEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks2, @Nullable String newProjectPath) {
        void $this$apply;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        TextFieldWithBrowseButton $this$apply2;
        String path;
        Intrinsics.checkNotNullParameter(existingSdks2, (String)"existingSdks");
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks2;
        this.envName = "Conda";
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PythonIcons.Python.Anaconda");
        this.icon = icon;
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        boolean bl = false;
        boolean bl2 = false;
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        Object object = this;
        boolean bl3 = false;
        String string = path = PyCondaPackageService.getCondaExecutable(null);
        if (string != null) {
            Iterator iterator = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = iterator;
            boolean bl6 = false;
            $this$apply2.setText(it);
        }
        $this$apply2.addBrowseFolderListener(PyBundle.message("python.sdk.select.conda.path.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        JTextField jTextField = $this$apply2.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ PyAddNewCondaEnvPanel this$0;
            {
                this.this$0 = pyAddNewCondaEnvPanel;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PyAddNewCondaEnvPanel.access$updatePathField(this.this$0);
            }
        });
        Object object2 = Unit.INSTANCE;
        ((PyAddNewCondaEnvPanel)object).condaPathField = textFieldWithBrowseButton;
        textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        bl = false;
        bl2 = false;
        $this$apply2 = textFieldWithBrowseButton;
        object = this;
        boolean bl7 = false;
        $this$apply2.addBrowseFolderListener(PyBundle.message("python.sdk.select.location.for.conda.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        object2 = Unit.INSTANCE;
        ((PyAddNewCondaEnvPanel)object).pathField = textFieldWithBrowseButton;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        this.newProjectPath = newProjectPath;
        this.setLayout(new BorderLayout());
        List<LanguageLevel> list = LanguageLevel.SUPPORTED_LEVELS;
        Intrinsics.checkNotNullExpressionValue(list, (String)"LanguageLevel.SUPPORTED_LEVELS");
        Iterable iterable = CollectionsKt.asReversedMutable(list);
        boolean $i$f$filter = false;
        $this$apply2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LanguageLevel it = (LanguageLevel)((Object)element$iv$iv);
            boolean bl8 = false;
            if (!(it.compareTo((Enum)LanguageLevel.PYTHON311) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LanguageLevel it = (LanguageLevel)((Object)item$iv$iv);
            object = destination$iv$iv;
            boolean bl9 = false;
            object2 = it.toPythonVersion();
            object.add(object2);
        }
        List supportedLanguageLevels = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = supportedLanguageLevels;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        iterable = new ComboBox(objectArray);
        bl2 = false;
        boolean bl10 = false;
        destination$iv$iv = iterable;
        object = this;
        boolean bl11 = false;
        $this$apply.setSelectedItem($this$apply.getItemCount() > 0 ? (String)$this$apply.getItemAt(0) : null);
        object2 = Unit.INSTANCE;
        ((PyAddNewCondaEnvPanel)object).languageLevelsField = (JComboBox)((Object)iterable);
        if (PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault()) {
            this.makeSharedField.setSelected(true);
        }
        this.updatePathField();
        this.layoutComponents();
    }

    public static final /* synthetic */ String access$getSelectedLanguageLevel$p(PyAddNewCondaEnvPanel $this) {
        return $this.getSelectedLanguageLevel();
    }

    public static final /* synthetic */ void access$updatePathField(PyAddNewCondaEnvPanel $this) {
        $this.updatePathField();
    }
}

