/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.configuration;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.configuration.PyInterpreterInspectionSuppressor;
import com.jetbrains.python.sdk.configuration.PyPackageRequirementsInspectionSuppressor;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.sdk.configuration.TipOfTheDaySuppressor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rJ \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eJ(\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0007J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfiguration;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "configureSdkUsingExtension", "", "module", "Lcom/intellij/openapi/module/Module;", "extension", "Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfigurationExtension;", "supplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/projectRoots/Sdk;", "notifyAboutConfiguredSdk", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "setReadyToUseSdk", "setSdkUsingExtension", "suppressTipAndInspectionsFor", "Lcom/intellij/openapi/Disposable;", "intellij.python.community.impl"})
public final class PyProjectSdkConfiguration {
    private static final Logger LOGGER;
    @NotNull
    public static final PyProjectSdkConfiguration INSTANCE;

    public final void configureSdkUsingExtension(@NotNull Module module, @NotNull PyProjectSdkConfigurationExtension extension, @NotNull Function0<? extends Sdk> supplier) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        Disposable lifetime = this.suppressTipAndInspectionsFor(module, extension);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(lifetime, module, extension, supplier, module.getProject(), PySdkBundle.message("python.configuring.interpreter.progress", new Object[0]), false){
            final /* synthetic */ Disposable $lifetime;
            final /* synthetic */ Module $module;
            final /* synthetic */ PyProjectSdkConfigurationExtension $extension;
            final /* synthetic */ Function0 $supplier;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                Disposable $this$use$iv = this.$lifetime;
                boolean $i$f$use = false;
                try {
                    Disposable it = $this$use$iv;
                    boolean bl = false;
                    PyProjectSdkConfiguration.INSTANCE.setSdkUsingExtension(this.$module, this.$extension, (Function0<? extends Sdk>)this.$supplier);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if ($this$use$iv != null) {
                        Disposer.dispose((Disposable)$this$use$iv);
                    }
                }
            }
            {
                this.$lifetime = $captured_local_variable$0;
                this.$module = $captured_local_variable$1;
                this.$extension = $captured_local_variable$2;
                this.$supplier = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    @RequiresBackgroundThread
    public final void setSdkUsingExtension(@NotNull Module module, @NotNull PyProjectSdkConfigurationExtension extension, @NotNull Function0<? extends Sdk> supplier) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            ProgressManager.progress((String)"");
            LOGGER.debug("Configuring sdk with " + extension.getClass().getCanonicalName() + " extension");
            Sdk sdk = (Sdk)supplier.invoke();
            if (sdk == null) break block0;
            Sdk sdk2 = sdk;
            boolean bl = false;
            boolean bl2 = false;
            Sdk it = sdk2;
            boolean bl3 = false;
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            INSTANCE.setReadyToUseSdk(project, module, it);
        }
    }

    public final void setReadyToUseSdk(@NotNull Project project, @NotNull Module module, @NotNull Sdk sdk) {
        Application app$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            if (!module.isDisposed()) {
                SdkConfigurationUtil.setDirectoryProjectSdk((Project)project, (Sdk)sdk);
                PySdkExtKt.excludeInnerVirtualEnv(module, sdk);
                PyProjectSdkConfiguration.INSTANCE.notifyAboutConfiguredSdk(project, module, sdk);
            }
        } else {
            boolean $i$f$invokeLater = false;
            Application application2 = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(module, project, sdk){
                final /* synthetic */ Module $module$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Sdk $sdk$inlined;
                {
                    this.$module$inlined = module;
                    this.$project$inlined = project;
                    this.$sdk$inlined = sdk;
                }

                public final void run() {
                    boolean bl = false;
                    if (!this.$module$inlined.isDisposed()) {
                        SdkConfigurationUtil.setDirectoryProjectSdk((Project)this.$project$inlined, (Sdk)this.$sdk$inlined);
                        PySdkExtKt.excludeInnerVirtualEnv(this.$module$inlined, this.$sdk$inlined);
                        PyProjectSdkConfiguration.access$notifyAboutConfiguredSdk(PyProjectSdkConfiguration.INSTANCE, this.$project$inlined, this.$module$inlined, this.$sdk$inlined);
                    }
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application2.invokeLater(runnable, modalityState);
        }
    }

    @NotNull
    public final Disposable suppressTipAndInspectionsFor(@NotNull Module module, @NotNull PyProjectSdkConfigurationExtension extension) {
        Disposable it;
        boolean bl;
        boolean bl2;
        Disposable disposable;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        Disposable disposable2 = Disposer.newDisposable((Disposable)PythonPluginDisposable.getInstance(project2), (String)("Configuring sdk using " + extension.getClass().getName() + " extension"));
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable(\n\u2026ss.name} extension\"\n    )");
        Disposable lifetime = disposable2;
        Disposable disposable3 = TipOfTheDaySuppressor.Companion.suppress();
        if (disposable3 != null) {
            disposable = disposable3;
            bl2 = false;
            bl = false;
            it = disposable;
            boolean bl3 = false;
            Disposer.register((Disposable)lifetime, (Disposable)it);
        }
        Disposable disposable4 = PyInterpreterInspectionSuppressor.Companion.suppress(project2);
        if (disposable4 != null) {
            disposable = disposable4;
            bl2 = false;
            bl = false;
            it = disposable;
            boolean bl4 = false;
            Disposer.register((Disposable)lifetime, (Disposable)it);
        }
        Disposer.register((Disposable)lifetime, (Disposable)new PyPackageRequirementsInspectionSuppressor(module));
        return lifetime;
    }

    private final void notifyAboutConfiguredSdk(Project project, Module module, Sdk sdk) {
        if (ProjectUtil.isNotificationSilentMode((Project)project)) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("ConfiguredPythonInterpreter");
        String string = PyBundle.message("sdk.has.been.configured.as.the.project.interpreter", sdk.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"sdk.ha\u2026t.interpreter\", sdk.name)");
        Notification notification2 = notificationGroup.createNotification(string, NotificationType.INFORMATION);
        boolean bl = false;
        boolean bl2 = false;
        Notification $this$apply = notification2;
        boolean bl3 = false;
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)PySdkBundle.message("python.configure.interpreter.action", new Object[0]), (Runnable)new Runnable(project, module){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Module $module$inlined;
            {
                this.$project$inlined = project;
                this.$module$inlined = module;
            }

            public final void run() {
                PySdkPopupFactory.Companion.createAndShow(this.$project$inlined, this.$module$inlined);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"NotificationAction.creat\u2026(project, module)\n      }");
        NotificationAction configureSdkAction2 = notificationAction;
        $this$apply.addAction((AnAction)configureSdkAction2);
        $this$apply.notify(project);
    }

    private PyProjectSdkConfiguration() {
    }

    static {
        PyProjectSdkConfiguration pyProjectSdkConfiguration;
        INSTANCE = pyProjectSdkConfiguration = new PyProjectSdkConfiguration();
        Logger logger = Logger.getInstance(PyProjectSdkConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(PyPro\u2026onfiguration::class.java)");
        LOGGER = logger;
    }
}

