/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualEnvSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] NAMES = new String[]{"jython", "pypy", "python.exe", "jython.bat", "pypy.exe"};

    private VirtualEnvSdkFlavor() {
    }

    public static VirtualEnvSdkFlavor getInstance() {
        return (VirtualEnvSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(VirtualEnvSdkFlavor.class);
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context2) {
        Collection collection = (Collection)ReadAction.compute(() -> {
            VirtualFile pyEnvLocation;
            VirtualFile dir;
            Path baseDirFromContext;
            ArrayList<String> candidates = new ArrayList<String>();
            VirtualFile baseDirFromModule = module == null ? null : BasePySdkExtKt.getBaseDir(module);
            Path path = baseDirFromContext = context2 == null ? null : (Path)context2.getUserData(PySdkExtKt.getBASE_DIR());
            if (baseDirFromModule != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(baseDirFromModule));
            } else if (baseDirFromContext != null && (dir = VfsUtil.findFile((Path)baseDirFromContext, (boolean)false)) != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(dir));
            }
            VirtualFile path2 = VirtualEnvSdkFlavor.getDefaultLocation();
            if (path2 != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(path2));
            }
            if ((pyEnvLocation = VirtualEnvSdkFlavor.getPyEnvDefaultLocations()) != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(pyEnvLocation));
            }
            return candidates;
        });
        if (collection == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    public static VirtualFile getPyEnvDefaultLocations() {
        VirtualFile pyEnvRoot;
        String path = System.getenv().get("PYENV_ROOT");
        if (!StringUtil.isEmpty((String)path) && (pyEnvRoot = LocalFileSystem.getInstance().findFileByPath(FileUtil.expandUserHome((String)path).replace('\\', '/'))) != null) {
            return pyEnvRoot.findFileByRelativePath("versions");
        }
        VirtualFile userHome = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getUserHome().replace('\\', '/'));
        if (userHome != null) {
            return userHome.findFileByRelativePath(".pyenv/versions");
        }
        return null;
    }

    public static VirtualFile getDefaultLocation() {
        String path = System.getenv().get("WORKON_HOME");
        if (!StringUtil.isEmpty((String)path)) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.expandUserHome((String)path).replace('\\', '/'));
        }
        VirtualFile userHome = VfsUtil.getUserHomeDir();
        if (userHome != null) {
            return userHome.findChild(".virtualenvs");
        }
        return null;
    }

    public static Collection<String> findInBaseDirectory(@Nullable VirtualFile baseDir) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (baseDir != null) {
            VirtualFile[] suspects;
            baseDir.refresh(true, false);
            for (VirtualFile child : suspects = baseDir.getChildren()) {
                candidates.addAll(VirtualEnvSdkFlavor.findInRootDirectory(child));
            }
        }
        return candidates;
    }

    @NotNull
    public static Collection<String> findInRootDirectory(@Nullable VirtualFile rootDir) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (rootDir != null && rootDir.isDirectory()) {
            String interpreter;
            VirtualFile bin = rootDir.findChild("bin");
            VirtualFile scripts = rootDir.findChild("Scripts");
            if (bin != null && (interpreter = VirtualEnvSdkFlavor.findInterpreter(bin)) != null) {
                candidates.add(interpreter);
            }
            if (scripts != null && (interpreter = VirtualEnvSdkFlavor.findInterpreter(scripts)) != null) {
                candidates.add(interpreter);
            }
            if (candidates.isEmpty() && (interpreter = VirtualEnvSdkFlavor.findInterpreter(rootDir)) != null) {
                candidates.add(interpreter);
            }
        }
        ArrayList<String> arrayList = candidates;
        if (arrayList == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private static String findInterpreter(VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            if (child.isDirectory()) continue;
            String childName = StringUtil.toLowerCase((String)child.getName());
            for (String name : NAMES) {
                if (SystemInfo.isWindows) {
                    if (!childName.equals(name)) continue;
                    return FileUtil.toSystemDependentName((String)child.getPath());
                }
                if (!childName.startsWith(name) && !PYTHON_RE.matcher(childName).matches() || childName.endsWith("-config")) continue;
                return child.getPath();
            }
        }
        return null;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(2);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkUtil.getVirtualEnvRoot(file.getPath()) != null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Virtualenv;
        if (icon == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(3);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/VirtualEnvSdkFlavor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRootDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/VirtualEnvSdkFlavor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

