/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Ntifs;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinioctlUtil;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"IO_REPARSE_TAG_APPEXECLINK", "", "storeMarker", "", "userAppxFolder", "Ljava/io/File;", "appxProduct", "getAppxProduct", "(Ljava/io/File;)Ljava/lang/String;", "getAppxFiles", "", "expectedProduct", "filePattern", "Lkotlin/text/Regex;", "getAppxTag", "path", "intellij.python.community.impl"})
public final class WinAppxToolsKt {
    private static final String storeMarker = "DesktopAppInstaller";
    private static final File userAppxFolder;
    private static final long IO_REPARSE_TAG_APPEXECLINK = 2147483675L;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<File> getAppxFiles(@NotNull String expectedProduct, @NotNull Regex filePattern) {
        Object object;
        block8: {
            block7: {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)expectedProduct, (String)"expectedProduct");
                Intrinsics.checkNotNullParameter((Object)filePattern, (String)"filePattern");
                object = userAppxFolder;
                if (object == null || (object = ((File)object).listFiles(new FilenameFilter(filePattern){
                    final /* synthetic */ Regex $filePattern;

                    public final boolean accept(File $noName_0, String name) {
                        String string = name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        return this.$filePattern.matches((CharSequence)string);
                    }
                    {
                        this.$filePattern = regex;
                    }
                })) == null) break block7;
                Object[] $this$sortedBy$iv = object;
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                object = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        File it = (File)a;
                        boolean bl2 = false;
                        File file = it;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                        it = (File)b;
                        Comparable comparable = (Comparable)((Object)FilesKt.getNameWithoutExtension((File)file));
                        bl2 = false;
                        File file2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
                        String string = FilesKt.getNameWithoutExtension((File)file2);
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                });
                if (object == null) break block7;
                Iterable $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    File file = (File)element$iv$iv;
                    boolean bl3 = false;
                    File file2 = file;
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                    if (WinAppxToolsKt.getAppxProduct(file2) != null) {
                        String string;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        String product = string;
                        boolean bl6 = false;
                        pair = new Pair((Object)product, (Object)file);
                    } else {
                        pair = null;
                    }
                    if (pair == null) continue;
                    Pair pair2 = pair;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Pair it$iv$iv = pair2;
                    boolean bl9 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                object = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                if (object == null) break block7;
                Object $this$filterKeys$iv = object;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                Object object2 = $this$filterKeys$iv;
                boolean bl10 = false;
                for (Map.Entry entry$iv : object2.entrySet()) {
                    String it = (String)entry$iv.getKey();
                    boolean bl11 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)expectedProduct, (boolean)false, (int)2, null)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                object = ((Map)result$iv).values();
                if (object != null) break block8;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public static final String getAppxProduct(@NotNull File $this$appxProduct) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$appxProduct, (String)"$this$appxProduct");
        File file = $this$appxProduct.getParentFile();
        if (file == null || !file.equals(userAppxFolder)) {
            return null;
        }
        String string2 = $this$appxProduct.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"absolutePath");
        String string3 = WinAppxToolsKt.getAppxTag(string2);
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            string = !StringsKt.contains$default((CharSequence)it, (CharSequence)storeMarker, (boolean)false, (int)2, null) ? it : null;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getAppxTag(String path) {
        if (!SystemInfo.isWin10OrNewer) {
            return null;
        }
        Kernel32 kernel = Kernel32.INSTANCE;
        Logger logger = Logger.getInstance(Kernel32.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kernel32::class.java)");
        Logger logger2 = logger;
        WinNT.HANDLE file = kernel.CreateFile(path, Integer.MIN_VALUE, 1, null, 3, 0x200000, null);
        if (Intrinsics.areEqual((Object)file, (Object)Kernel32.INVALID_HANDLE_VALUE)) {
            logger2.warn("Invalid handle for " + path);
            return null;
        }
        Ntifs.REPARSE_DATA_BUFFER buffer = new Ntifs.REPARSE_DATA_BUFFER();
        IntByReference bytesRead = new IntByReference();
        if (!kernel.DeviceIoControl(file, WinioctlUtil.FSCTL_GET_REPARSE_POINT, null, 0, buffer.getPointer(), buffer.size(), bytesRead, null)) {
            logger2.warn("DeviceIoControl error " + kernel.GetLastError());
            return null;
        }
        if (bytesRead.getValue() < 1) {
            logger2.warn("0 bytes read");
            return null;
        }
        buffer.read();
        if (buffer.ReparseTag != (int)2147483675L) {
            logger2.warn("Wrong tag " + buffer.ReparseTag);
            return null;
        }
        CharBuffer charBuffer = Charsets.UTF_16LE.decode(ByteBuffer.wrap(buffer.u.genericReparseBuffer.DataBuffer));
        int from = 0;
        int to = 0;
        boolean startFound = false;
        CharBuffer charBuffer2 = charBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer2, (String)"charBuffer");
        CharSequence charSequence = charBuffer2;
        int n = 0;
        while (n < charSequence.length()) {
            void i;
            boolean validChar;
            char c = charSequence.charAt(n);
            boolean bl = validChar = Character.getType(c) != 15;
            if (validChar && !startFound) {
                from = i;
                startFound = true;
            }
            if (!validChar && startFound) {
                to = i;
                break;
            }
            ++i;
        }
        CharSequence charSequence2 = charBuffer;
        boolean bl = false;
        return ((Object)charSequence2.subSequence(from, to)).toString();
    }

    static {
        File file;
        if (!SystemInfo.isWin10OrNewer) {
            file = null;
        } else {
            String string = System.getenv("LOCALAPPDATA");
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String localappdata = string2;
                boolean bl3 = false;
                File appsPath = new File(localappdata, "Microsoft//WindowsApps");
                file = appsPath.exists() ? appsPath : null;
            } else {
                file = null;
            }
        }
        userAppxFolder = file;
    }
}

