/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.extensions.python.VirtualFileExtKt;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.run.PythonRunConfigurationProducer;
import com.jetbrains.python.sdk.PySdkExtKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlKey;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryRunScript;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "runScriptFromRunConfiguration", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.python.community.impl"})
public final class PoetryRunScript
extends AnAction {
    @NotNull
    public static final String actionID = "poetryRunScript";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void runScriptFromRunConfiguration(Project project, PsiFile file) {
        ConfigurationFromContext configurationFromContext = ((PythonRunConfigurationProducer)RunConfigurationProducer.getInstance(PythonRunConfigurationProducer.class)).createConfigurationFromContext(new ConfigurationContext((PsiElement)file));
        if (configurationFromContext == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)configurationFromContext, (String)"RunConfigurationProducer\u2026nContext(file)) ?: return");
        ConfigurationFromContext configurationFromContext2 = configurationFromContext;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationFromContext2.getConfigurationSettings();
        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"configurationFromContext.configurationSettings");
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        RunManager runManager = RunManager.Companion.getInstance(project);
        runManager.addConfiguration(settings);
        runManager.setSelectedConfiguration(settings);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"DefaultRunExecutor.getRunExecutorInstance()");
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = ExecutionEnvironmentBuilder.Companion.createOrNull(executor, settings);
        if (executionEnvironmentBuilder == null) {
            return;
        }
        ExecutionEnvironmentBuilder builder = executionEnvironmentBuilder;
        ExecutionManager.Companion.getInstance(project).restartRunProfile(ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)builder, null, (int)1, null));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Location location = (Location)e.getDataContext().getData(Location.DATA_KEY);
        Object object = location != null ? location.getPsiElement() : null;
        if (!(object instanceof TomlKey)) {
            object = null;
        }
        TomlKey tomlKey = (TomlKey)object;
        if (tomlKey == null) {
            return;
        }
        TomlKey tomlKey2 = tomlKey;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Sdk sdk = PySdkExtKt.getPythonSdk(project2);
        if (sdk == null || (sdk = sdk.getHomeDirectory()) == null || (sdk = sdk.getParent()) == null || (sdk = sdk.findChild(tomlKey2.getText())) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"project.pythonSdk?.homeD\u2026d(tomlKey.text) ?: return");
        Sdk scriptPath = sdk;
        PsiFileSystemItem psiFileSystemItem = VirtualFileExtKt.toPsi((VirtualFile)scriptPath, project2);
        if (psiFileSystemItem == null) {
            ExecutionErrorDialog.show((ExecutionException)new PyExecutionException("Cannot find a script file\nPlease run 'poetry install' before executing scripts", "poetry", CollectionsKt.emptyList()), (String)"Poetry Plugin", (Project)project2);
            return;
        }
        PsiFileSystemItem scriptFile = psiFileSystemItem;
        PsiFile psiFile = scriptFile.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"scriptFile.containingFile");
        this.runScriptFromRunConfiguration(project2, psiFile);
    }

    public PoetryRunScript() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
        presentation.setIcon(AllIcons.Actions.Execute);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryRunScript$Companion;", "", "()V", "actionID", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

