/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.extensions.ContextAnchor;
import com.jetbrains.extensions.ModuleBasedContextAnchor;
import com.jetbrains.extensions.NameAndElement;
import com.jetbrains.extensions.PsiFileSystemItemExtKt;
import com.jetbrains.extensions.QNameResolveContext;
import com.jetbrains.extensions.QualifiedNameExtKt;
import com.jetbrains.extensions.TargetWithVariantExtKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.targetBasedConfiguration.PyRunTargetVariant;
import com.jetbrains.python.run.targetBasedConfiguration.TargetWithVariant;
import com.jetbrains.python.testing.ConfigField;
import com.jetbrains.python.testing.ConfigurationTarget$WhenMappings;
import com.jetbrains.python.testing.PyAbstractTestConfiguration;
import com.jetbrains.python.testing.PyQNameResolveAndSplitUtilsKt;
import com.jetbrains.python.testing.QualifiedNameParts;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0000J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R$\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/jetbrains/python/testing/ConfigurationTarget;", "Lcom/jetbrains/python/run/targetBasedConfiguration/TargetWithVariant;", "target", "", "targetType", "Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;", "(Ljava/lang/String;Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;)V", "getTarget$annotations", "()V", "getTarget", "()Ljava/lang/String;", "setTarget", "(Ljava/lang/String;)V", "getTargetType$annotations", "getTargetType", "()Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;", "setTargetType", "(Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;)V", "asPsiElement", "Lcom/intellij/psi/PsiElement;", "configuration", "Lcom/jetbrains/python/testing/PyAbstractTestConfiguration;", "checkValid", "", "component1", "component2", "copy", "copyTo", "dst", "equals", "", "other", "", "generateArgumentsLine", "", "generatePythonTarget", "getArgumentsForPythonTarget", "getElementDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "hashCode", "", "toString", "intellij.python.community.impl"})
public final class ConfigurationTarget
implements TargetWithVariant {
    @NotNull
    private String target;
    @NotNull
    private PyRunTargetVariant targetType;

    public final void copyTo(@NotNull ConfigurationTarget dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        dst.setTarget(this.getTarget());
        dst.setTargetType(this.getTargetType());
    }

    public final void checkValid() {
        if (this.getTargetType() != PyRunTargetVariant.CUSTOM) {
            CharSequence charSequence = this.getTarget();
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new RuntimeConfigurationWarning(PyBundle.message("python.testing.target.not.provided", new Object[0]));
            }
        }
        if (this.getTargetType() == PyRunTargetVariant.PYTHON && !TargetWithVariantExtKt.isWellFormed(this)) {
            throw (Throwable)new RuntimeConfigurationError(PyBundle.message("python.testing.provide.qualified.name", new Object[0]));
        }
    }

    @Nullable
    public final PsiElement asPsiElement(@NotNull PyAbstractTestConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return TargetWithVariantExtKt.asPsiElement(this, configuration, configuration.getWorkingDirectoryAsVirtual$intellij_python_community_impl());
    }

    @NotNull
    public final List<String> generateArgumentsLine(@NotNull PyAbstractTestConfiguration configuration) {
        List list;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        switch (ConfigurationTarget$WhenMappings.$EnumSwitchMapping$0[this.getTargetType().ordinal()]) {
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list = this.getArgumentsForPythonTarget(configuration);
                break;
            }
            case 3: {
                Object[] objectArray = new String[2];
                objectArray[0] = "--path";
                String string = this.getTarget();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                objectArray[1] = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<String> getArgumentsForPythonTarget(PyAbstractTestConfiguration configuration) {
        boolean $i$f$runReadAction = false;
        return (List)ApplicationManager.getApplication().runReadAction(new Computable(this, configuration){
            final /* synthetic */ ConfigurationTarget this$0;
            final /* synthetic */ PyAbstractTestConfiguration $configuration$inlined;
            {
                this.this$0 = configurationTarget;
                this.$configuration$inlined = pyAbstractTestConfiguration;
            }

            public final T compute() {
                List list;
                boolean bl = false;
                PsiElement psiElement = this.this$0.asPsiElement(this.$configuration$inlined);
                if (psiElement == null) {
                    throw (Throwable)new ExecutionException(PyBundle.message("python.testing.cant.resolve", this.this$0.getTarget()));
                }
                PsiElement element = psiElement;
                if (element instanceof PsiDirectory) {
                    Object[] objectArray = new String[2];
                    objectArray[0] = "--path";
                    VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"element.virtualFile");
                    String string = virtualFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.virtualFile.path");
                    objectArray[1] = string;
                    list = CollectionsKt.listOf((Object[])objectArray);
                } else {
                    TypeEvalContext context2 = TypeEvalContext.userInitiated(this.$configuration$inlined.getProject(), null);
                    Module module = this.$configuration$inlined.getModule();
                    Intrinsics.checkNotNull((Object)module);
                    Intrinsics.checkNotNullExpressionValue((Object)module, (String)"configuration.module!!");
                    ContextAnchor contextAnchor = new ModuleBasedContextAnchor(module);
                    TypeEvalContext typeEvalContext = context2;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"context");
                    QNameResolveContext qNameResolveContext = new QNameResolveContext(contextAnchor, null, typeEvalContext, LocalFileSystem.getInstance().findFileByPath(this.$configuration$inlined.getWorkingDirectorySafe()), true, 2, null);
                    String string = this.this$0.getTarget();
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    QualifiedName qualifiedName = QualifiedName.fromDottedString((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
                    Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"QualifiedName.fromDottedString(target.trim())");
                    QualifiedNameParts qualifiedNameParts = PyQNameResolveAndSplitUtilsKt.tryResolveAndSplit(qualifiedName, qNameResolveContext);
                    if (qualifiedNameParts == null) {
                        throw (Throwable)new ExecutionException(PyBundle.message("python.testing.cant.find.where.declared", this.this$0.getTarget()));
                    }
                    QualifiedNameParts qualifiedNameParts2 = qualifiedNameParts;
                    if (!this.$configuration$inlined.shouldSeparateTargetPath$intellij_python_community_impl()) {
                        QualifiedName qNameInsideOfDirectory = QualifiedNameParts.getElementNamePrependingFile$default(qualifiedNameParts2, null, 1, null);
                        NameAndElement elementAndName = QualifiedNameExtKt.getElementAndResolvableName$default(qNameInsideOfDirectory, QNameResolveContext.copy$default(qNameResolveContext, null, null, null, null, false, 15, null), false, 2, null);
                        if (elementAndName != null) {
                            String string3 = elementAndName.getName().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"elementAndName.name.toString()");
                            list = ConfigurationTarget.access$generatePythonTarget(this.this$0, string3, this.$configuration$inlined);
                        } else {
                            PyFile pyFile;
                            PsiFile psiFile = element.getContainingFile();
                            if (!(psiFile instanceof PyFile)) {
                                psiFile = null;
                            }
                            if ((pyFile = (PyFile)psiFile) == null || (pyFile = PsiFileSystemItemExtKt.getQName((PsiFileSystemItem)pyFile)) == null || (pyFile = pyFile.append(qualifiedNameParts2.getElementName())) == null) {
                                throw (Throwable)new ExecutionException(PyBundle.message("python.testing.cant.get.importable.name", element.getContainingFile()));
                            }
                            PyFile name = pyFile;
                            String string4 = name.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name.toString()");
                            list = ConfigurationTarget.access$generatePythonTarget(this.this$0, string4, this.$configuration$inlined);
                        }
                    } else {
                        VirtualFile elementFile;
                        QualifiedName pyTarget = qualifiedNameParts2.getElementName();
                        PsiFile psiFile = element.getContainingFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
                        VirtualFile virtualFile = elementFile = psiFile.getVirtualFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"elementFile");
                        VirtualFile workingDir = virtualFile.getFileSystem().findFileByPath(this.$configuration$inlined.getWorkingDirectorySafe());
                        String string5 = workingDir != null ? VfsUtil.getRelativePath((VirtualFile)elementFile, (VirtualFile)workingDir) : null;
                        if (string5 == null) {
                            string5 = elementFile.getPath();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(if (workingDir != null)\u2026      ?: elementFile.path");
                        String fileSystemPartOfTarget = string5;
                        list = pyTarget.getComponentCount() == 0 ? CollectionsKt.listOf((Object[])new String[]{"--path", fileSystemPartOfTarget}) : ConfigurationTarget.access$generatePythonTarget(this.this$0, fileSystemPartOfTarget + "::" + pyTarget, this.$configuration$inlined);
                    }
                }
                return (T)list;
            }
        });
    }

    private final List<String> generatePythonTarget(String target, PyAbstractTestConfiguration configuration) {
        return CollectionsKt.listOf((Object[])new String[]{"--target", target + configuration.getPythonTargetAdditionalParams()});
    }

    @Nullable
    public final VirtualFile getElementDirectory(@NotNull PyAbstractTestConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (Intrinsics.areEqual((Object)this.getTarget(), (Object)"")) {
            return null;
        }
        Object object = TargetWithVariantExtKt.asVirtualFile(this);
        if (object == null) {
            PsiElement psiElement = this.asPsiElement(configuration);
            object = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
        }
        if (object == null) {
            return null;
        }
        VirtualFile fileOrDir = object;
        return fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
    }

    @ConfigField(localizedName="runcfg.python_tests.config.target")
    public static /* synthetic */ void getTarget$annotations() {
    }

    @Override
    @NotNull
    public String getTarget() {
        return this.target;
    }

    public void setTarget(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.target = string;
    }

    @ConfigField(localizedName="runcfg.python_tests.config.targetType")
    public static /* synthetic */ void getTargetType$annotations() {
    }

    @Override
    @NotNull
    public PyRunTargetVariant getTargetType() {
        return this.targetType;
    }

    public void setTargetType(@NotNull PyRunTargetVariant pyRunTargetVariant) {
        Intrinsics.checkNotNullParameter((Object)((Object)pyRunTargetVariant), (String)"<set-?>");
        this.targetType = pyRunTargetVariant;
    }

    public ConfigurationTarget(@NotNull String target, @NotNull PyRunTargetVariant targetType) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        this.target = target;
        this.targetType = targetType;
    }

    public static final /* synthetic */ List access$generatePythonTarget(ConfigurationTarget $this, String target, PyAbstractTestConfiguration configuration) {
        return $this.generatePythonTarget(target, configuration);
    }

    @NotNull
    public final String component1() {
        return this.getTarget();
    }

    @NotNull
    public final PyRunTargetVariant component2() {
        return this.getTargetType();
    }

    @NotNull
    public final ConfigurationTarget copy(@NotNull String target, @NotNull PyRunTargetVariant targetType) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        return new ConfigurationTarget(target, targetType);
    }

    public static /* synthetic */ ConfigurationTarget copy$default(ConfigurationTarget configurationTarget, String string, PyRunTargetVariant pyRunTargetVariant, int n, Object object) {
        if ((n & 1) != 0) {
            string = configurationTarget.getTarget();
        }
        if ((n & 2) != 0) {
            pyRunTargetVariant = configurationTarget.getTargetType();
        }
        return configurationTarget.copy(string, pyRunTargetVariant);
    }

    @NotNull
    public String toString() {
        return "ConfigurationTarget(target=" + this.getTarget() + ", targetType=" + (Object)((Object)this.getTargetType()) + ")";
    }

    public int hashCode() {
        String string = this.getTarget();
        PyRunTargetVariant pyRunTargetVariant = this.getTargetType();
        return (string != null ? string.hashCode() : 0) * 31 + (pyRunTargetVariant != null ? ((Object)((Object)pyRunTargetVariant)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ConfigurationTarget)) break block3;
                ConfigurationTarget configurationTarget = (ConfigurationTarget)object;
                if (!Intrinsics.areEqual((Object)this.getTarget(), (Object)configurationTarget.getTarget()) || !Intrinsics.areEqual((Object)((Object)this.getTargetType()), (Object)((Object)configurationTarget.getTargetType()))) break block3;
            }
            return true;
        }
        return false;
    }
}

