/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.lexer;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.lexer.EscapeUtilsKt;
import org.toml.lang.lexer.LexerBaseEx;
import org.toml.lang.psi.ElementTypesKt;
import org.toml.lang.psi.TomlElementTypes;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0014J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/toml/lang/lexer/TomlEscapeLexer;", "Lorg/toml/lang/lexer/LexerBaseEx;", "defaultToken", "Lcom/intellij/psi/tree/IElementType;", "eol", "", "(Lcom/intellij/psi/tree/IElementType;Z)V", "determineTokenType", "isValidUnicodeEscape", "start", "", "end", "locateToken", "unicodeTokenEnd", "expectedLength", "Companion", "intellij.toml.core"})
public final class TomlEscapeLexer
extends LexerBaseEx {
    private final IElementType defaultToken;
    private final boolean eol;
    @NotNull
    private static final TokenSet ESCAPABLE_LITERALS_TOKEN_SET;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    protected IElementType determineTokenType() {
        IElementType iElementType;
        if (this.getTokenStart() >= this.getTokenEnd()) {
            return null;
        }
        if (this.getBufferSequence().charAt(this.getTokenStart()) != '\\') {
            return this.defaultToken;
        }
        if (this.getTokenStart() + 1 >= this.getTokenEnd()) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        switch (this.getBufferSequence().charAt(this.getTokenStart() + 1)) {
            case 'U': 
            case 'u': {
                if (this.isValidUnicodeEscape(this.getTokenStart(), this.getTokenEnd())) {
                    iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                    break;
                }
                iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                break;
            }
            case '\n': 
            case '\r': {
                iElementType = EscapeUtilsKt.esc(this.eol);
                break;
            }
            case '\"': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                break;
            }
            default: {
                iElementType = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
        }
        return iElementType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidUnicodeEscape(int start, int end) {
        try {
            int value;
            CharSequence charSequence = this.getBufferSequence();
            int n = start + 2;
            boolean bl = false;
            charSequence = ((Object)charSequence.subSequence(n, end)).toString();
            n = 16;
            bl = false;
            int n2 = value = Integer.parseInt((String)charSequence, CharsKt.checkRadix((int)n));
            if (0 <= n2) {
                if (55295 >= n2) return true;
            }
            n2 = value;
            if (57344 > n2) return false;
            if (0x10FFFF < n2) return false;
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int locateToken(int start) {
        if (start >= this.getBufferEnd()) {
            return start;
        }
        if (this.getBufferSequence().charAt(start) == '\\') {
            int n;
            int i = start + 1;
            if (i >= this.getBufferEnd()) {
                return this.getBufferEnd();
            }
            switch (this.getBufferSequence().charAt(i)) {
                case 'u': {
                    n = this.unicodeTokenEnd(i + 1, 4);
                    break;
                }
                case 'U': {
                    n = this.unicodeTokenEnd(i + 1, 8);
                    break;
                }
                case '\n': 
                case '\r': {
                    void var3_4;
                    for (int j = i; j < this.getBufferEnd() && EscapeUtilsKt.isWhitespaceChar(this.getBufferSequence().charAt(j)); ++j) {
                    }
                    n = var3_4;
                    break;
                }
                default: {
                    n = i + 1;
                }
            }
            return n;
        }
        int idx = CharArrayUtil.indexOf((CharSequence)this.getBufferSequence(), (CharSequence)"\\", (int)(start + 1), (int)this.getBufferEnd());
        return idx != -1 ? idx : this.getBufferEnd();
    }

    /*
     * WARNING - void declaration
     */
    private final int unicodeTokenEnd(int start, int expectedLength) {
        int n = start;
        int n2 = start + expectedLength;
        while (n < n2) {
            void i;
            if (i >= this.getBufferEnd() || !StringUtil.isHexDigit((char)this.getBufferSequence().charAt((int)i))) {
                return start;
            }
            ++i;
        }
        return start + expectedLength;
    }

    private TomlEscapeLexer(IElementType defaultToken, boolean eol) {
        this.defaultToken = defaultToken;
        this.eol = eol;
    }

    static {
        Companion = new Companion(null);
        ESCAPABLE_LITERALS_TOKEN_SET = ElementTypesKt.getTOML_BASIC_STRINGS();
    }

    public /* synthetic */ TomlEscapeLexer(IElementType defaultToken, boolean eol, DefaultConstructorMarker $constructor_marker) {
        this(defaultToken, eol);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/toml/lang/lexer/TomlEscapeLexer$Companion;", "", "()V", "ESCAPABLE_LITERALS_TOKEN_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getESCAPABLE_LITERALS_TOKEN_SET", "()Lcom/intellij/psi/tree/TokenSet;", "of", "Lorg/toml/lang/lexer/TomlEscapeLexer;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "intellij.toml.core"})
    public static final class Companion {
        @NotNull
        public final TomlEscapeLexer of(@NotNull IElementType tokenType) {
            TomlEscapeLexer tomlEscapeLexer;
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            IElementType iElementType = tokenType;
            if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.BASIC_STRING)) {
                tomlEscapeLexer = new TomlEscapeLexer(TomlElementTypes.BASIC_STRING, false, null);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.MULTILINE_BASIC_STRING)) {
                tomlEscapeLexer = new TomlEscapeLexer(TomlElementTypes.MULTILINE_BASIC_STRING, true, null);
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported literal type: " + tokenType);
            }
            return tomlEscapeLexer;
        }

        @NotNull
        public final TokenSet getESCAPABLE_LITERALS_TOKEN_SET() {
            return ESCAPABLE_LITERALS_TOKEN_SET;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

