/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.enumerating;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.filters.KotlinCoroutinesFilter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinCoroutinesEnumeratingFilter
extends LineEnumeratorFilter {
    public void initFilter(MethodVisitor mv, LineEnumerator context) {
        super.initFilter(new TracingFilter(mv, context.getInstrumenter()), context);
    }

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinCoroutinesFilter.isApplicable(context, name, desc);
    }

    private class TracingFilter
    extends KotlinCoroutinesFilter {
        public TracingFilter(MethodVisitor methodVisitor, Instrumenter context) {
            super(methodVisitor, context);
        }

        protected void onIgnoredJump() {
            KotlinCoroutinesEnumeratingFilter.this.myContext.getBranchData().removeLastJump();
        }

        protected void onIgnoredSwitch(Label dflt, Label ... labels) {
            KotlinCoroutinesEnumeratingFilter.this.myContext.getBranchData().removeLastSwitch(dflt, labels);
        }
    }
}

