/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove.decorator;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.coverage.gnu.trove.TObjectLongHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectLongIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectLongHashMapDecorator<V>
extends AbstractMap<V, Long>
implements Map<V, Long> {
    protected final TObjectLongHashMap<V> _map;

    public TObjectLongHashMapDecorator(TObjectLongHashMap<V> map) {
        this._map = map;
    }

    @Override
    public Long put(V key, Long value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (val instanceof Long) {
                    V k = this.unwrapKey(key);
                    long v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        V k = this.unwrapKey(key);
        long v = this._map.get(k);
        if (v == 0L) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Long remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<V, Long>> entrySet() {
        return new AbstractSet<Map.Entry<V, Long>>(){

            @Override
            public int size() {
                return TObjectLongHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TObjectLongHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TObjectLongHashMapDecorator.this.containsKey(k) && TObjectLongHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<V, Long>> iterator() {
                return new Iterator<Map.Entry<V, Long>>(){
                    private final TObjectLongIterator<V> it;
                    {
                        this.it = TObjectLongHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<V, Long> next() {
                        this.it.advance();
                        final Object key = TObjectLongHashMapDecorator.this.wrapKey(this.it.key());
                        final Long v = TObjectLongHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<V, Long>(){
                            private Long val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public V getKey() {
                                return key;
                            }

                            @Override
                            public Long getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Long setValue(Long value) {
                                this.val = value;
                                return TObjectLongHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Long o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<V, Long>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TObjectLongHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends V, ? extends Long> map) {
        Iterator<Map.Entry<V, Long>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<V, Long> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected final V wrapKey(Object o) {
        return (V)o;
    }

    protected final V unwrapKey(Object key) {
        return (V)key;
    }

    protected Long wrapValue(long k) {
        return new Long(k);
    }

    protected long unwrapValue(Object value) {
        return (Long)value;
    }
}

