/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableShiftEnterHandler$actuallyFindRow$;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableShiftEnterHandler$findElement$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRowImpl;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u0006\u0010\u0017\u001a\u00020\u000eH\u0082\b\u00a2\u0006\u0002\u0010\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableShiftEnterHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "actuallyExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "actuallyFindRow", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "caretOffset", "", "executeWriteAction", "", "findElement", "T", "element", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "findRow", "document", "Lcom/intellij/openapi/editor/Document;", "isEnabledForCaret", "isProbablyAtTheEndOfTableRow", "intellij.markdown"})
public final class MarkdownTableShiftEnterHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler baseHandler;

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        EditorActionHandler editorActionHandler = this.baseHandler;
        return editorActionHandler != null && editorActionHandler.isEnabled(editor2, caret, dataContext);
    }

    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (this.actuallyExecute(editor2, caret, dataContext)) break block1;
            EditorActionHandler editorActionHandler = this.baseHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(editor2, caret, dataContext);
            }
        }
    }

    private final boolean actuallyExecute(Editor editor2, Caret caret, DataContext dataContext) {
        int caretOffset;
        Caret currentCaret;
        Document document;
        Project project;
        block10: {
            block9: {
                Project project2 = editor2.getProject();
                if (project2 == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"editor.project ?: return false");
                project = project2;
                if (!Registry.is((String)"markdown.tables.editing.support.enable") || !MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) {
                    return false;
                }
                Document document2 = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
                document = document2;
                Caret caret2 = caret;
                if (caret2 == null) {
                    CaretModel caretModel = editor2.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                    Caret caret3 = caretModel.getCurrentCaret();
                    caret2 = caret3;
                    Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"editor.caretModel.currentCaret");
                }
                currentCaret = caret2;
                caretOffset = currentCaret.getOffset();
                if (!TableUtils.isProbablyInsideTableCell(document, caretOffset) && !this.isProbablyAtTheEndOfTableRow(document, caretOffset)) break block9;
                CaretModel caretModel = editor2.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                if (caretModel.getCaretCount() == 1) break block10;
            }
            return false;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"documentManager.getPsiFi\u2026document) ?: return false");
        PsiFile file = psiFile;
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement psiElement = this.findRow(file, document, caretOffset);
        if (psiElement == null) {
            return false;
        }
        PsiElement row = psiElement;
        MarkdownTableImpl markdownTableImpl = TableUtils.findTable(row);
        if (markdownTableImpl == null) {
            return false;
        }
        MarkdownTableImpl table = markdownTableImpl;
        String string = TableModificationUtils.buildEmptyRow$default(TableModificationUtils.INSTANCE, table, null, 1, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"table.buildEmptyRow().toString()");
        String emptyRow = string;
        Project project$iv = table.getProject();
        String name$iv = null;
        String groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(emptyRow, document, caretOffset, currentCaret){
            final /* synthetic */ String $emptyRow$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $caretOffset$inlined;
            final /* synthetic */ Caret $currentCaret$inlined;
            {
                this.$emptyRow$inlined = string;
                this.$document$inlined = document;
                this.$caretOffset$inlined = n;
                this.$currentCaret$inlined = caret;
            }

            public final void run() {
                boolean bl = false;
                String content2 = '\n' + this.$emptyRow$inlined;
                int line = this.$document$inlined.getLineNumber(this.$caretOffset$inlined);
                int lineEndOffset = this.$document$inlined.getLineEndOffset(line);
                this.$document$inlined.insertString(lineEndOffset, (CharSequence)content2);
                this.$currentCaret$inlined.moveToOffset(this.$document$inlined.getLineEndOffset(line + 1));
            }
        }, name$iv, (Object)groupId$iv);
        return true;
    }

    private final PsiElement findRow(PsiFile file, Document document, int caretOffset) {
        PsiElement actual = this.actuallyFindRow(file, caretOffset);
        if (actual != null) {
            return actual;
        }
        if (caretOffset == 0 || document.getLineNumber(caretOffset) != document.getLineNumber(caretOffset - 1)) {
            return null;
        }
        return this.actuallyFindRow(file, caretOffset - 1);
    }

    private final /* synthetic */ <T> T findElement(PsiElement element2) {
        int $i$f$findElement = 0;
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Intrinsics.needClassReification();
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findElement$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Object sibling = SequencesKt.firstOrNull((Sequence)sequence);
        Object object = sibling;
        if (object == null) {
            $this$filterIsInstance$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            $i$f$filterIsInstance = false;
            Intrinsics.needClassReification();
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findElement$$inlined$filterIsInstance$2.INSTANCE);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            object = SequencesKt.firstOrNull((Sequence)sequence2);
        }
        return (T)object;
    }

    private final PsiElement actuallyFindRow(PsiFile file, int caretOffset) {
        PsiElement psiElement;
        Object primary;
        Object object;
        PsiElement psiElement2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiUtilCore.getElementAtOffset(file, caretOffset)");
        PsiElement element2 = psiElement2;
        Object this_$iv = this;
        boolean $i$f$findElement = false;
        Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Object sibling$iv = SequencesKt.firstOrNull((Sequence)sequence);
        Object object2 = sibling$iv;
        if (object2 == null) {
            $this$filterIsInstance$iv$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$2.INSTANCE);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            object2 = SequencesKt.firstOrNull((Sequence)sequence2);
        }
        MarkdownTableRowImpl markdownTableRowImpl = (MarkdownTableRowImpl)object2;
        if (markdownTableRowImpl != null) {
            this_$iv = markdownTableRowImpl;
            $i$f$findElement = false;
            boolean $this$filterIsInstance$iv$iv2 = false;
            Object it = this_$iv;
            boolean bl = false;
            object = !TableUtils.INSTANCE.isHeaderRow((MarkdownTableRowImpl)it) ? this_$iv : null;
        } else {
            object = null;
        }
        Object object3 = primary = object;
        if (object3 != null) {
            psiElement = (PsiElement)object3;
        } else {
            this_$iv = this;
            $i$f$findElement = false;
            Sequence $this$filterIsInstance$iv$iv3 = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
            $i$f$filterIsInstance = false;
            Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv3, (Function1)actuallyFindRow$$inlined$findElement$3.INSTANCE);
            if (sequence3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            sibling$iv = SequencesKt.firstOrNull((Sequence)sequence3);
            Object object4 = sibling$iv;
            if (object4 == null) {
                $this$filterIsInstance$iv$iv3 = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
                $i$f$filterIsInstance = false;
                Sequence sequence4 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv3, (Function1)actuallyFindRow$$inlined$findElement$4.INSTANCE);
                if (sequence4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                object4 = SequencesKt.firstOrNull((Sequence)sequence4);
            }
            psiElement = (PsiElement)object4;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isProbablyAtTheEndOfTableRow(Document document, int caretOffset) {
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence text = charSequence;
        int line = document.getLineNumber(caretOffset);
        int lineEndOffset = document.getLineEndOffset(line);
        int n = caretOffset;
        int n2 = lineEndOffset;
        while (n < n2) {
            void offset;
            switch (text.charAt((int)offset)) {
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++offset;
        }
        return true;
    }

    public MarkdownTableShiftEnterHandler(@Nullable EditorActionHandler baseHandler) {
        this.baseHandler = baseHandler;
    }
}

