/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cef.callback.CefStringVisitor;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownNotifier;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionFormat;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportSettings;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlExporter;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlResourceSavingSettings;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u001c\u0010\u001b\u001a\u00020\f*\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u001d\u001a\u00020\f*\u00020\u001cH\u0002J8\u0010\u001e\u001a\u00020\f*\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020%0$H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "()V", "formatDescription", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormatDescription", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "resourceDirField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "saveImagesCheckbox", "Ljavax/swing/JCheckBox;", "addSettingsListeners", "", "project", "Lcom/intellij/openapi/project/Project;", "createSettingsComponent", "Ljavax/swing/JComponent;", "suggestedTargetFile", "Ljava/io/File;", "exportFile", "mdFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputFile", "", "saveSettings", "validate", "file", "createResourceDirField", "Lcom/intellij/ui/layout/Cell;", "createSaveImageCheckbox", "saveHtml", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "path", "resDirPath", "Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;", "resultCallback", "Ljava/util/function/BiConsumer;", "", "Companion", "SaveSettingsListener", "intellij.markdown"})
public final class MarkdownHtmlExportProvider
implements MarkdownExportProvider {
    private JCheckBox saveImagesCheckbox;
    private final TextFieldWithHistoryWithBrowseButton resourceDirField = new TextFieldWithHistoryWithBrowseButton();
    private static final String IMAGE_DIR_RESENT_KEYS = "ImportExportFile.ImageDir.RECENT_KEYS";
    @NotNull
    private static final MarkdownFileActionFormat format;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public MarkdownFileActionFormat getFormatDescription() {
        return format;
    }

    @Override
    public void exportFile(@NotNull Project project, @NotNull VirtualFile mdFile, @NotNull String outputFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mdFile, (String)"mdFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        this.saveSettings(project);
        MarkdownPreviewFileEditor markdownPreviewFileEditor = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, mdFile, true);
        if (markdownPreviewFileEditor == null) {
            return;
        }
        MarkdownPreviewFileEditor preview = markdownPreviewFileEditor;
        MarkdownHtmlPanel markdownHtmlPanel = (MarkdownHtmlPanel)preview.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER);
        if (markdownHtmlPanel == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)markdownHtmlPanel, (String)"preview.getUserData(Mark\u2026REVIEW_BROWSER) ?: return");
        MarkdownHtmlPanel htmlPanel = markdownHtmlPanel;
        if (htmlPanel instanceof MarkdownJCEFHtmlPanel) {
            boolean $i$f$service = false;
            Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            this.saveHtml((MarkdownJCEFHtmlPanel)htmlPanel, outputFile, ((MarkdownHtmlExportSettings)object).getResourceSavingSettings(), project, new BiConsumer(project){
                final /* synthetic */ Project $project;

                public final void accept(@NotNull String path, @NotNull Boolean ok) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Intrinsics.checkNotNullParameter((Object)ok, (String)"ok");
                    if (ok.booleanValue()) {
                        MarkdownImportExportUtils.INSTANCE.notifyAndRefreshIfExportSuccess(new File(path), this.$project);
                    } else {
                        String string = MarkdownBundle.message("markdown.export.failure.msg", new File(path).getName());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026re.msg\", File(path).name)");
                        MarkdownNotifier.INSTANCE.notifyIfConvertFailed(this.$project, string);
                    }
                }
                {
                    this.$project = project;
                }
            });
        }
    }

    @Override
    @Nullable
    public String validate(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MarkdownPreviewFileEditor preview = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, file, true);
        if (preview == null || !MarkdownImportExportUtils.INSTANCE.isJCEFPanelOpen(preview)) {
            return MarkdownBundle.message("markdown.export.validation.failure.msg", this.getFormatDescription().getFormatName());
        }
        return null;
    }

    @Override
    @NotNull
    public JComponent createSettingsComponent(@NotNull Project project, @NotNull File suggestedTargetFile) {
        LayoutBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestedTargetFile, (String)"suggestedTargetFile");
        LCFlags[] constraints$iv = new LCFlags[]{LCFlags.fillX};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this, project, suggestedTargetFile){
            final /* synthetic */ MarkdownHtmlExportProvider this$0;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ File $suggestedTargetFile$inlined;
            {
                this.this$0 = markdownHtmlExportProvider;
                this.$project$inlined = project;
                this.$suggestedTargetFile$inlined = file;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Row this_$iv = $this$row;
                boolean isVerticalFlow$iv = false;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                MarkdownHtmlExportProvider.access$createSaveImageCheckbox(this.this$0, (Cell)$this$cell);
                MarkdownHtmlExportProvider.access$createResourceDirField(this.this$0, (Cell)$this$cell, this.$project$inlined, this.$suggestedTargetFile$inlined);
                MarkdownHtmlExportProvider.access$addSettingsListeners(this.this$0, this.$project$inlined);
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return (JComponent)panel$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void createSaveImageCheckbox(Cell $this$createSaveImageCheckbox) {
        void $this$apply;
        String string = MarkdownBundle.message("markdown.export.to.html.save.images.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ml.save.images.checkbox\")");
        JComponent jComponent = Cell.checkBox$default((Cell)$this$createSaveImageCheckbox, (String)string, (boolean)false, null, (int)6, null).getComponent();
        boolean bl = false;
        boolean bl2 = false;
        JBCheckBox jBCheckBox = (JBCheckBox)jComponent;
        MarkdownHtmlExportProvider markdownHtmlExportProvider = this;
        boolean bl3 = false;
        $this$apply.setToolTipText(MarkdownBundle.message("markdown.export.dialog.checkbox.tooltip", new Object[0]));
        boolean $i$f$service = false;
        Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        $this$apply.setSelected(((MarkdownHtmlExportSettings)object).getResourceSavingSettings().isSaved());
        Unit unit = Unit.INSTANCE;
        markdownHtmlExportProvider.saveImagesCheckbox = (JCheckBox)jComponent;
    }

    private final void createResourceDirField(Cell $this$createResourceDirField, Project project, File suggestedTargetFile) {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = this.resourceDirField;
        boolean bl = false;
        boolean bl2 = false;
        TextFieldWithHistoryWithBrowseButton $this$apply = textFieldWithHistoryWithBrowseButton;
        boolean bl3 = false;
        $this$apply.setTextFieldPreferredWidth(70);
        List resDirRecent = RecentsManager.getInstance((Project)project).getRecentEntries(IMAGE_DIR_RESENT_KEYS);
        if (resDirRecent != null) {
            TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)$this$apply.getChildComponent();
            Intrinsics.checkNotNullExpressionValue((Object)textFieldWithHistory, (String)"childComponent");
            textFieldWithHistory.setHistory(resDirRecent);
        }
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)$this$apply.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithHistory, (String)"childComponent");
        textFieldWithHistory.setText(FileUtil.join((String[])new String[]{suggestedTargetFile.getParent(), FilesKt.getNameWithoutExtension((File)suggestedTargetFile)}));
        $this$apply.addBrowseFolderListener(MarkdownBundle.message("markdown.import.export.dialog.target.directory", new Object[0]), MarkdownBundle.message("markdown.import.export.dialog.target.directory.description", new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        textFieldWithHistoryWithBrowseButton = Cell.invoke$default((Cell)$this$createResourceDirField, (JComponent)((JComponent)this.resourceDirField), (CCFlags[])new CCFlags[]{$this$createResourceDirField.getGrowX()}, null, null, (int)6, null);
        bl = false;
        bl2 = false;
        $this$apply = textFieldWithHistoryWithBrowseButton;
        boolean bl4 = false;
        $this$apply.withValidationOnApply((Function2)createResourceDirField.2.1.INSTANCE);
        $this$apply.focused();
        JCheckBox jCheckBox = this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
        }
        $this$apply.enableIf(ComponentPredicateKt.getSelected((AbstractButton)jCheckBox));
    }

    private final void addSettingsListeners(Project project) {
        JCheckBox jCheckBox = this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
        }
        jCheckBox.addChangeListener(new ChangeListener(this, project){
            final /* synthetic */ MarkdownHtmlExportProvider this$0;
            final /* synthetic */ Project $project;

            public final void stateChanged(ChangeEvent it) {
                MarkdownHtmlExportProvider.access$saveSettings(this.this$0, this.$project);
            }
            {
                this.this$0 = markdownHtmlExportProvider;
                this.$project = project;
            }
        });
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)this.resourceDirField.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithHistory, (String)"resourceDirField.childComponent");
        textFieldWithHistory.getTextEditor().addFocusListener(new SaveSettingsListener(project));
    }

    private final void saveSettings(Project project) {
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)this.resourceDirField.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithHistory, (String)"resourceDirField.childComponent");
        String imageDir = textFieldWithHistory.getText();
        boolean $i$f$service = false;
        Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        MarkdownHtmlExportSettings exportSettings = (MarkdownHtmlExportSettings)object;
        JCheckBox jCheckBox = this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
        }
        exportSettings.setSaveResources(jCheckBox.isSelected());
        String string = imageDir;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imageDir");
        exportSettings.setResourceDirectory(string);
        RecentsManager.getInstance((Project)project).registerRecentEntry(IMAGE_DIR_RESENT_KEYS, imageDir);
    }

    private final void saveHtml(MarkdownJCEFHtmlPanel $this$saveHtml, String path, HtmlResourceSavingSettings resDirPath, Project project, BiConsumer<String, Boolean> resultCallback) {
        $this$saveHtml.getCefBrowser().getSource(new CefStringVisitor(path, resDirPath, project, resultCallback){
            final /* synthetic */ String $path;
            final /* synthetic */ HtmlResourceSavingSettings $resDirPath;
            final /* synthetic */ Project $project;
            final /* synthetic */ BiConsumer $resultCallback;

            public final void visit(String source) {
                try {
                    File file = new File(this.$path);
                    String string = source;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source");
                    new HtmlExporter(string, this.$resDirPath, this.$project, file).export();
                    this.$resultCallback.accept(this.$path, true);
                }
                catch (Exception e) {
                    this.$resultCallback.accept(this.$path, false);
                }
            }
            {
                this.$path = string;
                this.$resDirPath = htmlResourceSavingSettings;
                this.$project = project;
                this.$resultCallback = biConsumer;
            }
        });
    }

    static {
        Companion = new Companion(null);
        format = new MarkdownFileActionFormat("HTML", "html");
    }

    public static final /* synthetic */ JCheckBox access$getSaveImagesCheckbox$p(MarkdownHtmlExportProvider $this) {
        JCheckBox jCheckBox = $this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
        }
        return jCheckBox;
    }

    public static final /* synthetic */ void access$setSaveImagesCheckbox$p(MarkdownHtmlExportProvider $this, JCheckBox jCheckBox) {
        $this.saveImagesCheckbox = jCheckBox;
    }

    public static final /* synthetic */ void access$createSaveImageCheckbox(MarkdownHtmlExportProvider $this, Cell $this$access_u24createSaveImageCheckbox) {
        $this.createSaveImageCheckbox($this$access_u24createSaveImageCheckbox);
    }

    public static final /* synthetic */ void access$createResourceDirField(MarkdownHtmlExportProvider $this, Cell $this$access_u24createResourceDirField, Project project, File suggestedTargetFile) {
        $this.createResourceDirField($this$access_u24createResourceDirField, project, suggestedTargetFile);
    }

    public static final /* synthetic */ void access$addSettingsListeners(MarkdownHtmlExportProvider $this, Project project) {
        $this.addSettingsListeners(project);
    }

    @NotNull
    public static final MarkdownFileActionFormat getFormat() {
        Companion companion = Companion;
        return format;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$SaveSettingsListener;", "Ljava/awt/event/FocusListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;Lcom/intellij/openapi/project/Project;)V", "focusGained", "", "e", "Ljava/awt/event/FocusEvent;", "focusLost", "intellij.markdown"})
    private final class SaveSettingsListener
    implements FocusListener {
        private final Project project;

        @Override
        public void focusGained(@Nullable FocusEvent e) {
        }

        @Override
        public void focusLost(@Nullable FocusEvent e) {
            FocusEvent focusEvent = e;
            Component component = focusEvent != null ? focusEvent.getComponent() : null;
            if (component == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.JTextField");
            }
            JTextField textEditor = (JTextField)component;
            if (MarkdownHtmlExportProvider.access$getSaveImagesCheckbox$p(MarkdownHtmlExportProvider.this).isSelected()) {
                String string = textEditor.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textEditor.text");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    MarkdownHtmlExportProvider.this.saveSettings(this.project);
                }
            }
        }

        public SaveSettingsListener(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$Companion;", "", "()V", "IMAGE_DIR_RESENT_KEYS", "", "Lorg/jetbrains/annotations/NonNls;", "format", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormat$annotations", "getFormat", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "intellij.markdown"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getFormat$annotations() {
        }

        @NotNull
        public final MarkdownFileActionFormat getFormat() {
            return format;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

