/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.google.api.client.auth.oauth2.Credential;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequest;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.utils.GoogleCredentialUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleAuthorizationManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createNewAccount", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "getCredentials", "Lcom/google/api/client/auth/oauth2/Credential;", "intellij.markdown"})
public final class GoogleAuthorizationManager {
    private final Project project;

    @Nullable
    public final Credential getCredentials() {
        GoogleCredentials googleCredentials = this.createNewAccount();
        if (googleCredentials == null) {
            return null;
        }
        GoogleCredentials credentials = googleCredentials;
        return GoogleCredentialUtils.INSTANCE.createCredentialsForGoogleApi(credentials);
    }

    private final GoogleCredentials createNewAccount() {
        GoogleCredentialUtils.GoogleAppCredentials googleAppCredentials = GoogleCredentialUtils.INSTANCE.getGoogleAppCredentials(this.project);
        if (googleAppCredentials == null) {
            return null;
        }
        GoogleCredentialUtils.GoogleAppCredentials googleAppCred = googleAppCredentials;
        boolean $i$f$service = false;
        Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        GoogleOAuthService oAuthService = (GoogleOAuthService)((Object)object);
        CompletableFuture credentialsFuture = oAuthService.authorize(new GoogleOAuthRequest(googleAppCred));
        try {
            return (GoogleCredentials)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(credentialsFuture){
                final /* synthetic */ CompletableFuture $credentialsFuture;

                public final GoogleCredentials compute() {
                    return (GoogleCredentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$credentialsFuture);
                }
                {
                    this.$credentialsFuture = completableFuture;
                }
            }, MarkdownBundle.message("markdown.google.account.login.progress.title", new Object[0]), true, this.project);
        }
        catch (ProcessCanceledException e) {
            credentialsFuture.cancel(true);
            return null;
        }
    }

    public GoogleAuthorizationManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

